package org.seasar.jsf.template.impl;

import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.template.NodeHandler;
import org.w3c.dom.Node;

/**
 * @author higa
 *
 */
public class UITextNodeHandler implements NodeHandler {

	public UITextNodeHandler() {
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#isHandleable(org.w3c.dom.Node)
	 */
	public boolean isHandleable(Node node) {
		return node.getNodeType() == Node.TEXT_NODE;
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#createComponentFactory(org.w3c.dom.Node)
	 */
	public ComponentFactory createComponentFactory(Node node) {
		return new UITextNodeFactory(node);
	}

}
