package org.seasar.jsf.template.impl;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentFactory;
import org.seasar.jsf.template.NodeHandler;
import org.w3c.dom.Node;

/**
 * @author higa
 *  
 */
public class ForEachHandler implements NodeHandler {

	public ForEachHandler() {
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#isHandleable(org.w3c.dom.Node)
	 */
	public boolean isHandleable(Node node) {
		return node.getNodeType() == Node.ELEMENT_NODE
				&& node.getNodeName().equalsIgnoreCase(JsfConstants.SPAN_ELEM)
				&& JsfConstants.FOREACH_VALUE.equalsIgnoreCase(node
						.getAttributes().getNamedItem(JsfConstants.TYPE_ATTR)
						.getNodeValue());
	}

	/**
	 * @see org.seasar.jsf.template.NodeHandler#createComponentFactory(org.w3c.dom.Node)
	 */
	public ComponentFactory createComponentFactory(Node node) {
		return new ForEachFactory(node);
	}

}