package org.seasar.jsf.template.impl;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.ForEach;
import org.seasar.jsf.util.BindingUtil;
import org.w3c.dom.Node;

/**
 * @author higa
 *  
 */
public class ForEachFactory extends AbstractComponentFactory {

	/**
	 * @param node
	 */
	public ForEachFactory(Node node) {
		super(node);
		addCustomPropertyName(JsfConstants.ITEMS_ATTR);
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		String itemsRef = (String) getProperty(JsfConstants.ITEMS_ATTR);
		if (!StringUtil.isEmpty(itemsRef)) {
			if (BindingUtil.isValueReference(itemsRef)) {
				FacesContext ctx = FacesContext.getCurrentInstance();
				Application app = ctx.getApplication();
				ValueBinding binding = app.createValueBinding(itemsRef);
				component.setValueBinding(JsfConstants.ITEMS_ATTR, binding);
			}
		}
	}

	/**
	 * @see org.seasar.jsf.template.ComponentFactory#createComponent()
	 */
	public UIComponent createComponent() {
		ForEach component = new ForEach();
		setProperties(component);
		return component;
	}
}