package org.seasar.jsf.component;

import java.io.IOException;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.w3c.dom.EntityReference;

/**
 * @author higa
 *  
 */
public class UIEntityReferenceNode extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.seasar.jsf.EntityReferenceNode";

	public static final String COMPONENT_FAMILY = "org.seasar.jsf.EntityReferenceNode";

	private static final String DEFAULT_RENDERER_TYPE = "org.seasar.jsf.EntityReferenceNode";

	private String nodeName_;

	public UIEntityReferenceNode() {
	}

	public UIEntityReferenceNode(EntityReference entityReference) {
		nodeName_ = entityReference.getNodeName();
		setRendererType(DEFAULT_RENDERER_TYPE);
	}

	/**
	 * @see javax.faces.component.UIComponent#getFamily()
	 */
	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public void encodeBegin(FacesContext context) throws IOException {
		if (context == null) {
			throw new NullPointerException("context");
		}
		if (!isRendered()) {
			return;
		}
		ResponseWriter out = context.getResponseWriter();
		out.write("&");
		out.write(nodeName_);
		out.write(";");
	}

	public void encodeEnd(FacesContext context) throws IOException {
		if (context == null) {
			throw new NullPointerException("context");
		}
		if (!isRendered()) {
			return;
		}
	}
	
	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = nodeName_;
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		nodeName_ = (String) values[1];
	}
}