package org.seasar.jsf.component;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

/**
 * @author higa
 *  
 */
public class UIElementNode extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.seasar.jsf.ElementNode";

	public static final String COMPONENT_FAMILY = "javax.faces.Output";

	private static final String DEFAULT_RENDERER_TYPE = "org.seasar.jsf.Tag";

	private String tagName_;

	public UIElementNode() {
		setRendererType(DEFAULT_RENDERER_TYPE);
	}

	/**
	 * @see javax.faces.component.UIComponent#getFamily()
	 */
	public String getFamily() {
		return COMPONENT_FAMILY;
	}
	
	public String getTagName() {
		return tagName_;
	}
	
	public void setTagName(String tagName) {
		tagName_ = tagName;
	}

	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = tagName_;
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		tagName_ = (String) values[1];
	}
}