package org.seasar.jsf.component;

import java.io.IOException;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.w3c.dom.CDATASection;

/**
 * @author higa
 *  
 */
public class UICDATASectionNode extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.seasar.jsf.CDATASectionNode";

	public static final String COMPONENT_FAMILY = "org.seasar.jsf.CDATASectionNode";

	private static final String DEFAULT_RENDERER_TYPE = "org.seasar.jsf.CDATASectionNode";

	private String data_;

	public UICDATASectionNode() {
	}

	public UICDATASectionNode(CDATASection cdataSection) {
		data_ = cdataSection.getData();
		setRendererType(DEFAULT_RENDERER_TYPE);
	}

	/**
	 * @see javax.faces.component.UIComponent#getFamily()
	 */
	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public void encodeBegin(FacesContext context) throws IOException {
		if (context == null) {
			throw new NullPointerException("context");
		}
		if (!isRendered()) {
			return;
		}
		ResponseWriter out = context.getResponseWriter();
		out.write("<![CDATA[");
		out.write(data_);
		out.write("]]>");
	}

	public void encodeEnd(FacesContext context) throws IOException {
		if (context == null) {
			throw new NullPointerException("context");
		}
		if (!isRendered()) {
			return;
		}
	}
	
	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = data_;
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		data_ = (String) values[1];
	}
}