package org.maachang.jni.io ;

import java.nio.ByteBuffer;

/**
 * DirectByteBufferをNativeBuffer操作するオブジェクト.
 * 
 * @version 2010/06/04
 * @author  masahito suzuki
 * @since   SeabassNativeIO-1.0.0
 */
public class MemoryByteBuffer extends AbstractNativeBuffer {
    private ByteBuffer buf = null ;
    
    /**
     * コンストラクタ.
     */
    public MemoryByteBuffer() {
        
    }
    
    /**
     * コンストラクタ.
     * @param byteBuffer 対象のByteBufferを設定します.
     * @exception Exception 例外.
     */
    public MemoryByteBuffer( ByteBuffer buf )
        throws Exception {
        this.create( buf ) ;
    }
    
    /**
     * コンストラクタ.
     * @param byteBuffer 対象のByteBufferを設定します.
     * @param offset 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @exception Exception 例外.
     */
    public MemoryByteBuffer( ByteBuffer buf,int offset,int length )
        throws Exception {
        this.create( buf,offset,length ) ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        clear() ;
    }
    
    /**
     * 情報生成.
     * @param byteBuffer 対象のByteBufferを設定します.
     * @exception Exception 例外.
     */
    public void create( ByteBuffer buf )
        throws Exception {
        clear() ;
        this.address = Unsafe.getDirectByteBufferNativeAddress( buf ) ;
        this.length = buf.capacity() ;
        this.buf = buf ;
    }
    
    /**
     * 情報生成.
     * @param byteBuffer 対象のByteBufferを設定します.
     * @param offset 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @exception Exception 例外.
     */
    public void create( ByteBuffer buf,int offset,int length )
        throws Exception {
        clear() ;
        this.address = Unsafe.getDirectByteBufferNativeAddress( buf ) + offset ;
        this.length = length ;
        this.buf = buf ;
    }
    
    /**
     * メモリクリア.
     */
    public void clear() {
        buf = null ;
        address = 0L ;
        length = 0 ;
    }
    
    /**
     * ByteBufferを取得.
     * @return ByteBuffer ByteBufferオブジェクトが返されます.
     */
    public ByteBuffer getByteBuffer() {
        return buf ;
    }
    
    /**
     * positionを取得.
     * @return int ByteBufferのポジションが返されます.
     */
    public int position() {
        return buf.position() ;
    }
    
    /**
     * positionを設定.
     * @param pos ByteBufferのポジションを設定します.
     */
    public void position( int pos ) {
        buf.position( pos ) ;
    }
    
    /**
     * limitを取得.
     * @return int ByteBufferのリミットが返されます.
     */
    public int limit() {
        return buf.limit() ;
    }
    
    /**
     * limitを設定.
     * @param lim ByteBufferのリミットを設定します.
     */
    public void limit( int lim ) {
        buf.limit( lim ) ;
    }
}

