/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jni.io;

import java.io.IOException;
import org.maachang.jni.io.AbstractFastNativeBuffer;
import org.maachang.jni.io.MmapBuffer;
import org.maachang.jni.io.MmapBufferImpl;
import org.maachang.jni.io.NativeIO;
import org.maachang.jni.io.NativeRandomIO;

class FastMmapBufferImpl
extends AbstractFastNativeBuffer
implements MmapBuffer {
    protected long handle;
    protected long firstAddress;
    protected int memoryLength;
    protected long offsetLength;
    protected int opt;
    protected NativeRandomIO io;
    protected long seqNo;

    private FastMmapBufferImpl() {
    }

    protected FastMmapBufferImpl(NativeRandomIO io, long offset, int length) throws Exception {
        int mmapLength;
        long[] out;
        if (!io.isOpen()) {
            throw new IOException("mmap\u53c2\u7167\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (offset < 0L || length <= 0) {
            throw new IllegalArgumentException("mmap\u6307\u5b9a\u7bc4\u56f2\u306f\u7bc4\u56f2\u5916\u3067\u3059(off:" + offset + " len:" + length + ")");
        }
        int opt = io.getOption() == 0 ? 1 : 2;
        long srcOffset = offset;
        int srcLength = length;
        offset = MmapBufferImpl.getOffsetToPageSize(offset);
        long addOffset = srcOffset - offset;
        length = MmapBufferImpl.getLengthToPageSize(length + (int)addOffset);
        long allLen = offset + (long)length;
        if (NativeIO.getLength(io.handle) < allLen) {
            NativeIO.setLength(io.handle, allLen);
        }
        if (NativeIO.createMmap(out = new long[2], io.handle, opt, offset, mmapLength = NativeIO.mmapLength(srcLength)) != 0) {
            throw new IOException("Mmap\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f(name:" + io.getName() + " off:" + offset + " len:" + length + ")");
        }
        long addr = out[0];
        this.address = addr + addOffset;
        this.length = srcLength;
        this.handle = out[1];
        this.firstAddress = addr;
        this.memoryLength = mmapLength;
        this.offsetLength = allLen;
        this.opt = opt;
        this.io = io;
        this.seqNo = io._seq.get();
        io._mmapManager.put(this.seqNo, this);
    }

    protected void finalize() throws Exception {
        this.clear();
        this.io = null;
    }

    @Override
    public void clear() {
        if (this.firstAddress != 0L) {
            NativeIO.closeMmap(this.handle, this.firstAddress, this.memoryLength);
            this.handle = -1L;
            this.firstAddress = 0L;
            this.memoryLength = -1;
            this.address = 0L;
            this.length = 0;
            this.offsetLength = 0L;
            this.io._mmapManager.remove(this.seqNo);
            this.seqNo = -1L;
        }
    }

    @Override
    public void reCreate(long offset, int length) throws Exception {
        int mmapLength;
        long[] out;
        if (!this.io.isOpen()) {
            throw new IOException("mmap\u53c2\u7167\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (offset < 0L || length <= 0) {
            throw new IllegalArgumentException("mmap\u6307\u5b9a\u7bc4\u56f2\u306f\u7bc4\u56f2\u5916\u3067\u3059(off:" + offset + " len:" + length + ")");
        }
        this.clear();
        long srcOffset = offset;
        int srcLength = length;
        offset = MmapBufferImpl.getOffsetToPageSize(offset);
        long addOffset = srcOffset - offset;
        length = MmapBufferImpl.getLengthToPageSize(length + (int)addOffset);
        long allLen = offset + (long)length;
        if (NativeIO.getLength(this.io.handle) < allLen) {
            NativeIO.setLength(this.io.handle, allLen);
        }
        if (NativeIO.createMmap(out = new long[2], this.io.handle, this.opt, offset, mmapLength = NativeIO.mmapLength(srcLength)) != 0) {
            throw new IOException("Mmap\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f(name:" + this.io.getName() + " off:" + offset + " len:" + length + ")");
        }
        long addr = out[0];
        this.address = addr + addOffset;
        this.length = srcLength;
        this.handle = out[1];
        this.firstAddress = addr;
        this.memoryLength = mmapLength;
        this.offsetLength = allLen;
        this.seqNo = this.io._seq.get();
        this.io._mmapManager.put(this.seqNo, this);
    }

    @Override
    public void flush() throws Exception {
        if (this.opt == 1) {
            return;
        }
        if (this.address == 0L) {
            throw new IllegalStateException("\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (!this.io.isOpen()) {
            throw new IOException("mmap\u53c2\u7167\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (NativeIO.flushMmap(this.firstAddress, this.memoryLength) != 0) {
            throw new IOException("mmap\u5f37\u5236\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    @Override
    public NativeRandomIO getFileObject() throws Exception {
        if (!this.io.isOpen()) {
            throw new IOException("mmap\u53c2\u7167\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.io;
    }

    @Override
    public boolean isFileClose() {
        return !this.io.isOpen();
    }

    @Override
    public int getOption() {
        return this.opt;
    }

    @Override
    public long getOffsetLength() {
        return this.offsetLength;
    }
}

