package com.jm.db;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DatabaseHelper extends SQLiteOpenHelper {
	private static DatabaseHelper instance = null;

	public static DatabaseHelper getInstance()
	{
		return instance;
	}
	
	public DatabaseHelper(Context context) {
		super(context, "JuggleMaster.db", null, 1);
		instance = this;
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.beginTransaction();
		try {
			Dao.getInstance().init(db);
			db.setTransactionSuccessful();
		}
		catch (SQLException e){
			throw e;
		} finally {
			db.endTransaction();
		}
	}

	@Override
	public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {

	}

}
