//
// `qr[A̓yƂȂTvvÔS
// ʃZT̋@\
//
// Update: 2011/05/01
// Support URL: http://www.trust-technology.co.jp/smartphoneworld
//
// Copyright (C)2011 Trust Technology Co., Ltd. All Rights Reserved.
//

package jp.co.cqpub.ARView;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;

public class ARViewActivity extends Activity implements SensorEventListener {
	
	// CameraPreview̃CX^XActivitỹoϐƂĐ錾
	CameraPreview cameraPreview;
	
    GLSurfaceView glSurfaceView;
    CubeRenderer cubeRenderer;
    
	// ZT}l[W̃CX^XActivitỹoϐƂĐ錾
	SensorManager sensorManager;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.main);
        
        // ^Cgo[
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // OpenGL`pGLSurfaceView𐶐
        glSurfaceView = new GLSurfaceView(this);
        glSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        cubeRenderer = new CubeRenderer(true);
        glSurfaceView.setRenderer(cubeRenderer);
        glSurfaceView.getHolder().setFormat(PixelFormat.TRANSLUCENT);

        // J̃vr[pNX̃CX^X𐶐
        cameraPreview = new CameraPreview(this);
        
        // J̃vr[OpenGL̃r[d˂ĕ\
        setContentView(glSurfaceView);
        addContentView(cameraPreview, new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));

        // ZT}l[WVXeT[rX擾
        sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
    }

    @Override
    protected void onResume() {
        super.onResume();
        
        // ZT}l[WɕʃZT̃Xio^
        sensorManager.registerListener(this,
                sensorManager.getDefaultSensor(Sensor.TYPE_ORIENTATION),
                SensorManager.SENSOR_DELAY_FASTEST);
     }
    
    @Override
    protected void onStop() {
    	// ZT}l[W烊Xi
        sensorManager.unregisterListener(this);
        super.onStop();
    }

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSensorChanged(SensorEvent event) {
	    // MZT̎ʂʃZT̏ꍇ
        if( event.sensor.getType() == Sensor.TYPE_ORIENTATION ){

	    	// [Ȃ̂łXOx镪␳
	    	float orientation = event.values[0] + 90;
	    	if( orientation > 360 )
	    		orientation -= 360;

	        // k̊px͈̔͂QVO`XOx|PWO`PWOxɕϊ
	        float theta;
	        if( orientation <= 180 )
	        	theta = orientation;
	        else
	        	theta = orientation - 360;
	        
	        // pxwWi|PDO`PDOj߂
	        if( theta >= -90 && theta <= 90 ){
		        float sint = (float) Math.sin( Math.PI / 180 * theta );
	        	cubeRenderer.CenterX = -1* sint*10;
	        }
        
        }
	}
}

