
Rails Starter Memo
==================

About
-----

Railsのテスト環境についてあれこれ導入するとかなり手間がかかる．
ここでいうテスト環境はrspec, factory_girl, spork, guardなどを
使ったTDD(と言っていいのか．．．？)な開発環境のことを指す．

というわけで，こういったテスト環境のセットアップを自動化して，
それなりの環境をてっとりばやく構築できるようにする．

と思ったら，そんな記事が存在していた．
これを自動化すればいいね！(ぇ

[rspec, factory_girl, spork, guardによる自動テスト環境の構築 - naoty.to_s](http://naoty.hatenablog.com/entry/20110824/1314204524)
[Rails3+RSpec2+Spork+Guard(guard-rspec,guard-cucumber)で最速のBDD(振舞駆動開発)環境を作る - Curiocity Drives me](http://curiosity-drives.me/programming/rails/rails3-rspec2-spork-guard-guard-rspec-guard-cucumber-bdd/)

Target
------

* Rails3 以上
* Ruby 1.9.3 以上


目標
----

1. rspec, factory_girlによるテスト環境
2. spork, guardによる自動テストの実行


内容
----

### rspec, factory_girlによるテスト環境

1. rails新規作成時に-T(skip-test-unit)をつける
2. Gemfilesを編集
```ruby
group :development, :test do
  gem 'rspec-rails'
  gem 'factory_girl'
  gem 'factory_girl_rails'
end
```
3. `bundle install`を実行する
4. `rails g spec:install`を実行(spec_helper.rbの生成)
5. Generatorの変更設定
```ruby
# config/application.rb

module Antibotch
  class Application < Rails::Application

    # ...

    # Configure sensitive parameters which will be filtered from the log file.
    config.filter_parameters += [:password]
    
    # Configure file type generated by 'rails generate'
    config.generators do |g|
      g.orm                 :active_record
      g.template_engine     :haml
      g.test_framework      :rspec, fixture: true, views_specs: false
      g.fixture_replacement :factory_girl, dir: 'spec/support/factories'
    end
  end
end
```

```ruby
# spec/spec_helper.rb
# fixtureをデフォルトからfactory_girlに切り替える

# This file is copied to spec/ when you run 'rails generate rspec:install'
ENV["RAILS_ENV"] ||= 'test'
require File.expand_path("../../config/environment", __FILE__)
require 'rspec/rails'
require 'factory_girl' # 追加

# ...

RSpec.configure do |config|
  # ...

  # Remove this line if you're not using ActiveRecord or ActiveRecord fixtures
  # config.fixture_path = "#{::Rails.root}/spec/fixtures" # コメントアウト

  # ...
end
```

### spork, guardによる自動テスト実行環境

1. Gemfilesを編集
```ruby
group :development, :test do
  gem 'rspec-rails'
  gem 'factory_girl'
  gem 'factory_girl_rails'
  gem 'spork'           # 追記
  gem 'guard-rspec'     # 追記
  gem 'guard-spork'     # 追記
end
```
2. `bundle install`を実行する
3. `bundle exec spork --bootstrap`でrspec_helper.rbの自動編集
4. rspec_helper.rbを手動編集する
```ruby
# spec/spec_helper.rb

require 'rubygems'
require 'spork'

Spork.prefork do
  # 元のspec_helper.rbのコード
end

Spork.each_run do
end
```
5. spork単体で稼働するかどうかのテストを実施
```sh
$ bundle exec spork
$ bundle exec rspec -X spec/**/*.rb 
```
6. guard設定の自動生成 -> Guardfileが生成される
```sh
$ bundle exec guard init spork
$ bundle exec guard init rspec
```
7. Guardfileを編集する
```ruby
# :test_unit => false でTest::Unitのsporkを立ち上げないようにする
# これを設定しないとDRbサーバー立ち上げでこけて，guard全体の起動が遅くなる
guard 'spork', :cucumber_env => { 'RAILS_ENV' => 'test' }, :rspec_env => { 'RAILS_ENV' => 'test' }, :test_unit => false do
  watch('config/application.rb')
  watch('config/environment.rb')
  watch(%r{^config/environments/.+\.rb$})
  watch(%r{^config/initializers/.+\.rb$})
  watch('Gemfile')
  watch('Gemfile.lock')
  watch('spec/spec_helper.rb') { :rspec }
  watch('test/test_helper.rb') { :test_unit }
  watch(%r{features/support/}) { :cucumber }
end

guard 'rspec', :version => 2, :cli => '--drb' do
  watch(%r{^spec/.+_spec\.rb$})
  watch(%r{^lib/(.+)\.rb$})     { |m| "spec/lib/#{m[1]}_spec.rb" }
  watch('spec/spec_helper.rb')  { "spec" }

  # Rails example
  watch(%r{^app/(.+)\.rb$})                           { |m| "spec/#{m[1]}_spec.rb" }
  watch(%r{^app/(.*)(\.erb|\.haml)$})                 { |m| "spec/#{m[1]}#{m[2]}_spec.rb" }
  watch(%r{^app/controllers/(.+)_(controller)\.rb$})  { |m| ["spec/routing/#{m[1]}_routing_spec.rb", "spec/#{m[2]}s/#{m[1]}_#{m[2]}_spec.rb", "spec/acceptance/#{m[1]}_spec.rb"] }
  watch(%r{^spec/support/(.+)\.rb$})                  { "spec" }
  watch('config/routes.rb')                           { "spec/routing" }
  watch('app/controllers/application_controller.rb')  { "spec/controllers" }
  # Capybara request specs
  watch(%r{^app/views/(.+)/.*\.(erb|haml)$})          { |m| "spec/requests/#{m[1]}_spec.rb" }
end
```

<!-- vim: set ft=markdown fdm=marker fenc=utf-8 ts=4 sw=4 : -->
