
tmux Install Memo
=================

What 'tmux'
----------

高機能なscreenみたいな奴．

```sh
$ apt-cache show tmux
...
Description-en: terminal multiplexer
 tmux enables a number of terminals (or windows) to be accessed and
 controlled from a single terminal like screen. tmux runs as a
 server-client system. A server is created automatically when necessary
 and holds a number of sessions, each of which may have a number of
 windows linked to it. Any number of clients may connect to a session,
 or the server may be controlled by issuing commands with tmux.
 Communication takes place through a socket, by default placed in /tmp.
 Moreover tmux provides a consistent and well-documented command
 interface, with the same syntax whether used interactively, as a key
 binding, or from the shell. It offers a choice of vim or Emacs key
 layouts.
Homepage: http://tmux.sourceforge.net/
...  ```


Installation
------------

### Environment

| OS   | Ubuntu 12.04.1 LTS                                         | 
| bash | GNU bash, バージョン 4.2.24(1)-release (i686-pc-linux-gnu) | 


### Command

```sh
$ sudo apt-get install tmux
```


Usage
-----

### Launch

At first, open terminal, and type:

	$ tmux

So then, tmux shell lounch current terminal buffer.


### Session / Client / Window

<!-- I want to make definition list but github's parse is ... -->
session
:	tmuxが管理している端末ウィンドウの集合体

client
:	セッションにアタッチしているtty

window
:	セッションの中で開かれている独立した端末
	

```sh
$ tmux list-session
0: 1 windows (created Fri Aug 17 14:07:50 2012) [150x39] (attached)
$ tmux list-client
/dev/pts/4: 0 [40x150 xterm] (utf8)
$ tmux list-window
0: bash [150x39] [layout 35df,150x39,0,0] (active)
```

### Key mappings

|キーバインド|コマンド|
|------------|--------|
| C-b?   | ショートカットキーのリストを表示 | 
| C-bc   | 新しいウィンドウを作成           | 
| C-bn   | 次のウィンドウへ移動             | 
| C-bp   | 前のウィンドウへ移動             | 
| C-bw   | ウィンドウの選択メニューを表示   | 
| C-bd   | セッションのデタッチ             | 
| C-b:   | コマンドプロンプトの開始         | 
| C-b\[  | コピーモードの開始               | 
| C-b\]  | バッファ内容のペースト           | 
| C-bq   | ペインのインジケータを表示       | 
| C-bt   | ペイン全体に時計を表示           | 
| C-b%   | ウィンドウを左右のペインに分割   | 
| C-bo   | 次のペインへ移動                 | 
| C-b{   | ペインの入れ替え                 | 
| C-b}   | ペインの入れ替え(逆順)           | 
| C-bM-↑ | ペインの上下分割位置を上へ移動   | 
| C-bM-↓ | ペインの上下分割位置を下へ移動   | 
| C-bM-← | ペインの左右分割位置を左へ移動   | 
| C-bM-→ | ペインの左右分割位置を右へ移動   | 
| C-bx   | ペインの破棄                     | 


Reference
---------

[マルチターミナルプレクサtmuxを使ってみよう](http://gihyo.jp/admin/serial/01/ubuntu-recipe/0127?page=3)

[tmuxの使い方メモ@editnuki](http://d.hatena.ne.jp/editnuki/20120106/1325871247)



<!-- vim: set ft=markdown fdm=marker fenc=utf-8 ts=4 sw=4 : -->
