# coding:utf-8

require File.expand_path("../spec_helper", __FILE__)
require 'task_helper'

describe TaskHelper do
  describe "path_cls2file" do
    it "returns relative path from lib for Hoge::Fuga" do
      TaskHelper.path_cls2file("Hoge::Fuga").should == 
        Pathname(SpecHelper::Const::LibRoot) + "hoge/fuga.rb"
    end
    it "returns relative path from lib for HogeFuga::PiyoFoo::BazBar" do
      TaskHelper.path_cls2file("HogeFuga::PiyoFoo::BazBar").should == 
        Pathname(SpecHelper::Const::LibRoot) + "hoge_fuga/piyo_foo/baz_bar.rb"
    end
    it "returns relative path from spec for HogeFuga::PiyoFoo::BazBar" do
      TaskHelper.path_cls2file("HogeFuga::PiyoFoo::BazBar", "spec").should == 
        Pathname(SpecHelper::Const::SpecRoot) + "hoge_fuga/piyo_foo/baz_bar.rb"
    end
  end

  describe ".trace_modules" do
    it "returns ruby source which module nested for Hoge::Fuga::Piyo" do
      TaskHelper.trace_modules(%w[Fuga Hoge], "class Piyo\nend").should == (<<-EOS).chomp
module Hoge
  module Fuga
    class Piyo
    end
  end
end
      EOS
    end
  end

  describe ".source_template" do
    it "returns source file skelton for Hoge::Fuga" do
      TaskHelper.source_template("Fuga", %w[Hoge], "module").should == <<-EOS
#!/usr/bin/env ruby
# coding:utf-8

module Hoge
  module Fuga
  end
end

      EOS
    end

    it "returns source file skelton for Hoge::Fuga::Piyo" do
      TaskHelper.source_template("Piyo", %w[Fuga Hoge], "class").should == <<-EOS
#!/usr/bin/env ruby
# coding:utf-8

module Hoge
  module Fuga
    class Piyo
    end
  end
end

      EOS
    end
  end

  describe ".spec_template" do
    it "returns spec file skelton for Hoge::Fuga::Piyo" do
      TaskHelper.spec_template("Piyo", %w[Fuga Hoge]).should == <<-EOS
# coding:utf-8
require File.expand_path('../..', __FILE__)

describe Hoge::Fuga::Piyo do
  it "truth" do
    1.should == 1
  end
end

      EOS
    end

    it "returns spec file skelton for Foo::Baz" do
      TaskHelper.spec_template("Baz", %w[Foo]).should == <<-EOS
# coding:utf-8
require File.expand_path('..', __FILE__)

describe Foo::Baz do
  it "truth" do
    1.should == 1
  end
end

      EOS
    end
  end

  # TODO : method_missing
end

