# coding:utf-8

require File.expand_path("../../spec_helper", __FILE__)

TEST_STR =<<-EOS.chomp
Lorem ipsum dolor sit amet, 
consectetur adipisicing elit, 
sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
EOS

describe Ext::String do
  it "extends String" do
    String.instance_methods.should include(:indent)
    String.instance_methods.should include(:underscore)
  end

  describe "#indent" do
    it "inserts 2 spaces to head of each lines" do
      TEST_STR.indent.should ==<<-EOS.chomp
  Lorem ipsum dolor sit amet, 
  consectetur adipisicing elit, 
  sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
      EOS
    end

    it "inserts specified spaces to head of each lines" do
      TEST_STR.indent(10).should ==<<-EOS.chomp
          Lorem ipsum dolor sit amet, 
          consectetur adipisicing elit, 
          sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
      EOS
      TEST_STR.indent(7).should ==<<-EOS.chomp
       Lorem ipsum dolor sit amet, 
       consectetur adipisicing elit, 
       sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
      EOS
    end
  end

  describe "underscore" do
    it "returns under socore case string from camel case" do
      "HakureiReimu".underscore.should == "hakurei_reimu"
    end

    it "returns under socore case with '::' jointment" do
      "HakuGyokuRou::KonpakuYoumu".underscore.should == 
        "haku_gyoku_rou/konpaku_youmu"
        #"haku_gyoku_rou/myon"
    end
  end
end

