# coding:utf-8

require File.expand_path("../../spec_helper", __FILE__)

describe Ext::Pathname do
  it "extends Pathname" do
    Pathname.instance_methods.should include(:ext)
  end

  describe ".ext" do
    before do
      @tmp_txt = SpecHelper.tmpfile
      @tmp_dir = @tmp_txt.dirname
    end

    after do
      SpecHelper.rm_tmp(@tmp_txt)
    end

    it "replace extention" do
      @tmp_txt.ext(".rb").should == 
        (@tmp_txt.dirname + "test.rb")
    end

    it "append extention if it doesn't has" do
      (@tmp_dir + "test").ext(".erb").should == 
        (@tmp_dir + "test.erb")
    end

    it "returns self if it is directory" do
      @tmp_dir.ext(".HOGE").should == @tmp_dir
    end
  end
end

