# coding:utf-8

require File.expand_path("../../spec_helper", __FILE__)

TEST_STR =<<-EOS
hoge fuga piyo
foo baz bar
EOS

describe Ext::File do
  it "extends File" do
    File.should respond_to(:write_with_block)
  end

  describe ".write_with_block" do
    before :all do
      @fpath = SpecHelper.tmpfile
      File.write_with_block(@fpath){ TEST_STR }
    end

    after :all do
      SpecHelper.rm_tmp(@fpath)
    end

    it "writes file" do
      @fpath.exist?.should be_true
    end

    it "write file whose content is specified by block" do
      File.read(@fpath.to_s).should == TEST_STR
    end
  end
end

