#!/usr/bin/env ruby
# -*- encoding: utf-8 -*-

require 'pathname'
require File.expand_path('../ext', __FILE__)

class TaskHelper
  class << self
    DIR_REFERENCE = { source: "lib", spec: "spec" }

    def method_missing(name, *args)
      case name.to_s
      when /^generate_(source|spec)$/   # script generator
        src_or_spec = $1.intern
        class_path = args.shift
        is_mod = args.shift

        file_path  = path_cls2file(class_path, DIR_REFERENCE[src_or_spec])
        if file_path.exist?
          puts "#{class_path} of #{src_or_spec} file already exists. Abort."
          exit 1
        end

        file_path.dirname.mkpath

        File.write_with_block(file_path.to_s, "w") do
          base, *routes = class_path.split("::").reverse
          prefix = is_mod ? "module" : "class"
          send(:"#{src_or_spec}_template", base, routes, prefix)
        end

        return file_path.to_s
      end

      super(name, *args)
    end

    def trace_modules(rev_mods, base)
      current_name = rev_mods.shift
      return base unless current_name
      trace_modules(rev_mods, "module #{current_name}\n#{base.indent}\nend")
    end

    def path_cls2file(class_path, root_dir="lib")
      (Pathname(File.expand_path("../..", __FILE__)) + root_dir + class_path.underscore).ext(".rb")
    end

    ## -- TEMPLATES -- ##
    
    def source_template(base, routes, prefix)
      <<-EOS
#!/usr/bin/env ruby
# coding:utf-8

#{TaskHelper.trace_modules(routes, "#{prefix} #{base}\nend")}

      EOS
    end

    def spec_template(base, routes, prefix="")
        <<-EOS
# coding:utf-8
require File.expand_path('#{(%w[..]*routes.size).join("/")}', __FILE__)

describe #{routes.reverse.push(base).join("::")} do
  it "truth" do
    1.should == 1
  end
end

        EOS
    end

  end
end

