#pragma once



#include "define.h"
#include "windowsAPI.h"
#include "bugreport.h"
#include "namespace_start.h"

class Exception:public std::runtime_error{
		
	private:
		NString  errMessage;
		UInt line;
		NString fileName;
		NString function;
		HRESULT osErrorCode;
		
	public:
		///
		///RXgN^
		///
		Exception(const NString&  errMessage,UInt in_line,const NString &in_fileName,const NString &in_function,HRESULT hResult  = GetLastError());
		
		
		///
		///G[擾
		///
		const NString &GetErrorMessage()const;


		///
		///G[s擾
		///
		UInt getLineNo()const;

		///
		///G[t@C擾
		///
		const NString &getFileName()const;


		///
		///G[֐擾
		///
		const NString &getFunctionName()const;


		///
		///oO񍐊֐
		///
		Bool Report();

	};



#define THROW_EXCEPTION(E,M) throw E(M,__LINE__,_T(__FILE__),_T(__FUNCTION__))

#define THROW_HRESULTEXCEPTION() THROW_EXCEPTION(Exception,_T("HResultOl܂"))

#define CHECK_HRESULT(r) if(r.IsFailed())THROW_HRESULTEXCEPTION()

#include "namespace_end.h"