//
//  KMThreadConverter.m
//  DocumentTest
//
//  Created by 堀 昌樹 on 11/12/11.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMThreadConverter.h"


@interface KMThreadConverter(KMPrivate)
- (BOOL)buildContent;
@end

@implementation KMThreadConverter

@synthesize document = _document;
@synthesize builder = _builder;
@synthesize content = _content;

+ (id)threadContentWithDocument:(KMDocument *)document useBuilder:(KMLogBuilder *)builder
{
	return [[[[self class] alloc] initWithDocument:document useBuilder:builder] autorelease];
}
- (id)initWithDocument:(KMDocument *)document useBuilder:(KMLogBuilder *)builder
{
	self = [super init];
	if(self) {
		self.document = document;
		self.builder = builder;
		[self buildContent];
	}
	
	return self;
}

- (BOOL)buildContent
{	
	self.content = [self.builder buildDocument:self.document];
	
	return YES;
}

@end
