//
//  KMLogViewController.m
//  DocumentTest
//
//  Created by 堀 昌樹 on 11/12/11.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMLogViewController.h"
#import "KMLogDocumentWindowController.h"
#import "KMDocument.h"
#import "KMThreadConverter.h"
#import "KMHTMLBuilder.h"


@interface KMLogViewController()

- (void)reloadContent;
@end

@implementation KMLogViewController
@synthesize contentView = _contentView;
@synthesize webView = _webView;

- (id)init
{
	return [super initWithNibName:@"KMLogView" bundle:nil];
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	
	[super dealloc];
}
- (void)loadView
{
	[super loadView];
	[self reloadContent];
}


- (void)setRepresentedObject:(id)representedObject
{
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:KMDocumentDidChangeNotification
												  object:self.representedObject];
	[super setRepresentedObject:representedObject];
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(documentDidChangeNotification:)
												 name:KMDocumentDidChangeNotification
											   object:representedObject];
	
	[self reloadContent];
}

- (void)reloadContent
{
	KMDocument *doc = self.representedObject;
	KMThreadConverter *htmlConverter = [KMThreadConverter threadContentWithDocument:doc
																useBuilder:[[[KMHTMLBuilder alloc] init] autorelease]];
	NSData *data = [htmlConverter.content dataUsingEncoding:NSUTF8StringEncoding];
	[[self.webView mainFrame] loadData:data MIMEType:@"text/html" textEncodingName:@"utf-8" baseURL:nil];
}

- (void)documentDidChangeNotification:(id)no
{
	[self reloadContent];
}
@end
