//
//  KMDocument.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 11/12/08.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMDocument.h"

#import "CMRThreadAttributes.h"
#import "ThreadTextDownloader.h"
#import "CMRThreadFileLoadingTask.h"
#import "CMRThreadPlistComposer.h"
#import "CMRThreadMessageBuffer.h"
#import "CMRThreadMessage.h"
#import "CMRThreadDictReader.h"
#import "CMR2chDATReader.h"

#import "AppDefaults.h"
#import <SGAppKit/NSWorkspace-SGExtensions.h>


NSString *KMDocumentDidChangeNotification = @"KMDocumentDidChangeNotification";

NSString *KMDocumentDidChangeMessageNotification = @"KMDocumentDidChangeMessageNotification";
NSString *KMDocumentChangedMessageIndexKey = @"KMDocumentChangedMessageIndexKey";

@interface KMDocument()
@property (readwrite, retain) CMRThreadMessageBuffer *messageBuffer;
@property (readwrite) BOOL messagesEdited;

@property (readonly) CMRThreadSignature *threadSignature;


- (void)loadContent:(NSURL *)fileURL;
- (BOOL)synchronize;
@end

@interface KMDocument(CMRThreadLayout_Methods_Private)
- (void)addMessagesFromBuffer:(CMRThreadMessageBuffer *)otherBuffer;
@end

@implementation KMDocument
@synthesize threadAttr = _threadAttr;
@synthesize messageBuffer = _messageBuffer;
@synthesize messagesEdited = _messagesEdited;


- (id)init
{
    self = [super init];
    if (self) {
        // Add your subclass-specific initialization here.
        // If an error occurs here, return nil.
		
		self.messageBuffer = [[[CMRThreadMessageBuffer alloc] init] autorelease];
		
		[[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(threadMessageDidChangeAttribute:)
                                                     name:CMRThreadMessageDidChangeAttributeNotification
                                                   object:nil];
    }
    return self;
}
- (void)dealloc
{
	[_threadAttr release];
	[_messageBuffer release];
	
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	
	[super dealloc];
}

/*
- (void)windowControllerDidLoadNib:(NSWindowController *)aController
{
    [super windowControllerDidLoadNib:aController];
    // Add any code here that needs to be executed once the windowController has loaded the document's window.
}
*/
- (NSData *)dataOfType:(NSString *)typeName error:(NSError **)outError
{
    /*
     Insert code here to write your document to data of the specified type. If outError != NULL, ensure that you create and set an appropriate error when returning nil.
    You can also choose to override -fileWrapperOfType:error:, -writeToURL:ofType:error:, or -writeToURL:ofType:forSaveOperation:originalContentsURL:error: instead.
    */
    if (outError) {
        *outError = [NSError errorWithDomain:NSOSStatusErrorDomain code:unimpErr userInfo:NULL];
    }
    return nil;
}
- (BOOL)readFromURL:(NSURL *)url ofType:(NSString *)typeName error:(NSError **)outError
{
	// do nothig.
	return YES;
}
- (BOOL)readFromData:(NSData *)data ofType:(NSString *)typeName error:(NSError **)outError
{
    /*
    Insert code here to read your document from the given data of the specified type. If outError != NULL, ensure that you create and set an appropriate error when returning NO.
    You can also choose to override -readFromFileWrapper:ofType:error: or -readFromURL:ofType:error: instead.
    If you override either of these, you should also override -isEntireFileLoaded to return NO if the contents are lazily loaded.
    */
    if (outError) {
        *outError = [NSError errorWithDomain:NSOSStatusErrorDomain code:unimpErr userInfo:NULL];
    }
    return YES;
}

+ (BOOL)autosavesInPlace
{
    return YES;
}
- (void)close
{
	[self synchronize];
	[super close];
}

// properties
- (NSString *)path
{
	return self.threadAttr.path;
}
- (NSString *)boardName
{
	return self.threadAttr.boardName;
}
- (NSString *)threadTitle
{
	return self.threadAttr.threadTitle;
}
- (NSString *)bbsIdentifier
{
	return self.threadAttr.bbsIdentifier;
}
- (NSString *)datIdentifier
{
	return self.threadAttr.datIdentifier;
}
- (NSURL *)boardURL
{
	return self.threadAttr.boardURL;
}
- (NSURL *)threadURL
{
	return self.threadAttr.threadURL;
}
- (CMRThreadSignature *)threadSignature
{
	return self.threadAttr.threadSignature;
}
- (void)setMessageBuffer:(CMRThreadMessageBuffer *)newBaffer
{
	@synchronized(self) {
		[_messageBuffer release];
		_messageBuffer = [newBaffer retain];
	}
}
- (CMRThreadMessageBuffer *)messageBuffer
{
	CMRThreadMessageBuffer *result = nil;
	@synchronized(self) {
		result = [[_messageBuffer retain] autorelease];		
	}
	return result;
}
- (NSString *)displayName
{
	NSString *title = self.threadTitle;
	NSString *boardName = self.boardName;
	if(title && boardName) {
		return [NSString stringWithFormat:@"%@ - %@", title, boardName];
	}
	if(title) return title;
	if(boardName) {
		return [NSString stringWithFormat:@"Untitled - %@", boardName];
	}
	return [super displayName];
}
- (void)loadContentOfFile:(NSString *)logFilepath
{
	NSDictionary *thread = [NSDictionary dictionaryWithContentsOfFile:logFilepath];
	if(!thread) return;
		
	if(!self.threadAttr) {
		self.threadAttr = [[[CMRThreadAttributes alloc] initWithDictionary:thread] autorelease];
	}
	if([self.messageBuffer count] == 0) {
		CMRThreadMessageBuffer *buffer_ = [[CMRThreadMessageBuffer alloc] init];
		CMRThreadDictReader *reader_ = [CMRThreadDictReader readerWithContents:thread];
		[reader_ setNextMessageIndex:0];
		[reader_ composeWithComposer:buffer_];
		[self addMessagesFromBuffer:buffer_];
		[buffer_ release];
		self.messagesEdited = YES;
	}
	
	[[NSNotificationCenter defaultCenter] postNotificationName:KMDocumentDidChangeNotification
														object:self];
}
- (void)downloadContent
{
	CMRDownloader			*downloader;
	downloader = [ThreadTextDownloader downloaderWithIdentifier:self.threadSignature
													threadTitle:self.threadTitle
													  nextIndex:0];
	if(!downloader) return;
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(threadFileDownloadDidFinishNotification:)
												 name:ThreadTextDownloaderDidFinishLoadingNotification
											   object:downloader];
	[downloader loadInBackground];
}
- (void)loadContent:(NSURL *)fileURL
{
	NSString *filepath = [fileURL path];
	
	SGFileRef			*fileRef_;
	NSString			*actualPath_;
	
	fileRef_ = [SGFileRef fileRefWithPath:filepath];
	actualPath_ = [fileRef_ pathContentResolvingLinkIfNeeded];
	
	// 
	// ファイル参照は存在しないファイルには作られない
	// 
	if(actualPath_ && [self.messageBuffer count] == 0) {
		[self loadContentOfFile:actualPath_];
	}
	
	[self downloadContent];
}


#pragma mark --- File Saving ---
- (void)saveWindowFrame
{
#warning MUST IMPLEMENT
//	if (![self threadAttributes]) return;
//	if (![self shouldLoadWindowFrameUsingCache]) return;
//	
//	[[self threadAttributes] setWindowFrame:[[self window] frame]];
}

- (void)saveLastIndex
{
#warning MUST IMPLEMENT
//	NSUInteger	idx;
//	
//	if ([CMRPref oldMessageScrollingBehavior]) {
//		idx = [[self threadLayout] firstMessageIndexForDocumentVisibleRect];
//	} else {
//		idx = [[self threadLayout] lastMessageIndexForDocumentVisibleRect];
//	}
//	if ([[self threadLayout] isInProgress]) {
//		// #warning 64BIT: Check formatting arguments
//		// 2010-03-28 tsawada2 修正済
//		NSLog(@"*** REPORT ***\n  "
//			  @" Since the layout is in progress,"
//			  @" didn't save last readed index(%lu).", (unsigned long)idx);
//		return;
//	}
//	[[self threadAttributes] setLastIndex:idx];
}
- (BOOL)synchronize
{
	NSString				*filepath_ = [self path];
	NSMutableDictionary		*mdict_;
	BOOL					attrEdited_, mesEdited_;
	
	[self saveWindowFrame];
	[self saveLastIndex];
	
	attrEdited_ = [self.threadAttr needsToUpdateLogFile];
	mesEdited_ = self.isMessagesEdited;
	if (!attrEdited_ && !mesEdited_) {
//		UTIL_DEBUG_WRITE(@"Not need to synchronize");
		return YES;
	}
	
	mdict_ = [NSMutableDictionary dictionaryWithContentsOfFile:filepath_];
	if (!mdict_) return NO;
	
	if (attrEdited_) {
		[self.threadAttr writeAttributes:mdict_];
		[self.threadAttr setNeedsToUpdateLogFile:NO];
	}
	
	if (mesEdited_) {
		NSMutableArray			*newArray_;
		CMRThreadPlistComposer	*composer_;
		
		newArray_ = [[NSMutableArray alloc] init];
		composer_ = [[CMRThreadPlistComposer alloc] initWithThreadsArray:newArray_];
//		UTIL_DEBUG_WRITE1(@"compose messages count=%lu", (unsigned long)[mBuffer_ count]);
		
		for(CMRThreadMessage *m in self.messageBuffer.messages) {
			[composer_ composeThreadMessage:m];
		}
		
		[mdict_ setObject:newArray_ forKey:ThreadPlistContentsKey];
		
		[composer_ release];
		[newArray_ release];
		
		self.messagesEdited = NO;
	}
	if ([CMRPref saveThreadDocAsBinaryPlist]) {
		NSData *data_;
		data_ = [NSPropertyListSerialization dataFromPropertyList:mdict_ format:NSPropertyListBinaryFormat_v1_0 errorDescription:NULL];
		
		if (!data_) return NO;
		return [data_ writeToFile:filepath_ atomically:YES];
	} else {
		return [mdict_ writeToFile:filepath_ atomically:YES];
	}
}

- (void)threadFileDownloadDidFinishNotification:(id)no
{
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:ThreadTextDownloaderDidFinishLoadingNotification
												  object:[no object]];
	NSDictionary *info = [no userInfo];
	[self.threadAttr addEntriesFromDictionary:[info objectForKey:CMRDownloaderUserInfoAdditionalInfoKey]];
	[self.threadAttr setNeedsToUpdateLogFile:YES];
	
	id dat = [info objectForKey:ThreadPlistContentsKey];
	CMR2chDATReader *reader_ = [CMR2chDATReader readerWithContents:dat];
	
	CMRThreadMessageBuffer *buffer_ = [[CMRThreadMessageBuffer alloc] init];
	[reader_ setNextMessageIndex:[self.messageBuffer count]];
	[reader_ composeWithComposer:buffer_];
	if([buffer_ count] != 0) {
		[self addMessagesFromBuffer:buffer_];
		self.messagesEdited = YES;
		
		[[NSNotificationCenter defaultCenter] postNotificationName:KMDocumentDidChangeNotification
															object:self];
	}
	[buffer_ release];
	
	[self synchronize];
}

@end


#import "BSThreadInfoPanelController.h"

@implementation KMDocument(Actions)

- (IBAction)reload:(id)sender
{
	[self loadContent:self.fileURL];
}
- (IBAction)reloadThread:(id)sender
{
	[self reload:sender];
}

- (IBAction)openInBrowser:(id)sender
{
    NSURL *url = [CMRThreadAttributes threadURLWithDefaultParameterFromDictionary:[self.threadAttr dictionaryRepresentation]];
    [[NSWorkspace sharedWorkspace] openURL:url inBackground:[CMRPref openInBg]];
}

#warning AppDelegateのほうがいい？
- (IBAction)showDocumentInfo:(id)sender
{
    [[BSThreadInfoPanelController sharedInstance] showWindow:sender];
}

@end


@implementation KMDocument(CMRThreadLayout_Methods)
- (void)addMessagesFromBuffer:(CMRThreadMessageBuffer *)otherBuffer
{
	if (!otherBuffer) {
		return;
	}
	@synchronized(self.messageBuffer) {
		[self.messageBuffer addMessagesFromBuffer:otherBuffer];
		
		for(CMRThreadMessage *m in [otherBuffer messages]) {
			[m setPostsAttributeChangedNotifications:YES];
		}
		
	}
}
- (void)threadMessageDidChangeAttribute:(NSNotification *)theNotification
{
	CMRThreadMessage	*message;
	NSUInteger			mIndex;
	
	UTILAssertNotificationName(
							   theNotification,
							   CMRThreadMessageDidChangeAttributeNotification);
	
	message = [theNotification object];
	if ((mIndex = [[self messageBuffer] indexOfMessage:message]) != NSNotFound) {
		NSDictionary *info = [NSDictionary dictionaryWithObject:[NSNumber numberWithInteger:mIndex]
														 forKey:KMDocumentChangedMessageIndexKey];
		[[NSNotificationCenter defaultCenter] postNotificationName:KMDocumentDidChangeMessageNotification
															object:self
														  userInfo:info];
		[self setMessagesEdited:YES];
	}
}

- (void)changeAllMessageAttributes:(BOOL)onOffFlag flags:(UInt32)mask
{
	[[self messageBuffer] changeAllMessageAttributes:onOffFlag flags:mask];
}

- (NSUInteger)numberOfMessageAttributes:(UInt32)mask
{
	NSUInteger			count_ = 0;
	
	for(CMRThreadMessage *m in [self.messageBuffer messages]) {
		if (mask & [m flags]) {
			count_++;
        }
	}
	return count_;
}
- (NSArray *)messagesAtIndexes:(NSIndexSet *)indexes
{
	return [[self.messageBuffer messages] objectsAtIndexes:indexes];
}
- (NSUInteger)numberOfReadedMessages
{
	return [self.messageBuffer count];
}

@end