//
//  BSSelectableImageCell.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 10/05/10.
// Copyright 2006-2010 BathyScaphe Project. All rights reserved.
// encoding="UTF-8"
//

#import "BSSelectableImageCell.h"
#import <SGAppKit/NSImage-SGExtensions.h>


@interface NSObject (BSLabelManagerAPIs)
- (NSArray *)backgroundColors;
@end


@implementation BSSelectableImageCell

- (void)setIntegerValue:(NSInteger)anInt
{
	if(anInt == 0) return;
	
	id labelManger = [NSClassFromString(@"BSLabelManager") defaultManager];
	NSColor *color = [[labelManger backgroundColors] objectAtIndex:anInt - 1];
	
	NSImage *image = [[[NSImage alloc] initWithSize:NSMakeSize(12,12)] autorelease];
	[image lockFocus];
	[[NSColor clearColor] set];
	NSRectFill(NSMakeRect(0,0,12,12));
	[color set];
	[[NSBezierPath bezierPathWithOvalInRect:NSMakeRect(0,0,12,12)] fill];
	[image unlockFocus];
	
	[self setImage:image];
}
- (void)setDrawX:(BOOL)flag
{
	drawX = flag;
}
- (BOOL)isDrawX
{
	return drawX;
}
- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
	NSRect interFrame;
	if([self isBordered]) {
		interFrame = NSInsetRect(cellFrame, 2, 2);
	} else {
		interFrame = cellFrame;
	}
	if(![self isEnabled] || ![self isBordered] || NSOnState != [self state]) {
		[self drawInteriorWithFrame:interFrame inView:controlView];
		return;
	}
	
	[NSGraphicsContext saveGraphicsState];
	
	[[NSColor lightGrayColor] set];
	NSShadow *shadow = [[[NSShadow alloc] init] autorelease];
	[shadow setShadowOffset:NSMakeSize(.3, .3)];
	[shadow setShadowBlurRadius:0.5];
	[shadow set];
	NSFrameRect(cellFrame);
	
	[NSGraphicsContext restoreGraphicsState];
	
	[self drawInteriorWithFrame:interFrame inView:controlView];
}
- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
	if(drawX && [self integerValue] == 0) {
		cellFrame = NSInsetRect(cellFrame, 3, 3);
		CGFloat maxX, midX, minX, maxY, midY, minY;
		maxX = NSMaxX(cellFrame); midX = NSMidX(cellFrame); minX = NSMinX(cellFrame);
		maxY = NSMaxY(cellFrame); midY = NSMidY(cellFrame); minY = NSMinY(cellFrame);
		CGFloat d = 1;
		
		NSBezierPath *result = [NSBezierPath bezierPath];
		[result setLineWidth:1];
		[result moveToPoint:NSMakePoint(minX + d, minY)];
		[result lineToPoint:NSMakePoint(midX, midY - d)];
		[result lineToPoint:NSMakePoint(maxX - d, minY)];
		[result lineToPoint:NSMakePoint(maxX, minY + d)];
		[result lineToPoint:NSMakePoint(midX + d, midY)];
		[result lineToPoint:NSMakePoint(maxX, maxY - d)];
		[result lineToPoint:NSMakePoint(maxX - d, maxY)];
		[result lineToPoint:NSMakePoint(midX, midY + d)];
		[result lineToPoint:NSMakePoint(minX + d, maxY)];
		[result lineToPoint:NSMakePoint(minX, maxY - d)];
		[result lineToPoint:NSMakePoint(midX - d, midY)];
		[result lineToPoint:NSMakePoint(minX, minY + d)];
		[result closePath];
		
		
		[[NSColor darkGrayColor] set];
		[result fill];
		
		return;
	}
	
	[super drawInteriorWithFrame:cellFrame inView:controlView];
}
@end
