//
//  KMLogDocumentWindowController.m
//  
//
//  Created by 堀 昌樹 on 11/12/17.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMLogDocumentWindowController.h"


@implementation KMLogDocumentWindowController
@dynamic logViewController;

- (void)setDocument:(NSDocument *)document
{
	[self.document performSelector:@selector(removeWindowController:)
						withObject:self
						afterDelay:0.0];
	[super setDocument:document];
	[self synchronizeWindowTitleWithDocumentName];
	[self.logViewController setRepresentedObject:document];
}
- (void)overlay:(NSView *)view onView:(NSView *)placeholder
{
	NSRect placeholderFrame = [placeholder frame];
	
	placeholderFrame.origin.x = 0;
	placeholderFrame.origin.y = 0;
	
	[view setFrame:placeholderFrame];
	[placeholder addSubview:view];
}
@end
