//
//  KMDocument.h
//  BathyScaphe
//
//  Created by 堀 昌樹 on 11/12/08.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CMRThreadAttributes;
@class CMRThreadMessageBuffer;

@interface KMDocument : NSDocument
{
	CMRThreadAttributes *_threadAttr;
}
@property (retain) CMRThreadAttributes *threadAttr;
@property (readonly, retain) CMRThreadMessageBuffer *messageBuffer;	// DO NOT change buffer.
@property (readonly, getter = isMessagesEdited) BOOL messagesEdited;

@property (readonly) NSString *path;
@property (readonly) NSString *boardName;
@property (readonly) NSString *threadTitle;
@property (readonly) NSString *bbsIdentifier;
@property (readonly) NSString *datIdentifier;
@property (readonly) NSURL *boardURL;
@property (readonly) NSURL *threadURL;


- (IBAction)reload:(id)sender;
- (IBAction)reloadThread:(id)sender; // same as reload:

@end

@interface KMDocument(CMRThreadLayout_Methods)
- (NSArray *)messagesAtIndexes:(NSIndexSet *)indexes;
- (NSUInteger)numberOfReadedMessages;

@end

extern NSString *KMDocumentDidChangeNotification;

extern NSString *KMDocumentDidChangeMessageNotification;
extern		NSString *KMDocumentChangedMessageIndexKey; // NSNumber
