//
//  KMBrowser.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 11/07/18.
//  Copyright 2011 masakih. All rights reserved.
//

#import "KMBrowser.h"

#import "KMDocument.h"

#import "KMBoardList.h"
#import "KMThreadList.h"

#import "KMLogViewController.h"
#import "KMBSLogViewController.h"

#import "KMLogWindowController.h"

#import "CMRThreadAttributes.h"
#import "CMRStatusLineWindowController.h"


@interface KMBrowser(KMViewAccessor)
- (void)buildViews;
@end

@implementation KMBrowser

@synthesize boardListPlaceholder;
@synthesize threadListPlaceholder;
@synthesize logViewPlaceholder;

@synthesize bsviewPlaceholder;

@synthesize searchField = _searchField;


@synthesize useLogWindow = _useLogWindow;


- (id)init
{
	return [super initWithWindowNibName:@"KMBrowser"];
}

- (void)dealloc
{
	[boardList removeObserver:self forKeyPath:@"selection"];
	[boardList release];
	
	[threadList removeObserver:self forKeyPath:@"selection"];
	[threadList release];
	
	[self.searchField unbind:NSValueBinding];
	
	[logView release];
	[bsview release];
	
	[super dealloc];
}

- (void)windowDidLoad
{
	[self buildViews];
}

- (void)setDocument:(NSDocument *)document
{
	if([self.document windowControllers].count == 1) {
		[self.document performSelector:@selector(close)
							withObject:nil
							afterDelay:0.0001];
	}
	[super setDocument:document];
}

static BOOL documentHasWindowController(NSDocument *aDocument, Class aClass)
{
	NSArray *windowControllers = [aDocument windowControllers];
	for(NSWindowController *wc in windowControllers) {
		if([wc isKindOfClass:aClass]) return YES;
	}
	return NO;
}
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == boardList) {
		if([keyPath isEqualToString:@"selection"]) {
//			NSLog(@"Board list did change selection.");
			[threadList setRepresentedObject:boardList.selection];
		}
		
		return;
	}
	if(context == threadList) {
		if([keyPath isEqualToString:@"selection"]) {
//			NSLog(@"Thread list did change selection.\nNew selection is %@", threadList.selection);
			
			if([threadList.selection count] == 1) {
				id selection = [threadList.selection objectAtIndex:0];
				NSString *filepath = [selection valueForKey:@"Path"];
				
				id dc = [NSDocumentController sharedDocumentController];
				NSError *error = nil;
				KMDocument *doc = [dc openDocumentWithContentsOfURL:[NSURL fileURLWithPath:filepath]
															display:NO
															  error:&error];
				doc.threadAttr = [[[CMRThreadAttributes alloc] initWithDictionary:selection] autorelease];
				
				if(!doc && error) {
					NSLog(@"%@", error);
				}
				BOOL hasSingleWindow = documentHasWindowController(doc, [KMLogWindowController class]);
				if(self.useLogWindow && !hasSingleWindow) {
					KMLogWindowController *wc = [[[KMLogWindowController alloc] init] autorelease];
					[doc addWindowController:wc];
				} else if(!self.useLogWindow && ![[doc windowControllers] containsObject:self]) {
					[doc addWindowController:self];
					[bsview setRepresentedObject:doc];
				}
				[doc showWindows];
			} else {
				// Multipul selection.
			}
		}
		
		return;
	}
	
	return [super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}



- (id)logViewController
{
	return logView;
}

@end

@implementation KMBrowser(KMViewAccessor)

- (void)buildViews
{
	boardList = [[KMBoardList alloc] init];
	[self overlay:[boardList view] onView:boardListPlaceholder];
	[boardList addObserver:self
				forKeyPath:@"selection"
				   options:NSKeyValueObservingOptionNew
				   context:boardList];
	
	//
	threadList = [[KMThreadList alloc] init];
	[self overlay:[threadList view] onView:threadListPlaceholder];
	[threadList addObserver:self
				forKeyPath:@"selection"
				   options:NSKeyValueObservingOptionNew
				   context:threadList];
	[self.searchField bind:NSValueBinding
				  toObject:threadList
			   withKeyPath:@"filterString"
				   options:nil];
	
	logView = [[KMLogViewController alloc] init];
	[self overlay:[logView view] onView:logViewPlaceholder];
	
	bsview = [[KMBSLogViewController alloc] init];
	[self overlay:[bsview view] onView:bsviewPlaceholder];
}
@end
