//
//  KMBoardList.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 11/07/18.
//  Copyright 2011 masakih. All rights reserved.
//

#import "KMBoardList.h"

#import "BoardManager.h"
#import "KMBoardListItemCell.h"


@implementation KMBoardList
@synthesize boardListView;
@synthesize selection;

- (id)init
{
	self = [super initWithNibName:@"KMBoardList" bundle:nil];
	if(self) {
		SmartBoardList *userList = [[BoardManager defaultManager] userList];
		[self setRepresentedObject:userList];
	}
	return self;
}

- (void)awakeFromNib
{
	NSTableColumn    *column_;
	BSIconAndTextCell	*cell_;
	
	column_ = [boardListView tableColumnWithIdentifier:BoardPlistNameKey];
	cell_ = [[KMBoardListItemCell alloc] init];
	[cell_ setEditable:NO];
	[column_ setDataCell:cell_];
	[cell_ release];
	[column_ setEditable:NO];
	
	
	[boardListView setDataSource:[self representedObject]];
}


#pragma mark NSOutlineView Delegate
- (void)outlineViewSelectionDidChange:(NSNotification *)notification
{
    NSInteger	rowIndex_;
    UTILAssertNotificationName(
							   notification,
							   NSOutlineViewSelectionDidChangeNotification);
    UTILAssertNotificationObject(
								 notification,
								 boardListView);
    
    rowIndex_ = [boardListView selectedRow];
    
    if ([boardListView numberOfSelectedRows] > 1) {
		[NSException raise:@"KMBoardListException" format:@"multi selection index."];
	}
    if (rowIndex_ < 0) {
		[NSException raise:@"KMBoardListException" format:@"underflow selection index."];
	}
    if (rowIndex_ >= [boardListView numberOfRows]) {
		[NSException raise:@"KMBoardListException" format:@"overflow selection index."];
	}
	
    self.selection = [boardListView itemAtRow:rowIndex_];
}

@end
