#!/usr/bin/python
# -*- coding:utf-8 -*-

import sys
import re
import codecs
from optparse import OptionParser

from lexi import Lexi
from textparser import Parser

def parse_arguments():
    "Generate option parser and parse arguments"
    usage = "usage: %prog [options] <source_file> <output_file>"
    parser = OptionParser(usage)
    parser.add_option("-r", "--rule", dest="rule_file",
                      metavar="RULE_FILE",
                      help="tlexi rule file [required]")
    parser.add_option("-a", "--additional",
                      action="append", dest="additional_rule_files",
                      metavar="ADDITIONAL_RULE_FILE",
                      help="tlexi additional rule file")
    (options, args) = parser.parse_args()
    if len(args) < 2 or not options.rule_file:
        parser.print_help()
        exit(-1)

    if not options.additional_rule_files:
        options.additional_rule_files = []

    options.source_file = args[0]
    options.output_file = args[1]
    return options

def main():
    opts = parse_arguments()
    lexi = Lexi(opts.rule_file)

    for rule_file in opts.additional_rule_files:
        lexi.append(rule_file)

    # open input/output files
    source = codecs.open(opts.source_file, 'r', 'utf8')
    if opts.output_file == '-':
        output = codecs.getwriter('utf8')(sys.stdout)
    else:
        output = codecs.open(opts.output_file, 'w', 'utf8')

    # do markup
    parser = Parser(lexi)
    parser.markup(source, output)

if __name__ == '__main__':
    main()


