# filter for Image extraction
# -*- coding: utf-8 -*-

import re

re_blank = re.compile(r'<\s*(\w+)[^>]*>\s*</\s*\1\s*>')
re_br = re.compile(r'<\s*br\s*/?>')

def _replace_all(rex, text):
    m = rex.search(text)
    while(m):
        text = rex.sub('', text)
        m = rex.search(text)
    return text

def entry_filter(entry):
    body = entry['body']

    # 空のタグを削除
    body = _replace_all(re_blank, body)

    # brタグを削除
    body = _replace_all(re_br, body)

    entry['body'] = body
    return entry

