# configloader.py
# -*- config: utf-8 -*-

import ConfigParser

CONFIG_FILE = 'sources.ini'

def load():
    'parse .ini file and create config object'
    config = ConfigParser.SafeConfigParser()
    fp = open(CONFIG_FILE, 'r')
    config.readfp(fp)
    fp.close()
    sources = []
    for section in config.sections():
        source = {}
        source["name"] = section
        source["source"] = config.get(section, 'source')
        source["url"] = config.get(section, 'url')
        if config.has_option(section, 'filters'):
            filters = config.get(section, 'filters').split(',')
            filters = [x.strip() for x in filters]
            source["filters"] = filters
        sources.append(source)
    return sources

            
