" 4-bit Vim colorscheme based on colorcli to be used with the colorcli palette
" as adapted for ConEmu.
" 
" colorcli is the work of Jonas Jacek: https://github.com/jonasjacek/colorcli
"
" Author: Mark Groen <groenm@groentjes.eu>

highlight clear

if exists("syntax_on")
  syntax reset
endif

" exec "source " . expand('<sfile>:p:h') . "/default-light.vim"

let colors_name = "clear-water"

" In diffs, added lines are green, changed lines are yellow, deleted lines are
" red, and changed text (within a changed line) is bright yellow and bold.
highlight DiffAdd        ctermfg=15   ctermbg=10
highlight DiffChange     ctermfg=15   ctermbg=9
highlight DiffDelete     ctermfg=15   ctermbg=4
highlight DiffText       ctermfg=14   ctermbg=9    cterm=bold

" Invert selected lines in visual mode
highlight Visual         ctermfg=NONE ctermbg=7
highlight link VisualNOS Visual

" Highlight search matches in black, with a yellow background
highlight Search         ctermfg=0    ctermbg=14
highlight IncSearch                   ctermbg=7

" Messages
highlight ErrorMsg       ctermfg=15   ctermbg=4
highlight MoreMsg        ctermfg=15   ctermbg=9

highlight underlined     ctermfg=9                 cterm=NONE

" Dim line numbers, comments, color columns, the status line, splits and sign
" columns.
if &background == "light"
  highlight Normal       ctermfg=8    ctermbg=15
  highlight Constant     ctermfg=2
  highlight CursorLine   NONE
  highlight CursorLineNr ctermfg=8    ctermbg=15   cterm=NONE
  highlight Label        ctermfg=1
  highlight LineNr       ctermfg=8    ctermbg=7
  highlight Comment      ctermfg=11
  highlight ColorColumn               ctermbg=7
  highlight Folded       ctermfg=8    ctermbg=7
  highlight FoldColumn   ctermfg=8    ctermbg=7
  highlight NonText      ctermfg=11   ctermbg=15
  highlight Pmenu        ctermfg=15   ctermbg=7
  highlight PmenuSel     ctermfg=15   ctermbg=9
  highlight PmenuSbar                 ctermbg=11
  highlight PmenuThumb                ctermbg=12
  highlight SpellBad     ctermfg=15   ctermbg=4
  highlight SpellCap     ctermfg=15   ctermbg=9
  highlight SpellRare                 ctermbg=7
  highlight StatusLine   ctermfg=15   ctermbg=7    cterm=bold
  highlight StatusLineNC ctermfg=8    ctermbg=7    cterm=NONE
  highlight String       ctermfg=0    ctermbg=7
  highlight VertSplit    ctermfg=15   ctermbg=0    cterm=NONE
  highlight SignColumn                ctermbg=7
  highlight MarchParen   ctermfg=15   ctermbg=9
  highlight TabLineSel   ctermfg=15   ctermbg=9
  highlight WildMenu	 ctermfg=15   ctermbg=9
  highlight Todo         ctermfg=15   ctermbg=10
  highlight Error        ctermfg=15   ctermbg=4
endif

" 
" Plugin specific
" 

" vim-json
 
