#include "mg.h"

void mg_offset(mgRect* p, mgPoint pt) {
	p->pos.x += pt.x;
	p->pos.y += pt.y;
}

bool_t mg_in(const mgRect* p, mgPoint pt) {
	return
		1
		&& mg_left(p) <= pt.x
		&& pt.x < mg_right(p)
		&& mg_top(p) <= pt.y
		&& pt.y < mg_bottom(p)
	;
}

bool_t mg_contains(const mgRect* p, const mgRect* pCheck) {
	return
		1
		&& mg_left(p) <= mg_left(pCheck)
		&& mg_right(p) >= mg_right(pCheck)
		&& mg_top(p) <= mg_top(pCheck)
		&& mg_bottom(p) >= mg_bottom(pCheck)
	;
}

void mg_intersect(const mgRect* p1, const mgRect* p2, mgRect* pResult) {
	int16_t left = max(mg_left(p1), mg_left(p2));
	int16_t right = min(mg_right(p1), mg_right(p2));
	
	int16_t top = max(mg_top(p1), mg_top(p2));
	int16_t bottom = min(mg_bottom(p1), mg_bottom(p2));
	
	pResult->x = left;
	pResult->w = max(0, right - left);
	
	pResult->y = top;
	pResult->h = max(0, bottom - top);
}

void mg_unionPoint(const mgRect* pRect, mgPoint pt, mgRect* pResult) {
	mgPoint rp = pRect->pt;
	pResult->pt.x = min(rp.x, pt.x);
	pResult->pt.y = min(rp.y, pt.y);
	pResult->w = max(pRect->w, pt.x - rp.x + 1);
	pResult->h = max(pRect->h, pt.y - rp.y + 1);
}

void mg_unionRect(const mgRect* p1, const mgRect* p2, mgRect* pResult) {
	pResult->x = min(p1->pt.x, p2->pt.x);
	pResult->y = min(p1->pt.y, p2->pt.y);
	pResult->w = max(mg_right(p1), mg_right(p2)) - mg_left(pResult);
	pResult->h = max(mg_bottom(p1), mg_bottom(p2)) - mg_top(pResult);
}

static mgElement* s_pElements[256];
static mgElement* s_pBehaviors[256];

void mg_registerElement(mgElement* p) {
	mgEnum i;
	for (i=0; i<256; ++i) {
		if (!s_pElements[i]) {
			s_pElements[i] = p;
			p->id = i;
			break;
		}
	}
}

void mg_unregisterElement(mgElement* p) {
	s_pElements[i] = 0;
	p->id = 0;
}

void mg_registerBehavior(mgBehavior* p) {
	mgEnum i;
	for (i=0; i<256; ++i) {
		if (!s_pBehaviors[i]) {
			s_pBehaviors[i] = p;
			p->id = i;
			break;
		}
	}
}

void mg_unresiterBehavior(mgBehavior* p) {
	s_pBehaviors[i] = 0;
	p->id = 0;
}

void mg_notifyEvent(id_t parent, mgEventInfo* pEvent) {
	
}

void mg_initialize() {
	
	
	
}

