#pragma once

#include "renderer.h"

namespace MG {

class Renderer24 : public IRenderer
{
public:
	Renderer24();
	
	virtual void SetBitmap(const Bitmap& bmp);
	
	virtual void SetClippingRectangle(const Rectangle& rec);
	
	virtual void SetPixel(uint16_t x, uint16_t y, Color c);
	virtual Color GetPixel(uint16_t x, uint16_t y);
	
	virtual void DrawHorizontalLine(float x1, float x2, float y, Color c);
	virtual void DrawVerticalLine(float x, float y1, float y2, Color c);
	virtual void DrawLine(float x1, float y1, float x2, float y2, Color c);
	
	virtual void FillRectangle(const Rectangle& rec, Color c);
	
	virtual void DrawBitmap(
		const Bitmap& bmp,
		const Rectangle& src, const Rectangle& dst
	);
	
	virtual void DrawText(uint8_t font, const char* str, size_t len, float x, float y, Color c);
	virtual void GetTextExtents(uint8_t font, const char* str, size_t len, int* charExtents, int& sx, int& sy);
	
	virtual Rectangle GetUpdatedRect();
	virtual void ClearUpdatedRect();

private:
	Bitmap bmp_;
	Rectangle clippingRect_;
	Rectangle updatedRect_;
};

} // namespace MG

