#include "stdafx.h"
#include "renderer24.h"

#include "arrayutil.h"

namespace MG {

Renderer24::Renderer24()
{
	updatedRect_.x = 0;
	updatedRect_.y = 0;
	updatedRect_.w = 0;
	updatedRect_.h = 0;
}

void Renderer24::SetBitmap(const Bitmap& bmp)
{
	bmp_ = bmp;
}

void Renderer24::SetClippingRectangle(const Rectangle& rec)
{
	clippingRect_ = rec;
}

void Renderer24::SetPixel(uint16_t x, uint16_t y, Color c)
{
	if (1
		&& x < bmp_.width
		&& y < bmp_.height
		)
	{
		uint8_t* ptr = (uint8_t*) bmp_.pBits;
		OffsetPtr(ptr, bmp_.lineOffsetBytes * y);
		ptr += 3 * x;
		ptr[0] = c.b;
		ptr[1] = c.g;
		ptr[2] = c.r;
		
		updatedRect_.Union(x, y);
	}
}

Color Renderer24::GetPixel(uint16_t x, uint16_t y)
{
	Color c;
	return c;
}

void Renderer24::DrawHorizontalLine(float x1, float x2, float y, Color c)
{
}

void Renderer24::DrawVerticalLine(float x, float y1, float y2, Color c)
{
}

void Renderer24::DrawLine(float x1, float y1, float x2, float y2, Color c)
{
}

void Renderer24::FillRectangle(const Rectangle& rec, Color c)
{
	for (size_t y=0; y<rec.h; ++y) {
		for (size_t x=0; x<rec.w; ++x) {
			SetPixel(rec.x+x, rec.y+y, c);
		}
	}
}

void Renderer24::DrawBitmap(
	const Bitmap& bmp,
	const Rectangle& src, const Rectangle& dst
	)
{
	BitBlt(bmp, src, bmp_, dst);
}

void Renderer24::DrawText(uint8_t font, const char* str, size_t len, float x, float y, Color c)
{
}

void Renderer24::GetTextExtents(uint8_t font, const char* str, size_t len, int* charExtents, int& sx, int& sy)
{
}

Rectangle Renderer24::GetUpdatedRect()
{
	return updatedRect_;
}

void Renderer24::ClearUpdatedRect()
{
	updatedRect_.w = updatedRect_.h = 0;
}


} // namespace MG

