#pragma once

#include "element.h"
#include "varray.h"

namespace MG {

class Container
	:
	public Element
{
public:
	Container(size_t nMaxEvents, size_t nMaxChildren);
	virtual ~Container();
	
	void AddChild(Element& e);
	void RemoveChild(Element& e);
	
	virtual void Draw(int16_t offsetX, int16_t offsetY, IRenderer& renderer);
	virtual bool HitTest(int16_t x, int16_t y) const;
	virtual void OnMouseDown(int16_t x, int16_t y);
	virtual void OnMouseUp(int16_t x, int16_t y);
	virtual void OnMouseMove(int16_t x, int16_t y);
	
protected:
	varray<Element*> elements_;
	
};

} // namespace MG

