;;; -*- Mode: Lisp; Package: SYSTEM -*-
;;;
;;; This file is part of xyzzy.
;;;

(provide "cnamedef")

(in-package "system")

(export '*character-name-alist*)

(defvar *character-name-alist* '(
("null" . 0)
("start_of_heading" . 1)
("start_of_text" . 2)
("end_of_text" . 3)
("end_of_transmission" . 4)
("enquiry" . 5)
("acknowledge" . 6)
("bell" . 7)
("backspace" . 8)
("horizontal_tabulation" . 9)
("line_feed" . #xa)
("vertical_tabulation" . #xb)
("form_feed" . #xc)
("carriage_return" . #xd)
("shift_out" . #xe)
("shift_in" . #xf)
("data_link_escape" . #x10)
("device_control_one" . #x11)
("device_control_two" . #x12)
("device_control_three" . #x13)
("device_control_four" . #x14)
("negative_acknowledge" . #x15)
("synchronous_idle" . #x16)
("end_of_transmission_block" . #x17)
("cancel" . #x18)
("end_of_medium" . #x19)
("substitute" . #x1a)
("escape" . #x1b)
("file_separator" . #x1c)
("group_separator" . #x1d)
("record_separator" . #x1e)
("unit_separator" . #x1f)
("space" . #x20)
("exclamation_mark" . #x21)
("quotation_mark" . #x22)
("number_sign" . #x23)
("dollar_sign" . #x24)
("percent_sign" . #x25)
("ampersand" . #x26)
("apostrophe" . #x27)
("left_parenthesis" . #x28)
("right_parenthesis" . #x29)
("asterisk" . #x2a)
("plus_sign" . #x2b)
("comma" . #x2c)
("hyphen_minus" . #x2d)
("full_stop" . #x2e)
("solidus" . #x2f)
("digit_zero" . #x30)
("digit_one" . #x31)
("digit_two" . #x32)
("digit_three" . #x33)
("digit_four" . #x34)
("digit_five" . #x35)
("digit_six" . #x36)
("digit_seven" . #x37)
("digit_eight" . #x38)
("digit_nine" . #x39)
("colon" . #x3a)
("semicolon" . #x3b)
("less_than_sign" . #x3c)
("equals_sign" . #x3d)
("greater_than_sign" . #x3e)
("question_mark" . #x3f)
("commercial_at" . #x40)
("latin_capital_letter_a" . #x41)
("latin_capital_letter_b" . #x42)
("latin_capital_letter_c" . #x43)
("latin_capital_letter_d" . #x44)
("latin_capital_letter_e" . #x45)
("latin_capital_letter_f" . #x46)
("latin_capital_letter_g" . #x47)
("latin_capital_letter_h" . #x48)
("latin_capital_letter_i" . #x49)
("latin_capital_letter_j" . #x4a)
("latin_capital_letter_k" . #x4b)
("latin_capital_letter_l" . #x4c)
("latin_capital_letter_m" . #x4d)
("latin_capital_letter_n" . #x4e)
("latin_capital_letter_o" . #x4f)
("latin_capital_letter_p" . #x50)
("latin_capital_letter_q" . #x51)
("latin_capital_letter_r" . #x52)
("latin_capital_letter_s" . #x53)
("latin_capital_letter_t" . #x54)
("latin_capital_letter_u" . #x55)
("latin_capital_letter_v" . #x56)
("latin_capital_letter_w" . #x57)
("latin_capital_letter_x" . #x58)
("latin_capital_letter_y" . #x59)
("latin_capital_letter_z" . #x5a)
("left_square_bracket" . #x5b)
("reverse_solidus" . #x5c)
("right_square_bracket" . #x5d)
("circumflex_accent" . #x5e)
("low_line" . #x5f)
("grave_accent" . #x60)
("latin_small_letter_a" . #x61)
("latin_small_letter_b" . #x62)
("latin_small_letter_c" . #x63)
("latin_small_letter_d" . #x64)
("latin_small_letter_e" . #x65)
("latin_small_letter_f" . #x66)
("latin_small_letter_g" . #x67)
("latin_small_letter_h" . #x68)
("latin_small_letter_i" . #x69)
("latin_small_letter_j" . #x6a)
("latin_small_letter_k" . #x6b)
("latin_small_letter_l" . #x6c)
("latin_small_letter_m" . #x6d)
("latin_small_letter_n" . #x6e)
("latin_small_letter_o" . #x6f)
("latin_small_letter_p" . #x70)
("latin_small_letter_q" . #x71)
("latin_small_letter_r" . #x72)
("latin_small_letter_s" . #x73)
("latin_small_letter_t" . #x74)
("latin_small_letter_u" . #x75)
("latin_small_letter_v" . #x76)
("latin_small_letter_w" . #x77)
("latin_small_letter_x" . #x78)
("latin_small_letter_y" . #x79)
("latin_small_letter_z" . #x7a)
("left_curly_bracket" . #x7b)
("vertical_line" . #x7c)
("right_curly_bracket" . #x7d)
("tilde" . #x7e)
("delete" . #x7f)
("no_break_space" . #xa0)
("inverted_exclamation_mark" . #xa1)
("cent_sign" . #xa2)
("pound_sign" . #xa3)
("currency_sign" . #xa4)
("yen_sign" . #xa5)
("broken_bar" . #xa6)
("section_sign" . #xa7)
("diaeresis" . #xa8)
("copyright_sign" . #xa9)
("feminine_ordinal_indicator" . #xaa)
("left_pointing_double_angle_quotation_mark" . #xab)
("not_sign" . #xac)
("soft_hyphen" . #xad)
("registered_sign" . #xae)
("macron" . #xaf)
("degree_sign" . #xb0)
("plus_minus_sign" . #xb1)
("superscript_two" . #xb2)
("superscript_three" . #xb3)
("acute_accent" . #xb4)
("micro_sign" . #xb5)
("pilcrow_sign" . #xb6)
("middle_dot" . #xb7)
("cedilla" . #xb8)
("superscript_one" . #xb9)
("masculine_ordinal_indicator" . #xba)
("right_pointing_double_angle_quotation_mark" . #xbb)
("vulgar_fraction_one_quarter" . #xbc)
("vulgar_fraction_one_half" . #xbd)
("vulgar_fraction_three_quarters" . #xbe)
("inverted_question_mark" . #xbf)
("latin_capital_letter_a_with_grave" . #xc0)
("latin_capital_letter_a_with_acute" . #xc1)
("latin_capital_letter_a_with_circumflex" . #xc2)
("latin_capital_letter_a_with_tilde" . #xc3)
("latin_capital_letter_a_with_diaeresis" . #xc4)
("latin_capital_letter_a_with_ring_above" . #xc5)
("latin_capital_letter_ae" . #xc6)
("latin_capital_letter_c_with_cedilla" . #xc7)
("latin_capital_letter_e_with_grave" . #xc8)
("latin_capital_letter_e_with_acute" . #xc9)
("latin_capital_letter_e_with_circumflex" . #xca)
("latin_capital_letter_e_with_diaeresis" . #xcb)
("latin_capital_letter_i_with_grave" . #xcc)
("latin_capital_letter_i_with_acute" . #xcd)
("latin_capital_letter_i_with_circumflex" . #xce)
("latin_capital_letter_i_with_diaeresis" . #xcf)
("latin_capital_letter_eth" . #xd0)
("latin_capital_letter_n_with_tilde" . #xd1)
("latin_capital_letter_o_with_grave" . #xd2)
("latin_capital_letter_o_with_acute" . #xd3)
("latin_capital_letter_o_with_circumflex" . #xd4)
("latin_capital_letter_o_with_tilde" . #xd5)
("latin_capital_letter_o_with_diaeresis" . #xd6)
("multiplication_sign" . #xd7)
("latin_capital_letter_o_with_stroke" . #xd8)
("latin_capital_letter_u_with_grave" . #xd9)
("latin_capital_letter_u_with_acute" . #xda)
("latin_capital_letter_u_with_circumflex" . #xdb)
("latin_capital_letter_u_with_diaeresis" . #xdc)
("latin_capital_letter_y_with_acute" . #xdd)
("latin_capital_letter_thorn" . #xde)
("latin_small_letter_sharp_s" . #xdf)
("latin_small_letter_a_with_grave" . #xe0)
("latin_small_letter_a_with_acute" . #xe1)
("latin_small_letter_a_with_circumflex" . #xe2)
("latin_small_letter_a_with_tilde" . #xe3)
("latin_small_letter_a_with_diaeresis" . #xe4)
("latin_small_letter_a_with_ring_above" . #xe5)
("latin_small_letter_ae" . #xe6)
("latin_small_letter_c_with_cedilla" . #xe7)
("latin_small_letter_e_with_grave" . #xe8)
("latin_small_letter_e_with_acute" . #xe9)
("latin_small_letter_e_with_circumflex" . #xea)
("latin_small_letter_e_with_diaeresis" . #xeb)
("latin_small_letter_i_with_grave" . #xec)
("latin_small_letter_i_with_acute" . #xed)
("latin_small_letter_i_with_circumflex" . #xee)
("latin_small_letter_i_with_diaeresis" . #xef)
("latin_small_letter_eth" . #xf0)
("latin_small_letter_n_with_tilde" . #xf1)
("latin_small_letter_o_with_grave" . #xf2)
("latin_small_letter_o_with_acute" . #xf3)
("latin_small_letter_o_with_circumflex" . #xf4)
("latin_small_letter_o_with_tilde" . #xf5)
("latin_small_letter_o_with_diaeresis" . #xf6)
("division_sign" . #xf7)
("latin_small_letter_o_with_stroke" . #xf8)
("latin_small_letter_u_with_grave" . #xf9)
("latin_small_letter_u_with_acute" . #xfa)
("latin_small_letter_u_with_circumflex" . #xfb)
("latin_small_letter_u_with_diaeresis" . #xfc)
("latin_small_letter_y_with_acute" . #xfd)
("latin_small_letter_thorn" . #xfe)
("latin_small_letter_y_with_diaeresis" . #xff)
("latin_capital_letter_a_with_macron" . #x100)
("latin_small_letter_a_with_macron" . #x101)
("latin_capital_letter_a_with_breve" . #x102)
("latin_small_letter_a_with_breve" . #x103)
("latin_capital_letter_a_with_ogonek" . #x104)
("latin_small_letter_a_with_ogonek" . #x105)
("latin_capital_letter_c_with_acute" . #x106)
("latin_small_letter_c_with_acute" . #x107)
("latin_capital_letter_c_with_circumflex" . #x108)
("latin_small_letter_c_with_circumflex" . #x109)
("latin_capital_letter_c_with_dot_above" . #x10a)
("latin_small_letter_c_with_dot_above" . #x10b)
("latin_capital_letter_c_with_caron" . #x10c)
("latin_small_letter_c_with_caron" . #x10d)
("latin_capital_letter_d_with_caron" . #x10e)
("latin_small_letter_d_with_caron" . #x10f)
("latin_capital_letter_d_with_stroke" . #x110)
("latin_small_letter_d_with_stroke" . #x111)
("latin_capital_letter_e_with_macron" . #x112)
("latin_small_letter_e_with_macron" . #x113)
("latin_capital_letter_e_with_breve" . #x114)
("latin_small_letter_e_with_breve" . #x115)
("latin_capital_letter_e_with_dot_above" . #x116)
("latin_small_letter_e_with_dot_above" . #x117)
("latin_capital_letter_e_with_ogonek" . #x118)
("latin_small_letter_e_with_ogonek" . #x119)
("latin_capital_letter_e_with_caron" . #x11a)
("latin_small_letter_e_with_caron" . #x11b)
("latin_capital_letter_g_with_circumflex" . #x11c)
("latin_small_letter_g_with_circumflex" . #x11d)
("latin_capital_letter_g_with_breve" . #x11e)
("latin_small_letter_g_with_breve" . #x11f)
("latin_capital_letter_g_with_dot_above" . #x120)
("latin_small_letter_g_with_dot_above" . #x121)
("latin_capital_letter_g_with_cedilla" . #x122)
("latin_small_letter_g_with_cedilla" . #x123)
("latin_capital_letter_h_with_circumflex" . #x124)
("latin_small_letter_h_with_circumflex" . #x125)
("latin_capital_letter_h_with_stroke" . #x126)
("latin_small_letter_h_with_stroke" . #x127)
("latin_capital_letter_i_with_tilde" . #x128)
("latin_small_letter_i_with_tilde" . #x129)
("latin_capital_letter_i_with_macron" . #x12a)
("latin_small_letter_i_with_macron" . #x12b)
("latin_capital_letter_i_with_breve" . #x12c)
("latin_small_letter_i_with_breve" . #x12d)
("latin_capital_letter_i_with_ogonek" . #x12e)
("latin_small_letter_i_with_ogonek" . #x12f)
("latin_capital_letter_i_with_dot_above" . #x130)
("latin_small_letter_dotless_i" . #x131)
("latin_capital_ligature_ij" . #x132)
("latin_small_ligature_ij" . #x133)
("latin_capital_letter_j_with_circumflex" . #x134)
("latin_small_letter_j_with_circumflex" . #x135)
("latin_capital_letter_k_with_cedilla" . #x136)
("latin_small_letter_k_with_cedilla" . #x137)
("latin_small_letter_kra" . #x138)
("latin_capital_letter_l_with_acute" . #x139)
("latin_small_letter_l_with_acute" . #x13a)
("latin_capital_letter_l_with_cedilla" . #x13b)
("latin_small_letter_l_with_cedilla" . #x13c)
("latin_capital_letter_l_with_caron" . #x13d)
("latin_small_letter_l_with_caron" . #x13e)
("latin_capital_letter_l_with_middle_dot" . #x13f)
("latin_small_letter_l_with_middle_dot" . #x140)
("latin_capital_letter_l_with_stroke" . #x141)
("latin_small_letter_l_with_stroke" . #x142)
("latin_capital_letter_n_with_acute" . #x143)
("latin_small_letter_n_with_acute" . #x144)
("latin_capital_letter_n_with_cedilla" . #x145)
("latin_small_letter_n_with_cedilla" . #x146)
("latin_capital_letter_n_with_caron" . #x147)
("latin_small_letter_n_with_caron" . #x148)
("latin_small_letter_n_preceded_by_apostrophe" . #x149)
("latin_capital_letter_eng" . #x14a)
("latin_small_letter_eng" . #x14b)
("latin_capital_letter_o_with_macron" . #x14c)
("latin_small_letter_o_with_macron" . #x14d)
("latin_capital_letter_o_with_breve" . #x14e)
("latin_small_letter_o_with_breve" . #x14f)
("latin_capital_letter_o_with_double_acute" . #x150)
("latin_small_letter_o_with_double_acute" . #x151)
("latin_capital_ligature_oe" . #x152)
("latin_small_ligature_oe" . #x153)
("latin_capital_letter_r_with_acute" . #x154)
("latin_small_letter_r_with_acute" . #x155)
("latin_capital_letter_r_with_cedilla" . #x156)
("latin_small_letter_r_with_cedilla" . #x157)
("latin_capital_letter_r_with_caron" . #x158)
("latin_small_letter_r_with_caron" . #x159)
("latin_capital_letter_s_with_acute" . #x15a)
("latin_small_letter_s_with_acute" . #x15b)
("latin_capital_letter_s_with_circumflex" . #x15c)
("latin_small_letter_s_with_circumflex" . #x15d)
("latin_capital_letter_s_with_cedilla" . #x15e)
("latin_small_letter_s_with_cedilla" . #x15f)
("latin_capital_letter_s_with_caron" . #x160)
("latin_small_letter_s_with_caron" . #x161)
("latin_capital_letter_t_with_cedilla" . #x162)
("latin_small_letter_t_with_cedilla" . #x163)
("latin_capital_letter_t_with_caron" . #x164)
("latin_small_letter_t_with_caron" . #x165)
("latin_capital_letter_t_with_stroke" . #x166)
("latin_small_letter_t_with_stroke" . #x167)
("latin_capital_letter_u_with_tilde" . #x168)
("latin_small_letter_u_with_tilde" . #x169)
("latin_capital_letter_u_with_macron" . #x16a)
("latin_small_letter_u_with_macron" . #x16b)
("latin_capital_letter_u_with_breve" . #x16c)
("latin_small_letter_u_with_breve" . #x16d)
("latin_capital_letter_u_with_ring_above" . #x16e)
("latin_small_letter_u_with_ring_above" . #x16f)
("latin_capital_letter_u_with_double_acute" . #x170)
("latin_small_letter_u_with_double_acute" . #x171)
("latin_capital_letter_u_with_ogonek" . #x172)
("latin_small_letter_u_with_ogonek" . #x173)
("latin_capital_letter_w_with_circumflex" . #x174)
("latin_small_letter_w_with_circumflex" . #x175)
("latin_capital_letter_y_with_circumflex" . #x176)
("latin_small_letter_y_with_circumflex" . #x177)
("latin_capital_letter_y_with_diaeresis" . #x178)
("latin_capital_letter_z_with_acute" . #x179)
("latin_small_letter_z_with_acute" . #x17a)
("latin_capital_letter_z_with_dot_above" . #x17b)
("latin_small_letter_z_with_dot_above" . #x17c)
("latin_capital_letter_z_with_caron" . #x17d)
("latin_small_letter_z_with_caron" . #x17e)
("latin_small_letter_long_s" . #x17f)
("latin_small_letter_f_with_hook" . #x192)
("latin_capital_letter_o_with_horn" . #x1a0)
("latin_small_letter_o_with_horn" . #x1a1)
("latin_capital_letter_u_with_horn" . #x1af)
("latin_small_letter_u_with_horn" . #x1b0)
("latin_capital_letter_a_with_caron" . #x1cd)
("latin_small_letter_a_with_caron" . #x1ce)
("latin_capital_letter_i_with_caron" . #x1cf)
("latin_small_letter_i_with_caron" . #x1d0)
("latin_capital_letter_o_with_caron" . #x1d1)
("latin_small_letter_o_with_caron" . #x1d2)
("latin_capital_letter_u_with_caron" . #x1d3)
("latin_small_letter_u_with_caron" . #x1d4)
("latin_capital_letter_u_with_diaeresis_and_macron" . #x1d5)
("latin_small_letter_u_with_diaeresis_and_macron" . #x1d6)
("latin_capital_letter_u_with_diaeresis_and_acute" . #x1d7)
("latin_small_letter_u_with_diaeresis_and_acute" . #x1d8)
("latin_capital_letter_u_with_diaeresis_and_caron" . #x1d9)
("latin_small_letter_u_with_diaeresis_and_caron" . #x1da)
("latin_capital_letter_u_with_diaeresis_and_grave" . #x1db)
("latin_small_letter_u_with_diaeresis_and_grave" . #x1dc)
("latin_small_letter_g_with_acute" . #x1f5)
("latin_capital_letter_a_with_ring_above_and_acute" . #x1fa)
("latin_small_letter_a_with_ring_above_and_acute" . #x1fb)
("latin_capital_letter_ae_with_acute" . #x1fc)
("latin_small_letter_ae_with_acute" . #x1fd)
("latin_capital_letter_o_with_stroke_and_acute" . #x1fe)
("latin_small_letter_o_with_stroke_and_acute" . #x1ff)
("latin_small_letter_turned_a" . #x250)
("latin_small_letter_alpha" . #x251)
("latin_small_letter_turned_alpha" . #x252)
("latin_small_letter_b_with_hook" . #x253)
("latin_small_letter_open_o" . #x254)
("latin_small_letter_c_with_curl" . #x255)
("latin_small_letter_d_with_tail" . #x256)
("latin_small_letter_d_with_hook" . #x257)
("latin_small_letter_reversed_e" . #x258)
("latin_small_letter_schwa" . #x259)
("latin_small_letter_schwa_with_hook" . #x25a)
("latin_small_letter_open_e" . #x25b)
("latin_small_letter_reversed_open_e" . #x25c)
("latin_small_letter_reversed_open_e_with_hook" . #x25d)
("latin_small_letter_closed_reversed_open_e" . #x25e)
("latin_small_letter_dotless_j_with_stroke" . #x25f)
("latin_small_letter_g_with_hook" . #x260)
("latin_small_letter_script_g" . #x261)
("latin_letter_small_capital_g" . #x262)
("latin_small_letter_gamma" . #x263)
("latin_small_letter_rams_horn" . #x264)
("latin_small_letter_turned_h" . #x265)
("latin_small_letter_h_with_hook" . #x266)
("latin_small_letter_heng_with_hook" . #x267)
("latin_small_letter_i_with_stroke" . #x268)
("latin_small_letter_iota" . #x269)
("latin_letter_small_capital_i" . #x26a)
("latin_small_letter_l_with_middle_tilde" . #x26b)
("latin_small_letter_l_with_belt" . #x26c)
("latin_small_letter_l_with_retroflex_hook" . #x26d)
("latin_small_letter_lezh" . #x26e)
("latin_small_letter_turned_m" . #x26f)
("latin_small_letter_turned_m_with_long_leg" . #x270)
("latin_small_letter_m_with_hook" . #x271)
("latin_small_letter_n_with_left_hook" . #x272)
("latin_small_letter_n_with_retroflex_hook" . #x273)
("latin_letter_small_capital_n" . #x274)
("latin_small_letter_barred_o" . #x275)
("latin_letter_small_capital_oe" . #x276)
("latin_small_letter_closed_omega" . #x277)
("latin_small_letter_phi" . #x278)
("latin_small_letter_turned_r" . #x279)
("latin_small_letter_turned_r_with_long_leg" . #x27a)
("latin_small_letter_turned_r_with_hook" . #x27b)
("latin_small_letter_r_with_long_leg" . #x27c)
("latin_small_letter_r_with_tail" . #x27d)
("latin_small_letter_r_with_fishhook" . #x27e)
("latin_small_letter_reversed_r_with_fishhook" . #x27f)
("latin_letter_small_capital_r" . #x280)
("latin_letter_small_capital_inverted_r" . #x281)
("latin_small_letter_s_with_hook" . #x282)
("latin_small_letter_esh" . #x283)
("latin_small_letter_dotless_j_with_stroke_and_hook" . #x284)
("latin_small_letter_squat_reversed_esh" . #x285)
("latin_small_letter_esh_with_curl" . #x286)
("latin_small_letter_turned_t" . #x287)
("latin_small_letter_t_with_retroflex_hook" . #x288)
("latin_small_letter_u_bar" . #x289)
("latin_small_letter_upsilon" . #x28a)
("latin_small_letter_v_with_hook" . #x28b)
("latin_small_letter_turned_v" . #x28c)
("latin_small_letter_turned_w" . #x28d)
("latin_small_letter_turned_y" . #x28e)
("latin_letter_small_capital_y" . #x28f)
("latin_small_letter_z_with_retroflex_hook" . #x290)
("latin_small_letter_z_with_curl" . #x291)
("latin_small_letter_ezh" . #x292)
("latin_small_letter_ezh_with_curl" . #x293)
("latin_letter_glottal_stop" . #x294)
("latin_letter_pharyngeal_voiced_fricative" . #x295)
("latin_letter_inverted_glottal_stop" . #x296)
("latin_letter_stretched_c" . #x297)
("latin_letter_bilabial_click" . #x298)
("latin_letter_small_capital_b" . #x299)
("latin_small_letter_closed_open_e" . #x29a)
("latin_letter_small_capital_g_with_hook" . #x29b)
("latin_letter_small_capital_h" . #x29c)
("latin_small_letter_j_with_crossed_tail" . #x29d)
("latin_small_letter_turned_k" . #x29e)
("latin_letter_small_capital_l" . #x29f)
("latin_small_letter_q_with_hook" . #x2a0)
("latin_letter_glottal_stop_with_stroke" . #x2a1)
("latin_letter_reversed_glottal_stop_with_stroke" . #x2a2)
("latin_small_letter_dz_digraph" . #x2a3)
("latin_small_letter_dezh_digraph" . #x2a4)
("latin_small_letter_dz_digraph_with_curl" . #x2a5)
("latin_small_letter_ts_digraph" . #x2a6)
("latin_small_letter_tesh_digraph" . #x2a7)
("latin_small_letter_tc_digraph_with_curl" . #x2a8)
("latin_small_letter_feng_digraph" . #x2a9)
("latin_small_letter_ls_digraph" . #x2aa)
("latin_small_letter_lz_digraph" . #x2ab)
("latin_letter_bilabial_percussive" . #x2ac)
("latin_letter_bidental_percussive" . #x2ad)
("modifier_letter_small_h" . #x2b0)
("modifier_letter_small_h_with_hook" . #x2b1)
("modifier_letter_small_j" . #x2b2)
("modifier_letter_small_r" . #x2b3)
("modifier_letter_small_turned_r" . #x2b4)
("modifier_letter_small_turned_r_with_hook" . #x2b5)
("modifier_letter_small_capital_inverted_r" . #x2b6)
("modifier_letter_small_w" . #x2b7)
("modifier_letter_small_y" . #x2b8)
("modifier_letter_prime" . #x2b9)
("modifier_letter_double_prime" . #x2ba)
("modifier_letter_turned_comma" . #x2bb)
("modifier_letter_apostrophe" . #x2bc)
("modifier_letter_reversed_comma" . #x2bd)
("modifier_letter_right_half_ring" . #x2be)
("modifier_letter_left_half_ring" . #x2bf)
("modifier_letter_glottal_stop" . #x2c0)
("modifier_letter_reversed_glottal_stop" . #x2c1)
("modifier_letter_left_arrowhead" . #x2c2)
("modifier_letter_right_arrowhead" . #x2c3)
("modifier_letter_up_arrowhead" . #x2c4)
("modifier_letter_down_arrowhead" . #x2c5)
("modifier_letter_circumflex_accent" . #x2c6)
("caron" . #x2c7)
("modifier_letter_vertical_line" . #x2c8)
("modifier_letter_macron" . #x2c9)
("modifier_letter_acute_accent" . #x2ca)
("modifier_letter_grave_accent" . #x2cb)
("modifier_letter_low_vertical_line" . #x2cc)
("modifier_letter_low_macron" . #x2cd)
("modifier_letter_low_grave_accent" . #x2ce)
("modifier_letter_low_acute_accent" . #x2cf)
("modifier_letter_triangular_colon" . #x2d0)
("modifier_letter_half_triangular_colon" . #x2d1)
("modifier_letter_centred_right_half_ring" . #x2d2)
("modifier_letter_centred_left_half_ring" . #x2d3)
("modifier_letter_up_tack" . #x2d4)
("modifier_letter_down_tack" . #x2d5)
("modifier_letter_plus_sign" . #x2d6)
("modifier_letter_minus_sign" . #x2d7)
("breve" . #x2d8)
("dot_above" . #x2d9)
("ring_above" . #x2da)
("ogonek" . #x2db)
("small_tilde" . #x2dc)
("double_acute_accent" . #x2dd)
("modifier_letter_rhotic_hook" . #x2de)
("modifier_letter_cross_accent" . #x2df)
("modifier_letter_small_gamma" . #x2e0)
("modifier_letter_small_l" . #x2e1)
("modifier_letter_small_s" . #x2e2)
("modifier_letter_small_x" . #x2e3)
("modifier_letter_small_reversed_glottal_stop" . #x2e4)
("modifier_letter_extra_high_tone_bar" . #x2e5)
("modifier_letter_high_tone_bar" . #x2e6)
("modifier_letter_mid_tone_bar" . #x2e7)
("modifier_letter_low_tone_bar" . #x2e8)
("modifier_letter_extra_low_tone_bar" . #x2e9)
("modifier_letter_yin_departing_tone_mark" . #x2ea)
("modifier_letter_yang_departing_tone_mark" . #x2eb)
("modifier_letter_voicing" . #x2ec)
("modifier_letter_unaspirated" . #x2ed)
("modifier_letter_double_apostrophe" . #x2ee)
("combining_grave_accent" . #x300)
("combining_acute_accent" . #x301)
("combining_circumflex_accent" . #x302)
("combining_tilde" . #x303)
("combining_macron" . #x304)
("combining_overline" . #x305)
("combining_breve" . #x306)
("combining_dot_above" . #x307)
("combining_diaeresis" . #x308)
("combining_hook_above" . #x309)
("combining_ring_above" . #x30a)
("combining_double_acute_accent" . #x30b)
("combining_caron" . #x30c)
("combining_vertical_line_above" . #x30d)
("combining_double_vertical_line_above" . #x30e)
("combining_double_grave_accent" . #x30f)
("combining_candrabindu" . #x310)
("combining_inverted_breve" . #x311)
("combining_turned_comma_above" . #x312)
("combining_comma_above" . #x313)
("combining_reversed_comma_above" . #x314)
("combining_comma_above_right" . #x315)
("combining_grave_accent_below" . #x316)
("combining_acute_accent_below" . #x317)
("combining_left_tack_below" . #x318)
("combining_right_tack_below" . #x319)
("combining_left_angle_above" . #x31a)
("combining_horn" . #x31b)
("combining_left_half_ring_below" . #x31c)
("combining_up_tack_below" . #x31d)
("combining_down_tack_below" . #x31e)
("combining_plus_sign_below" . #x31f)
("combining_minus_sign_below" . #x320)
("combining_palatalized_hook_below" . #x321)
("combining_retroflex_hook_below" . #x322)
("combining_dot_below" . #x323)
("combining_diaeresis_below" . #x324)
("combining_ring_below" . #x325)
("combining_comma_below" . #x326)
("combining_cedilla" . #x327)
("combining_ogonek" . #x328)
("combining_vertical_line_below" . #x329)
("combining_bridge_below" . #x32a)
("combining_inverted_double_arch_below" . #x32b)
("combining_caron_below" . #x32c)
("combining_circumflex_accent_below" . #x32d)
("combining_breve_below" . #x32e)
("combining_inverted_breve_below" . #x32f)
("combining_tilde_below" . #x330)
("combining_macron_below" . #x331)
("combining_low_line" . #x332)
("combining_double_low_line" . #x333)
("combining_tilde_overlay" . #x334)
("combining_short_stroke_overlay" . #x335)
("combining_long_stroke_overlay" . #x336)
("combining_short_solidus_overlay" . #x337)
("combining_long_solidus_overlay" . #x338)
("combining_right_half_ring_below" . #x339)
("combining_inverted_bridge_below" . #x33a)
("combining_square_below" . #x33b)
("combining_seagull_below" . #x33c)
("combining_x_above" . #x33d)
("combining_vertical_tilde" . #x33e)
("combining_double_overline" . #x33f)
("combining_grave_tone_mark" . #x340)
("combining_acute_tone_mark" . #x341)
("combining_greek_perispomeni" . #x342)
("combining_greek_koronis" . #x343)
("combining_greek_dialytika_tonos" . #x344)
("combining_greek_ypogegrammeni" . #x345)
("combining_bridge_above" . #x346)
("combining_equals_sign_below" . #x347)
("combining_double_vertical_line_below" . #x348)
("combining_left_angle_below" . #x349)
("combining_not_tilde_above" . #x34a)
("combining_homothetic_above" . #x34b)
("combining_almost_equal_to_above" . #x34c)
("combining_left_right_arrow_below" . #x34d)
("combining_upwards_arrow_below" . #x34e)
("combining_double_tilde" . #x360)
("combining_double_inverted_breve" . #x361)
("combining_double_rightwards_arrow_below" . #x362)
("greek_numeral_sign" . #x374)
("greek_lower_numeral_sign" . #x375)
("greek_ypogegrammeni" . #x37a)
("greek_question_mark" . #x37e)
("greek_tonos" . #x384)
("greek_dialytika_tonos" . #x385)
("greek_capital_letter_alpha_with_tonos" . #x386)
("greek_ano_teleia" . #x387)
("greek_capital_letter_epsilon_with_tonos" . #x388)
("greek_capital_letter_eta_with_tonos" . #x389)
("greek_capital_letter_iota_with_tonos" . #x38a)
("greek_capital_letter_omicron_with_tonos" . #x38c)
("greek_capital_letter_upsilon_with_tonos" . #x38e)
("greek_capital_letter_omega_with_tonos" . #x38f)
("greek_small_letter_iota_with_dialytika_and_tonos" . #x390)
("greek_capital_letter_alpha" . #x391)
("greek_capital_letter_beta" . #x392)
("greek_capital_letter_gamma" . #x393)
("greek_capital_letter_delta" . #x394)
("greek_capital_letter_epsilon" . #x395)
("greek_capital_letter_zeta" . #x396)
("greek_capital_letter_eta" . #x397)
("greek_capital_letter_theta" . #x398)
("greek_capital_letter_iota" . #x399)
("greek_capital_letter_kappa" . #x39a)
("greek_capital_letter_lamda" . #x39b)
("greek_capital_letter_mu" . #x39c)
("greek_capital_letter_nu" . #x39d)
("greek_capital_letter_xi" . #x39e)
("greek_capital_letter_omicron" . #x39f)
("greek_capital_letter_pi" . #x3a0)
("greek_capital_letter_rho" . #x3a1)
("greek_capital_letter_sigma" . #x3a3)
("greek_capital_letter_tau" . #x3a4)
("greek_capital_letter_upsilon" . #x3a5)
("greek_capital_letter_phi" . #x3a6)
("greek_capital_letter_chi" . #x3a7)
("greek_capital_letter_psi" . #x3a8)
("greek_capital_letter_omega" . #x3a9)
("greek_capital_letter_iota_with_dialytika" . #x3aa)
("greek_capital_letter_upsilon_with_dialytika" . #x3ab)
("greek_small_letter_alpha_with_tonos" . #x3ac)
("greek_small_letter_epsilon_with_tonos" . #x3ad)
("greek_small_letter_eta_with_tonos" . #x3ae)
("greek_small_letter_iota_with_tonos" . #x3af)
("greek_small_letter_upsilon_with_dialytika_and_tonos" . #x3b0)
("greek_small_letter_alpha" . #x3b1)
("greek_small_letter_beta" . #x3b2)
("greek_small_letter_gamma" . #x3b3)
("greek_small_letter_delta" . #x3b4)
("greek_small_letter_epsilon" . #x3b5)
("greek_small_letter_zeta" . #x3b6)
("greek_small_letter_eta" . #x3b7)
("greek_small_letter_theta" . #x3b8)
("greek_small_letter_iota" . #x3b9)
("greek_small_letter_kappa" . #x3ba)
("greek_small_letter_lamda" . #x3bb)
("greek_small_letter_mu" . #x3bc)
("greek_small_letter_nu" . #x3bd)
("greek_small_letter_xi" . #x3be)
("greek_small_letter_omicron" . #x3bf)
("greek_small_letter_pi" . #x3c0)
("greek_small_letter_rho" . #x3c1)
("greek_small_letter_final_sigma" . #x3c2)
("greek_small_letter_sigma" . #x3c3)
("greek_small_letter_tau" . #x3c4)
("greek_small_letter_upsilon" . #x3c5)
("greek_small_letter_phi" . #x3c6)
("greek_small_letter_chi" . #x3c7)
("greek_small_letter_psi" . #x3c8)
("greek_small_letter_omega" . #x3c9)
("greek_small_letter_iota_with_dialytika" . #x3ca)
("greek_small_letter_upsilon_with_dialytika" . #x3cb)
("greek_small_letter_omicron_with_tonos" . #x3cc)
("greek_small_letter_upsilon_with_tonos" . #x3cd)
("greek_small_letter_omega_with_tonos" . #x3ce)
("cyrillic_capital_letter_io" . #x401)
("cyrillic_capital_letter_dje" . #x402)
("cyrillic_capital_letter_gje" . #x403)
("cyrillic_capital_letter_ukrainian_ie" . #x404)
("cyrillic_capital_letter_dze" . #x405)
("cyrillic_capital_letter_byelorussian_ukrainian_i" . #x406)
("cyrillic_capital_letter_yi" . #x407)
("cyrillic_capital_letter_je" . #x408)
("cyrillic_capital_letter_lje" . #x409)
("cyrillic_capital_letter_nje" . #x40a)
("cyrillic_capital_letter_tshe" . #x40b)
("cyrillic_capital_letter_kje" . #x40c)
("cyrillic_capital_letter_short_u" . #x40e)
("cyrillic_capital_letter_dzhe" . #x40f)
("cyrillic_capital_letter_a" . #x410)
("cyrillic_capital_letter_be" . #x411)
("cyrillic_capital_letter_ve" . #x412)
("cyrillic_capital_letter_ghe" . #x413)
("cyrillic_capital_letter_de" . #x414)
("cyrillic_capital_letter_ie" . #x415)
("cyrillic_capital_letter_zhe" . #x416)
("cyrillic_capital_letter_ze" . #x417)
("cyrillic_capital_letter_i" . #x418)
("cyrillic_capital_letter_short_i" . #x419)
("cyrillic_capital_letter_ka" . #x41a)
("cyrillic_capital_letter_el" . #x41b)
("cyrillic_capital_letter_em" . #x41c)
("cyrillic_capital_letter_en" . #x41d)
("cyrillic_capital_letter_o" . #x41e)
("cyrillic_capital_letter_pe" . #x41f)
("cyrillic_capital_letter_er" . #x420)
("cyrillic_capital_letter_es" . #x421)
("cyrillic_capital_letter_te" . #x422)
("cyrillic_capital_letter_u" . #x423)
("cyrillic_capital_letter_ef" . #x424)
("cyrillic_capital_letter_ha" . #x425)
("cyrillic_capital_letter_tse" . #x426)
("cyrillic_capital_letter_che" . #x427)
("cyrillic_capital_letter_sha" . #x428)
("cyrillic_capital_letter_shcha" . #x429)
("cyrillic_capital_letter_hard_sign" . #x42a)
("cyrillic_capital_letter_yeru" . #x42b)
("cyrillic_capital_letter_soft_sign" . #x42c)
("cyrillic_capital_letter_e" . #x42d)
("cyrillic_capital_letter_yu" . #x42e)
("cyrillic_capital_letter_ya" . #x42f)
("cyrillic_small_letter_a" . #x430)
("cyrillic_small_letter_be" . #x431)
("cyrillic_small_letter_ve" . #x432)
("cyrillic_small_letter_ghe" . #x433)
("cyrillic_small_letter_de" . #x434)
("cyrillic_small_letter_ie" . #x435)
("cyrillic_small_letter_zhe" . #x436)
("cyrillic_small_letter_ze" . #x437)
("cyrillic_small_letter_i" . #x438)
("cyrillic_small_letter_short_i" . #x439)
("cyrillic_small_letter_ka" . #x43a)
("cyrillic_small_letter_el" . #x43b)
("cyrillic_small_letter_em" . #x43c)
("cyrillic_small_letter_en" . #x43d)
("cyrillic_small_letter_o" . #x43e)
("cyrillic_small_letter_pe" . #x43f)
("cyrillic_small_letter_er" . #x440)
("cyrillic_small_letter_es" . #x441)
("cyrillic_small_letter_te" . #x442)
("cyrillic_small_letter_u" . #x443)
("cyrillic_small_letter_ef" . #x444)
("cyrillic_small_letter_ha" . #x445)
("cyrillic_small_letter_tse" . #x446)
("cyrillic_small_letter_che" . #x447)
("cyrillic_small_letter_sha" . #x448)
("cyrillic_small_letter_shcha" . #x449)
("cyrillic_small_letter_hard_sign" . #x44a)
("cyrillic_small_letter_yeru" . #x44b)
("cyrillic_small_letter_soft_sign" . #x44c)
("cyrillic_small_letter_e" . #x44d)
("cyrillic_small_letter_yu" . #x44e)
("cyrillic_small_letter_ya" . #x44f)
("cyrillic_small_letter_io" . #x451)
("cyrillic_small_letter_dje" . #x452)
("cyrillic_small_letter_gje" . #x453)
("cyrillic_small_letter_ukrainian_ie" . #x454)
("cyrillic_small_letter_dze" . #x455)
("cyrillic_small_letter_byelorussian_ukrainian_i" . #x456)
("cyrillic_small_letter_yi" . #x457)
("cyrillic_small_letter_je" . #x458)
("cyrillic_small_letter_lje" . #x459)
("cyrillic_small_letter_nje" . #x45a)
("cyrillic_small_letter_tshe" . #x45b)
("cyrillic_small_letter_kje" . #x45c)
("cyrillic_small_letter_short_u" . #x45e)
("cyrillic_small_letter_dzhe" . #x45f)
("cyrillic_capital_letter_omega" . #x460)
("cyrillic_small_letter_omega" . #x461)
("cyrillic_capital_letter_yat" . #x462)
("cyrillic_small_letter_yat" . #x463)
("cyrillic_capital_letter_iotified_e" . #x464)
("cyrillic_small_letter_iotified_e" . #x465)
("cyrillic_capital_letter_little_yus" . #x466)
("cyrillic_small_letter_little_yus" . #x467)
("cyrillic_capital_letter_iotified_little_yus" . #x468)
("cyrillic_small_letter_iotified_little_yus" . #x469)
("cyrillic_capital_letter_big_yus" . #x46a)
("cyrillic_small_letter_big_yus" . #x46b)
("cyrillic_capital_letter_iotified_big_yus" . #x46c)
("cyrillic_small_letter_iotified_big_yus" . #x46d)
("cyrillic_capital_letter_ksi" . #x46e)
("cyrillic_small_letter_ksi" . #x46f)
("cyrillic_capital_letter_psi" . #x470)
("cyrillic_small_letter_psi" . #x471)
("cyrillic_capital_letter_fita" . #x472)
("cyrillic_small_letter_fita" . #x473)
("cyrillic_capital_letter_izhitsa" . #x474)
("cyrillic_small_letter_izhitsa" . #x475)
("cyrillic_capital_letter_izhitsa_with_double_grave_accent" . #x476)
("cyrillic_small_letter_izhitsa_with_double_grave_accent" . #x477)
("cyrillic_capital_letter_uk" . #x478)
("cyrillic_small_letter_uk" . #x479)
("cyrillic_capital_letter_round_omega" . #x47a)
("cyrillic_small_letter_round_omega" . #x47b)
("cyrillic_capital_letter_omega_with_titlo" . #x47c)
("cyrillic_small_letter_omega_with_titlo" . #x47d)
("cyrillic_capital_letter_ot" . #x47e)
("cyrillic_small_letter_ot" . #x47f)
("cyrillic_capital_letter_koppa" . #x480)
("cyrillic_small_letter_koppa" . #x481)
("cyrillic_thousands_sign" . #x482)
("combining_cyrillic_titlo" . #x483)
("combining_cyrillic_palatalization" . #x484)
("combining_cyrillic_dasia_pneumata" . #x485)
("combining_cyrillic_psili_pneumata" . #x486)
("cyrillic_capital_letter_ghe_with_upturn" . #x490)
("cyrillic_small_letter_ghe_with_upturn" . #x491)
("cyrillic_capital_letter_ghe_with_stroke" . #x492)
("cyrillic_small_letter_ghe_with_stroke" . #x493)
("cyrillic_capital_letter_ghe_with_middle_hook" . #x494)
("cyrillic_small_letter_ghe_with_middle_hook" . #x495)
("cyrillic_capital_letter_zhe_with_descender" . #x496)
("cyrillic_small_letter_zhe_with_descender" . #x497)
("cyrillic_capital_letter_ze_with_descender" . #x498)
("cyrillic_small_letter_ze_with_descender" . #x499)
("cyrillic_capital_letter_ka_with_descender" . #x49a)
("cyrillic_small_letter_ka_with_descender" . #x49b)
("cyrillic_capital_letter_ka_with_vertical_stroke" . #x49c)
("cyrillic_small_letter_ka_with_vertical_stroke" . #x49d)
("cyrillic_capital_letter_ka_with_stroke" . #x49e)
("cyrillic_small_letter_ka_with_stroke" . #x49f)
("cyrillic_capital_letter_bashkir_ka" . #x4a0)
("cyrillic_small_letter_bashkir_ka" . #x4a1)
("cyrillic_capital_letter_en_with_descender" . #x4a2)
("cyrillic_small_letter_en_with_descender" . #x4a3)
("cyrillic_capital_ligature_en_ghe" . #x4a4)
("cyrillic_small_ligature_en_ghe" . #x4a5)
("cyrillic_capital_letter_pe_with_middle_hook" . #x4a6)
("cyrillic_small_letter_pe_with_middle_hook" . #x4a7)
("cyrillic_capital_letter_abkhasian_ha" . #x4a8)
("cyrillic_small_letter_abkhasian_ha" . #x4a9)
("cyrillic_capital_letter_es_with_descender" . #x4aa)
("cyrillic_small_letter_es_with_descender" . #x4ab)
("cyrillic_capital_letter_te_with_descender" . #x4ac)
("cyrillic_small_letter_te_with_descender" . #x4ad)
("cyrillic_capital_letter_straight_u" . #x4ae)
("cyrillic_small_letter_straight_u" . #x4af)
("cyrillic_capital_letter_straight_u_with_stroke" . #x4b0)
("cyrillic_small_letter_straight_u_with_stroke" . #x4b1)
("cyrillic_capital_letter_ha_with_descender" . #x4b2)
("cyrillic_small_letter_ha_with_descender" . #x4b3)
("cyrillic_capital_ligature_te_tse" . #x4b4)
("cyrillic_small_ligature_te_tse" . #x4b5)
("cyrillic_capital_letter_che_with_descender" . #x4b6)
("cyrillic_small_letter_che_with_descender" . #x4b7)
("cyrillic_capital_letter_che_with_vertical_stroke" . #x4b8)
("cyrillic_small_letter_che_with_vertical_stroke" . #x4b9)
("cyrillic_capital_letter_shha" . #x4ba)
("cyrillic_small_letter_shha" . #x4bb)
("cyrillic_capital_letter_abkhasian_che" . #x4bc)
("cyrillic_small_letter_abkhasian_che" . #x4bd)
("cyrillic_capital_letter_abkhasian_che_with_descender" . #x4be)
("cyrillic_small_letter_abkhasian_che_with_descender" . #x4bf)
("cyrillic_letter_palochka" . #x4c0)
("cyrillic_capital_letter_zhe_with_breve" . #x4c1)
("cyrillic_small_letter_zhe_with_breve" . #x4c2)
("cyrillic_capital_letter_ka_with_hook" . #x4c3)
("cyrillic_small_letter_ka_with_hook" . #x4c4)
("cyrillic_capital_letter_en_with_hook" . #x4c7)
("cyrillic_small_letter_en_with_hook" . #x4c8)
("cyrillic_capital_letter_khakassian_che" . #x4cb)
("cyrillic_small_letter_khakassian_che" . #x4cc)
("cyrillic_capital_letter_a_with_breve" . #x4d0)
("cyrillic_small_letter_a_with_breve" . #x4d1)
("cyrillic_capital_letter_a_with_diaeresis" . #x4d2)
("cyrillic_small_letter_a_with_diaeresis" . #x4d3)
("cyrillic_capital_ligature_a_ie" . #x4d4)
("cyrillic_small_ligature_a_ie" . #x4d5)
("cyrillic_capital_letter_ie_with_breve" . #x4d6)
("cyrillic_small_letter_ie_with_breve" . #x4d7)
("cyrillic_capital_letter_schwa" . #x4d8)
("cyrillic_small_letter_schwa" . #x4d9)
("cyrillic_capital_letter_schwa_with_diaeresis" . #x4da)
("cyrillic_small_letter_schwa_with_diaeresis" . #x4db)
("cyrillic_capital_letter_zhe_with_diaeresis" . #x4dc)
("cyrillic_small_letter_zhe_with_diaeresis" . #x4dd)
("cyrillic_capital_letter_ze_with_diaeresis" . #x4de)
("cyrillic_small_letter_ze_with_diaeresis" . #x4df)
("cyrillic_capital_letter_abkhasian_dze" . #x4e0)
("cyrillic_small_letter_abkhasian_dze" . #x4e1)
("cyrillic_capital_letter_i_with_macron" . #x4e2)
("cyrillic_small_letter_i_with_macron" . #x4e3)
("cyrillic_capital_letter_i_with_diaeresis" . #x4e4)
("cyrillic_small_letter_i_with_diaeresis" . #x4e5)
("cyrillic_capital_letter_o_with_diaeresis" . #x4e6)
("cyrillic_small_letter_o_with_diaeresis" . #x4e7)
("cyrillic_capital_letter_barred_o" . #x4e8)
("cyrillic_small_letter_barred_o" . #x4e9)
("cyrillic_capital_letter_barred_o_with_diaeresis" . #x4ea)
("cyrillic_small_letter_barred_o_with_diaeresis" . #x4eb)
("cyrillic_capital_letter_u_with_macron" . #x4ee)
("cyrillic_small_letter_u_with_macron" . #x4ef)
("cyrillic_capital_letter_u_with_diaeresis" . #x4f0)
("cyrillic_small_letter_u_with_diaeresis" . #x4f1)
("cyrillic_capital_letter_u_with_double_acute" . #x4f2)
("cyrillic_small_letter_u_with_double_acute" . #x4f3)
("cyrillic_capital_letter_che_with_diaeresis" . #x4f4)
("cyrillic_small_letter_che_with_diaeresis" . #x4f5)
("cyrillic_capital_letter_yeru_with_diaeresis" . #x4f8)
("cyrillic_small_letter_yeru_with_diaeresis" . #x4f9)
("georgian_capital_letter_an" . #x10a0)
("georgian_capital_letter_ban" . #x10a1)
("georgian_capital_letter_gan" . #x10a2)
("georgian_capital_letter_don" . #x10a3)
("georgian_capital_letter_en" . #x10a4)
("georgian_capital_letter_vin" . #x10a5)
("georgian_capital_letter_zen" . #x10a6)
("georgian_capital_letter_tan" . #x10a7)
("georgian_capital_letter_in" . #x10a8)
("georgian_capital_letter_kan" . #x10a9)
("georgian_capital_letter_las" . #x10aa)
("georgian_capital_letter_man" . #x10ab)
("georgian_capital_letter_nar" . #x10ac)
("georgian_capital_letter_on" . #x10ad)
("georgian_capital_letter_par" . #x10ae)
("georgian_capital_letter_zhar" . #x10af)
("georgian_capital_letter_rae" . #x10b0)
("georgian_capital_letter_san" . #x10b1)
("georgian_capital_letter_tar" . #x10b2)
("georgian_capital_letter_un" . #x10b3)
("georgian_capital_letter_phar" . #x10b4)
("georgian_capital_letter_khar" . #x10b5)
("georgian_capital_letter_ghan" . #x10b6)
("georgian_capital_letter_qar" . #x10b7)
("georgian_capital_letter_shin" . #x10b8)
("georgian_capital_letter_chin" . #x10b9)
("georgian_capital_letter_can" . #x10ba)
("georgian_capital_letter_jil" . #x10bb)
("georgian_capital_letter_cil" . #x10bc)
("georgian_capital_letter_char" . #x10bd)
("georgian_capital_letter_xan" . #x10be)
("georgian_capital_letter_jhan" . #x10bf)
("georgian_capital_letter_hae" . #x10c0)
("georgian_capital_letter_he" . #x10c1)
("georgian_capital_letter_hie" . #x10c2)
("georgian_capital_letter_we" . #x10c3)
("georgian_capital_letter_har" . #x10c4)
("georgian_capital_letter_hoe" . #x10c5)
("georgian_letter_an" . #x10d0)
("georgian_letter_ban" . #x10d1)
("georgian_letter_gan" . #x10d2)
("georgian_letter_don" . #x10d3)
("georgian_letter_en" . #x10d4)
("georgian_letter_vin" . #x10d5)
("georgian_letter_zen" . #x10d6)
("georgian_letter_tan" . #x10d7)
("georgian_letter_in" . #x10d8)
("georgian_letter_kan" . #x10d9)
("georgian_letter_las" . #x10da)
("georgian_letter_man" . #x10db)
("georgian_letter_nar" . #x10dc)
("georgian_letter_on" . #x10dd)
("georgian_letter_par" . #x10de)
("georgian_letter_zhar" . #x10df)
("georgian_letter_rae" . #x10e0)
("georgian_letter_san" . #x10e1)
("georgian_letter_tar" . #x10e2)
("georgian_letter_un" . #x10e3)
("georgian_letter_phar" . #x10e4)
("georgian_letter_khar" . #x10e5)
("georgian_letter_ghan" . #x10e6)
("georgian_letter_qar" . #x10e7)
("georgian_letter_shin" . #x10e8)
("georgian_letter_chin" . #x10e9)
("georgian_letter_can" . #x10ea)
("georgian_letter_jil" . #x10eb)
("georgian_letter_cil" . #x10ec)
("georgian_letter_char" . #x10ed)
("georgian_letter_xan" . #x10ee)
("georgian_letter_jhan" . #x10ef)
("georgian_letter_hae" . #x10f0)
("georgian_letter_he" . #x10f1)
("georgian_letter_hie" . #x10f2)
("georgian_letter_we" . #x10f3)
("georgian_letter_har" . #x10f4)
("georgian_letter_hoe" . #x10f5)
("georgian_letter_fi" . #x10f6)
("georgian_paragraph_separator" . #x10fb)
("hangul_choseong_kiyeok" . #x1100)
("hangul_choseong_ssangkiyeok" . #x1101)
("hangul_choseong_nieun" . #x1102)
("hangul_choseong_tikeut" . #x1103)
("hangul_choseong_ssangtikeut" . #x1104)
("hangul_choseong_rieul" . #x1105)
("hangul_choseong_mieum" . #x1106)
("hangul_choseong_pieup" . #x1107)
("hangul_choseong_ssangpieup" . #x1108)
("hangul_choseong_sios" . #x1109)
("hangul_choseong_ssangsios" . #x110a)
("hangul_choseong_ieung" . #x110b)
("hangul_choseong_cieuc" . #x110c)
("hangul_choseong_ssangcieuc" . #x110d)
("hangul_choseong_chieuch" . #x110e)
("hangul_choseong_khieukh" . #x110f)
("hangul_choseong_thieuth" . #x1110)
("hangul_choseong_phieuph" . #x1111)
("hangul_choseong_hieuh" . #x1112)
("hangul_choseong_nieun_kiyeok" . #x1113)
("hangul_choseong_ssangnieun" . #x1114)
("hangul_choseong_nieun_tikeut" . #x1115)
("hangul_choseong_nieun_pieup" . #x1116)
("hangul_choseong_tikeut_kiyeok" . #x1117)
("hangul_choseong_rieul_nieun" . #x1118)
("hangul_choseong_ssangrieul" . #x1119)
("hangul_choseong_rieul_hieuh" . #x111a)
("hangul_choseong_kapyeounrieul" . #x111b)
("hangul_choseong_mieum_pieup" . #x111c)
("hangul_choseong_kapyeounmieum" . #x111d)
("hangul_choseong_pieup_kiyeok" . #x111e)
("hangul_choseong_pieup_nieun" . #x111f)
("latin_capital_letter_w_with_grave" . #x1e80)
("latin_small_letter_w_with_grave" . #x1e81)
("latin_capital_letter_w_with_acute" . #x1e82)
("latin_small_letter_w_with_acute" . #x1e83)
("latin_capital_letter_w_with_diaeresis" . #x1e84)
("latin_small_letter_w_with_diaeresis" . #x1e85)
("latin_capital_letter_a_with_dot_below" . #x1ea0)
("latin_small_letter_a_with_dot_below" . #x1ea1)
("latin_capital_letter_a_with_hook_above" . #x1ea2)
("latin_small_letter_a_with_hook_above" . #x1ea3)
("latin_capital_letter_a_with_circumflex_and_acute" . #x1ea4)
("latin_small_letter_a_with_circumflex_and_acute" . #x1ea5)
("latin_capital_letter_a_with_circumflex_and_grave" . #x1ea6)
("latin_small_letter_a_with_circumflex_and_grave" . #x1ea7)
("latin_capital_letter_a_with_circumflex_and_hook_above" . #x1ea8)
("latin_small_letter_a_with_circumflex_and_hook_above" . #x1ea9)
("latin_capital_letter_a_with_circumflex_and_tilde" . #x1eaa)
("latin_small_letter_a_with_circumflex_and_tilde" . #x1eab)
("latin_capital_letter_a_with_circumflex_and_dot_below" . #x1eac)
("latin_small_letter_a_with_circumflex_and_dot_below" . #x1ead)
("latin_capital_letter_a_with_breve_and_acute" . #x1eae)
("latin_small_letter_a_with_breve_and_acute" . #x1eaf)
("latin_capital_letter_a_with_breve_and_grave" . #x1eb0)
("latin_small_letter_a_with_breve_and_grave" . #x1eb1)
("latin_capital_letter_a_with_breve_and_hook_above" . #x1eb2)
("latin_small_letter_a_with_breve_and_hook_above" . #x1eb3)
("latin_capital_letter_a_with_breve_and_tilde" . #x1eb4)
("latin_small_letter_a_with_breve_and_tilde" . #x1eb5)
("latin_capital_letter_a_with_breve_and_dot_below" . #x1eb6)
("latin_small_letter_a_with_breve_and_dot_below" . #x1eb7)
("latin_capital_letter_e_with_dot_below" . #x1eb8)
("latin_small_letter_e_with_dot_below" . #x1eb9)
("latin_capital_letter_e_with_hook_above" . #x1eba)
("latin_small_letter_e_with_hook_above" . #x1ebb)
("latin_capital_letter_e_with_tilde" . #x1ebc)
("latin_small_letter_e_with_tilde" . #x1ebd)
("latin_capital_letter_e_with_circumflex_and_acute" . #x1ebe)
("latin_small_letter_e_with_circumflex_and_acute" . #x1ebf)
("latin_capital_letter_e_with_circumflex_and_grave" . #x1ec0)
("latin_small_letter_e_with_circumflex_and_grave" . #x1ec1)
("latin_capital_letter_e_with_circumflex_and_hook_above" . #x1ec2)
("latin_small_letter_e_with_circumflex_and_hook_above" . #x1ec3)
("latin_capital_letter_e_with_circumflex_and_tilde" . #x1ec4)
("latin_small_letter_e_with_circumflex_and_tilde" . #x1ec5)
("latin_capital_letter_e_with_circumflex_and_dot_below" . #x1ec6)
("latin_small_letter_e_with_circumflex_and_dot_below" . #x1ec7)
("latin_capital_letter_i_with_hook_above" . #x1ec8)
("latin_small_letter_i_with_hook_above" . #x1ec9)
("latin_capital_letter_i_with_dot_below" . #x1eca)
("latin_small_letter_i_with_dot_below" . #x1ecb)
("latin_capital_letter_o_with_dot_below" . #x1ecc)
("latin_small_letter_o_with_dot_below" . #x1ecd)
("latin_capital_letter_o_with_hook_above" . #x1ece)
("latin_small_letter_o_with_hook_above" . #x1ecf)
("latin_capital_letter_o_with_circumflex_and_acute" . #x1ed0)
("latin_small_letter_o_with_circumflex_and_acute" . #x1ed1)
("latin_capital_letter_o_with_circumflex_and_grave" . #x1ed2)
("latin_small_letter_o_with_circumflex_and_grave" . #x1ed3)
("latin_capital_letter_o_with_circumflex_and_hook_above" . #x1ed4)
("latin_small_letter_o_with_circumflex_and_hook_above" . #x1ed5)
("latin_capital_letter_o_with_circumflex_and_tilde" . #x1ed6)
("latin_small_letter_o_with_circumflex_and_tilde" . #x1ed7)
("latin_capital_letter_o_with_circumflex_and_dot_below" . #x1ed8)
("latin_small_letter_o_with_circumflex_and_dot_below" . #x1ed9)
("latin_capital_letter_o_with_horn_and_acute" . #x1eda)
("latin_small_letter_o_with_horn_and_acute" . #x1edb)
("latin_capital_letter_o_with_horn_and_grave" . #x1edc)
("latin_small_letter_o_with_horn_and_grave" . #x1edd)
("latin_capital_letter_o_with_horn_and_hook_above" . #x1ede)
("latin_small_letter_o_with_horn_and_hook_above" . #x1edf)
("latin_capital_letter_o_with_horn_and_tilde" . #x1ee0)
("latin_small_letter_o_with_horn_and_tilde" . #x1ee1)
("latin_capital_letter_o_with_horn_and_dot_below" . #x1ee2)
("latin_small_letter_o_with_horn_and_dot_below" . #x1ee3)
("latin_capital_letter_u_with_dot_below" . #x1ee4)
("latin_small_letter_u_with_dot_below" . #x1ee5)
("latin_capital_letter_u_with_hook_above" . #x1ee6)
("latin_small_letter_u_with_hook_above" . #x1ee7)
("latin_capital_letter_u_with_horn_and_acute" . #x1ee8)
("latin_small_letter_u_with_horn_and_acute" . #x1ee9)
("latin_capital_letter_u_with_horn_and_grave" . #x1eea)
("latin_small_letter_u_with_horn_and_grave" . #x1eeb)
("latin_capital_letter_u_with_horn_and_hook_above" . #x1eec)
("latin_small_letter_u_with_horn_and_hook_above" . #x1eed)
("latin_capital_letter_u_with_horn_and_tilde" . #x1eee)
("latin_small_letter_u_with_horn_and_tilde" . #x1eef)
("latin_capital_letter_u_with_horn_and_dot_below" . #x1ef0)
("latin_small_letter_u_with_horn_and_dot_below" . #x1ef1)
("latin_capital_letter_y_with_grave" . #x1ef2)
("latin_small_letter_y_with_grave" . #x1ef3)
("latin_capital_letter_y_with_dot_below" . #x1ef4)
("latin_small_letter_y_with_dot_below" . #x1ef5)
("latin_capital_letter_y_with_hook_above" . #x1ef6)
("latin_small_letter_y_with_hook_above" . #x1ef7)
("latin_capital_letter_y_with_tilde" . #x1ef8)
("latin_small_letter_y_with_tilde" . #x1ef9)
("en_quad" . #x2000)
("em_quad" . #x2001)
("en_space" . #x2002)
("em_space" . #x2003)
("three_per_em_space" . #x2004)
("four_per_em_space" . #x2005)
("six_per_em_space" . #x2006)
("figure_space" . #x2007)
("punctuation_space" . #x2008)
("thin_space" . #x2009)
("hair_space" . #x200a)
("zero_width_space" . #x200b)
("zero_width_non_joiner" . #x200c)
("zero_width_joiner" . #x200d)
("left_to_right_mark" . #x200e)
("right_to_left_mark" . #x200f)
("hyphen" . #x2010)
("non_breaking_hyphen" . #x2011)
("figure_dash" . #x2012)
("en_dash" . #x2013)
("em_dash" . #x2014)
("horizontal_bar" . #x2015)
("double_vertical_line" . #x2016)
("double_low_line" . #x2017)
("left_single_quotation_mark" . #x2018)
("right_single_quotation_mark" . #x2019)
("single_low_9_quotation_mark" . #x201a)
("single_high_reversed_9_quotation_mark" . #x201b)
("left_double_quotation_mark" . #x201c)
("right_double_quotation_mark" . #x201d)
("double_low_9_quotation_mark" . #x201e)
("double_high_reversed_9_quotation_mark" . #x201f)
("dagger" . #x2020)
("double_dagger" . #x2021)
("bullet" . #x2022)
("triangular_bullet" . #x2023)
("one_dot_leader" . #x2024)
("two_dot_leader" . #x2025)
("horizontal_ellipsis" . #x2026)
("hyphenation_point" . #x2027)
("line_separator" . #x2028)
("paragraph_separator" . #x2029)
("left_to_right_embedding" . #x202a)
("right_to_left_embedding" . #x202b)
("pop_directional_formatting" . #x202c)
("left_to_right_override" . #x202d)
("right_to_left_override" . #x202e)
("per_mille_sign" . #x2030)
("per_ten_thousand_sign" . #x2031)
("prime" . #x2032)
("double_prime" . #x2033)
("triple_prime" . #x2034)
("reversed_prime" . #x2035)
("reversed_double_prime" . #x2036)
("reversed_triple_prime" . #x2037)
("caret" . #x2038)
("single_left_pointing_angle_quotation_mark" . #x2039)
("single_right_pointing_angle_quotation_mark" . #x203a)
("reference_mark" . #x203b)
("double_exclamation_mark" . #x203c)
("interrobang" . #x203d)
("overline" . #x203e)
("undertie" . #x203f)
("character_tie" . #x2040)
("caret_insertion_point" . #x2041)
("asterism" . #x2042)
("hyphen_bullet" . #x2043)
("fraction_slash" . #x2044)
("left_square_bracket_with_quill" . #x2045)
("right_square_bracket_with_quill" . #x2046)
("superscript_zero" . #x2070)
("superscript_four" . #x2074)
("superscript_five" . #x2075)
("superscript_six" . #x2076)
("superscript_seven" . #x2077)
("superscript_eight" . #x2078)
("superscript_nine" . #x2079)
("superscript_plus_sign" . #x207a)
("superscript_minus" . #x207b)
("superscript_equals_sign" . #x207c)
("superscript_left_parenthesis" . #x207d)
("superscript_right_parenthesis" . #x207e)
("superscript_latin_small_letter_n" . #x207f)
("subscript_zero" . #x2080)
("subscript_one" . #x2081)
("subscript_two" . #x2082)
("subscript_three" . #x2083)
("subscript_four" . #x2084)
("subscript_five" . #x2085)
("subscript_six" . #x2086)
("subscript_seven" . #x2087)
("subscript_eight" . #x2088)
("subscript_nine" . #x2089)
("subscript_plus_sign" . #x208a)
("subscript_minus" . #x208b)
("subscript_equals_sign" . #x208c)
("subscript_left_parenthesis" . #x208d)
("subscript_right_parenthesis" . #x208e)
("euro_currency_sign" . #x20a0)
("colon_sign" . #x20a1)
("cruzeiro_sign" . #x20a2)
("french_franc_sign" . #x20a3)
("lira_sign" . #x20a4)
("mill_sign" . #x20a5)
("naira_sign" . #x20a6)
("peseta_sign" . #x20a7)
("rupee_sign" . #x20a8)
("won_sign" . #x20a9)
("new_sheqel_sign" . #x20aa)
("dong_sign" . #x20ab)
("euro_sign" . #x20ac)
("account_of" . #x2100)
("addressed_to_the_subject" . #x2101)
("double_struck_capital_c" . #x2102)
("degree_celsius" . #x2103)
("centre_line_symbol" . #x2104)
("care_of" . #x2105)
("cada_una" . #x2106)
("euler_constant" . #x2107)
("scruple" . #x2108)
("degree_fahrenheit" . #x2109)
("script_small_g" . #x210a)
("script_capital_h" . #x210b)
("black_letter_capital_h" . #x210c)
("double_struck_capital_h" . #x210d)
("planck_constant" . #x210e)
("planck_constant_over_two_pi" . #x210f)
("script_capital_i" . #x2110)
("black_letter_capital_i" . #x2111)
("script_capital_l" . #x2112)
("script_small_l" . #x2113)
("l_b_bar_symbol" . #x2114)
("double_struck_capital_n" . #x2115)
("numero_sign" . #x2116)
("sound_recording_copyright" . #x2117)
("script_capital_p" . #x2118)
("double_struck_capital_p" . #x2119)
("double_struck_capital_q" . #x211a)
("script_capital_r" . #x211b)
("black_letter_capital_r" . #x211c)
("double_struck_capital_r" . #x211d)
("prescription_take" . #x211e)
("response" . #x211f)
("service_mark" . #x2120)
("telephone_sign" . #x2121)
("trade_mark_sign" . #x2122)
("versicle" . #x2123)
("double_struck_capital_z" . #x2124)
("ounce_sign" . #x2125)
("ohm_sign" . #x2126)
("inverted_ohm_sign" . #x2127)
("black_letter_capital_z" . #x2128)
("turned_greek_small_letter_iota" . #x2129)
("kelvin_sign" . #x212a)
("angstrom_sign" . #x212b)
("script_capital_b" . #x212c)
("black_letter_capital_c" . #x212d)
("estimated_symbol" . #x212e)
("script_small_e" . #x212f)
("script_capital_e" . #x2130)
("script_capital_f" . #x2131)
("turned_capital_f" . #x2132)
("script_capital_m" . #x2133)
("script_small_o" . #x2134)
("alef_symbol" . #x2135)
("bet_symbol" . #x2136)
("gimel_symbol" . #x2137)
("dalet_symbol" . #x2138)
("vulgar_fraction_one_third" . #x2153)
("vulgar_fraction_two_thirds" . #x2154)
("vulgar_fraction_one_fifth" . #x2155)
("vulgar_fraction_two_fifths" . #x2156)
("vulgar_fraction_three_fifths" . #x2157)
("vulgar_fraction_four_fifths" . #x2158)
("vulgar_fraction_one_sixth" . #x2159)
("vulgar_fraction_five_sixths" . #x215a)
("vulgar_fraction_one_eighth" . #x215b)
("vulgar_fraction_three_eighths" . #x215c)
("vulgar_fraction_five_eighths" . #x215d)
("vulgar_fraction_seven_eighths" . #x215e)
("fraction_numerator_one" . #x215f)
("roman_numeral_one" . #x2160)
("roman_numeral_two" . #x2161)
("roman_numeral_three" . #x2162)
("roman_numeral_four" . #x2163)
("roman_numeral_five" . #x2164)
("roman_numeral_six" . #x2165)
("roman_numeral_seven" . #x2166)
("roman_numeral_eight" . #x2167)
("roman_numeral_nine" . #x2168)
("roman_numeral_ten" . #x2169)
("roman_numeral_eleven" . #x216a)
("roman_numeral_twelve" . #x216b)
("roman_numeral_fifty" . #x216c)
("roman_numeral_one_hundred" . #x216d)
("roman_numeral_five_hundred" . #x216e)
("roman_numeral_one_thousand" . #x216f)
("small_roman_numeral_one" . #x2170)
("small_roman_numeral_two" . #x2171)
("small_roman_numeral_three" . #x2172)
("small_roman_numeral_four" . #x2173)
("small_roman_numeral_five" . #x2174)
("small_roman_numeral_six" . #x2175)
("small_roman_numeral_seven" . #x2176)
("small_roman_numeral_eight" . #x2177)
("small_roman_numeral_nine" . #x2178)
("small_roman_numeral_ten" . #x2179)
("small_roman_numeral_eleven" . #x217a)
("small_roman_numeral_twelve" . #x217b)
("small_roman_numeral_fifty" . #x217c)
("small_roman_numeral_one_hundred" . #x217d)
("small_roman_numeral_five_hundred" . #x217e)
("small_roman_numeral_one_thousand" . #x217f)
("roman_numeral_one_thousand_c_d" . #x2180)
("roman_numeral_five_thousand" . #x2181)
("roman_numeral_ten_thousand" . #x2182)
("leftwards_arrow" . #x2190)
("upwards_arrow" . #x2191)
("rightwards_arrow" . #x2192)
("downwards_arrow" . #x2193)
("left_right_arrow" . #x2194)
("up_down_arrow" . #x2195)
("north_west_arrow" . #x2196)
("north_east_arrow" . #x2197)
("south_east_arrow" . #x2198)
("south_west_arrow" . #x2199)
("leftwards_arrow_with_stroke" . #x219a)
("rightwards_arrow_with_stroke" . #x219b)
("leftwards_wave_arrow" . #x219c)
("rightwards_wave_arrow" . #x219d)
("leftwards_two_headed_arrow" . #x219e)
("upwards_two_headed_arrow" . #x219f)
("rightwards_two_headed_arrow" . #x21a0)
("downwards_two_headed_arrow" . #x21a1)
("leftwards_arrow_with_tail" . #x21a2)
("rightwards_arrow_with_tail" . #x21a3)
("leftwards_arrow_from_bar" . #x21a4)
("upwards_arrow_from_bar" . #x21a5)
("rightwards_arrow_from_bar" . #x21a6)
("downwards_arrow_from_bar" . #x21a7)
("up_down_arrow_with_base" . #x21a8)
("leftwards_arrow_with_hook" . #x21a9)
("rightwards_arrow_with_hook" . #x21aa)
("leftwards_arrow_with_loop" . #x21ab)
("rightwards_arrow_with_loop" . #x21ac)
("left_right_wave_arrow" . #x21ad)
("left_right_arrow_with_stroke" . #x21ae)
("downwards_zigzag_arrow" . #x21af)
("upwards_arrow_with_tip_leftwards" . #x21b0)
("upwards_arrow_with_tip_rightwards" . #x21b1)
("downwards_arrow_with_tip_leftwards" . #x21b2)
("downwards_arrow_with_tip_rightwards" . #x21b3)
("rightwards_arrow_with_corner_downwards" . #x21b4)
("downwards_arrow_with_corner_leftwards" . #x21b5)
("anticlockwise_top_semicircle_arrow" . #x21b6)
("clockwise_top_semicircle_arrow" . #x21b7)
("north_west_arrow_to_long_bar" . #x21b8)
("leftwards_arrow_to_bar_over_rightwards_arrow_to_bar" . #x21b9)
("anticlockwise_open_circle_arrow" . #x21ba)
("clockwise_open_circle_arrow" . #x21bb)
("leftwards_harpoon_with_barb_upwards" . #x21bc)
("leftwards_harpoon_with_barb_downwards" . #x21bd)
("upwards_harpoon_with_barb_rightwards" . #x21be)
("upwards_harpoon_with_barb_leftwards" . #x21bf)
("rightwards_harpoon_with_barb_upwards" . #x21c0)
("rightwards_harpoon_with_barb_downwards" . #x21c1)
("downwards_harpoon_with_barb_rightwards" . #x21c2)
("downwards_harpoon_with_barb_leftwards" . #x21c3)
("rightwards_arrow_over_leftwards_arrow" . #x21c4)
("upwards_arrow_leftwards_of_downwards_arrow" . #x21c5)
("leftwards_arrow_over_rightwards_arrow" . #x21c6)
("leftwards_paired_arrows" . #x21c7)
("upwards_paired_arrows" . #x21c8)
("rightwards_paired_arrows" . #x21c9)
("downwards_paired_arrows" . #x21ca)
("leftwards_harpoon_over_rightwards_harpoon" . #x21cb)
("rightwards_harpoon_over_leftwards_harpoon" . #x21cc)
("leftwards_double_arrow_with_stroke" . #x21cd)
("left_right_double_arrow_with_stroke" . #x21ce)
("rightwards_double_arrow_with_stroke" . #x21cf)
("leftwards_double_arrow" . #x21d0)
("upwards_double_arrow" . #x21d1)
("rightwards_double_arrow" . #x21d2)
("downwards_double_arrow" . #x21d3)
("left_right_double_arrow" . #x21d4)
("up_down_double_arrow" . #x21d5)
("north_west_double_arrow" . #x21d6)
("north_east_double_arrow" . #x21d7)
("south_east_double_arrow" . #x21d8)
("south_west_double_arrow" . #x21d9)
("leftwards_triple_arrow" . #x21da)
("rightwards_triple_arrow" . #x21db)
("leftwards_squiggle_arrow" . #x21dc)
("rightwards_squiggle_arrow" . #x21dd)
("upwards_arrow_with_double_stroke" . #x21de)
("downwards_arrow_with_double_stroke" . #x21df)
("leftwards_dashed_arrow" . #x21e0)
("upwards_dashed_arrow" . #x21e1)
("rightwards_dashed_arrow" . #x21e2)
("downwards_dashed_arrow" . #x21e3)
("leftwards_arrow_to_bar" . #x21e4)
("rightwards_arrow_to_bar" . #x21e5)
("leftwards_white_arrow" . #x21e6)
("upwards_white_arrow" . #x21e7)
("rightwards_white_arrow" . #x21e8)
("downwards_white_arrow" . #x21e9)
("upwards_white_arrow_from_bar" . #x21ea)
("for_all" . #x2200)
("complement" . #x2201)
("partial_differential" . #x2202)
("there_exists" . #x2203)
("there_does_not_exist" . #x2204)
("empty_set" . #x2205)
("increment" . #x2206)
("nabla" . #x2207)
("element_of" . #x2208)
("not_an_element_of" . #x2209)
("small_element_of" . #x220a)
("contains_as_member" . #x220b)
("does_not_contain_as_member" . #x220c)
("small_contains_as_member" . #x220d)
("end_of_proof" . #x220e)
("n_ary_product" . #x220f)
("n_ary_coproduct" . #x2210)
("n_ary_summation" . #x2211)
("minus_sign" . #x2212)
("minus_or_plus_sign" . #x2213)
("dot_plus" . #x2214)
("division_slash" . #x2215)
("set_minus" . #x2216)
("asterisk_operator" . #x2217)
("ring_operator" . #x2218)
("bullet_operator" . #x2219)
("square_root" . #x221a)
("cube_root" . #x221b)
("fourth_root" . #x221c)
("proportional_to" . #x221d)
("infinity" . #x221e)
("right_angle" . #x221f)
("angle" . #x2220)
("measured_angle" . #x2221)
("spherical_angle" . #x2222)
("divides" . #x2223)
("does_not_divide" . #x2224)
("parallel_to" . #x2225)
("not_parallel_to" . #x2226)
("logical_and" . #x2227)
("logical_or" . #x2228)
("intersection" . #x2229)
("union" . #x222a)
("integral" . #x222b)
("double_integral" . #x222c)
("triple_integral" . #x222d)
("contour_integral" . #x222e)
("surface_integral" . #x222f)
("volume_integral" . #x2230)
("clockwise_integral" . #x2231)
("clockwise_contour_integral" . #x2232)
("anticlockwise_contour_integral" . #x2233)
("therefore" . #x2234)
("because" . #x2235)
("ratio" . #x2236)
("proportion" . #x2237)
("dot_minus" . #x2238)
("excess" . #x2239)
("geometric_proportion" . #x223a)
("homothetic" . #x223b)
("tilde_operator" . #x223c)
("reversed_tilde" . #x223d)
("inverted_lazy_s" . #x223e)
("sine_wave" . #x223f)
("wreath_product" . #x2240)
("not_tilde" . #x2241)
("minus_tilde" . #x2242)
("asymptotically_equal_to" . #x2243)
("not_asymptotically_equal_to" . #x2244)
("approximately_equal_to" . #x2245)
("approximately_but_not_actually_equal_to" . #x2246)
("neither_approximately_nor_actually_equal_to" . #x2247)
("almost_equal_to" . #x2248)
("not_almost_equal_to" . #x2249)
("almost_equal_or_equal_to" . #x224a)
("triple_tilde" . #x224b)
("all_equal_to" . #x224c)
("equivalent_to" . #x224d)
("geometrically_equivalent_to" . #x224e)
("difference_between" . #x224f)
("approaches_the_limit" . #x2250)
("geometrically_equal_to" . #x2251)
("approximately_equal_to_or_the_image_of" . #x2252)
("image_of_or_approximately_equal_to" . #x2253)
("colon_equals" . #x2254)
("equals_colon" . #x2255)
("ring_in_equal_to" . #x2256)
("ring_equal_to" . #x2257)
("corresponds_to" . #x2258)
("estimates" . #x2259)
("equiangular_to" . #x225a)
("star_equals" . #x225b)
("delta_equal_to" . #x225c)
("equal_to_by_definition" . #x225d)
("measured_by" . #x225e)
("questioned_equal_to" . #x225f)
("not_equal_to" . #x2260)
("identical_to" . #x2261)
("not_identical_to" . #x2262)
("strictly_equivalent_to" . #x2263)
("less_than_or_equal_to" . #x2264)
("greater_than_or_equal_to" . #x2265)
("less_than_over_equal_to" . #x2266)
("greater_than_over_equal_to" . #x2267)
("less_than_but_not_equal_to" . #x2268)
("greater_than_but_not_equal_to" . #x2269)
("much_less_than" . #x226a)
("much_greater_than" . #x226b)
("between" . #x226c)
("not_equivalent_to" . #x226d)
("not_less_than" . #x226e)
("not_greater_than" . #x226f)
("neither_less_than_nor_equal_to" . #x2270)
("neither_greater_than_nor_equal_to" . #x2271)
("less_than_or_equivalent_to" . #x2272)
("greater_than_or_equivalent_to" . #x2273)
("neither_less_than_nor_equivalent_to" . #x2274)
("neither_greater_than_nor_equivalent_to" . #x2275)
("less_than_or_greater_than" . #x2276)
("greater_than_or_less_than" . #x2277)
("neither_less_than_nor_greater_than" . #x2278)
("neither_greater_than_nor_less_than" . #x2279)
("precedes" . #x227a)
("succeeds" . #x227b)
("precedes_or_equal_to" . #x227c)
("succeeds_or_equal_to" . #x227d)
("precedes_or_equivalent_to" . #x227e)
("succeeds_or_equivalent_to" . #x227f)
("does_not_precede" . #x2280)
("does_not_succeed" . #x2281)
("subset_of" . #x2282)
("superset_of" . #x2283)
("not_a_subset_of" . #x2284)
("not_a_superset_of" . #x2285)
("subset_of_or_equal_to" . #x2286)
("superset_of_or_equal_to" . #x2287)
("neither_a_subset_of_nor_equal_to" . #x2288)
("neither_a_superset_of_nor_equal_to" . #x2289)
("subset_of_with_not_equal_to" . #x228a)
("superset_of_with_not_equal_to" . #x228b)
("multiset" . #x228c)
("multiset_multiplication" . #x228d)
("multiset_union" . #x228e)
("square_image_of" . #x228f)
("square_original_of" . #x2290)
("square_image_of_or_equal_to" . #x2291)
("square_original_of_or_equal_to" . #x2292)
("square_cap" . #x2293)
("square_cup" . #x2294)
("circled_plus" . #x2295)
("circled_minus" . #x2296)
("circled_times" . #x2297)
("circled_division_slash" . #x2298)
("circled_dot_operator" . #x2299)
("circled_ring_operator" . #x229a)
("circled_asterisk_operator" . #x229b)
("circled_equals" . #x229c)
("circled_dash" . #x229d)
("squared_plus" . #x229e)
("squared_minus" . #x229f)
("squared_times" . #x22a0)
("squared_dot_operator" . #x22a1)
("right_tack" . #x22a2)
("left_tack" . #x22a3)
("down_tack" . #x22a4)
("up_tack" . #x22a5)
("assertion" . #x22a6)
("models" . #x22a7)
("true" . #x22a8)
("forces" . #x22a9)
("triple_vertical_bar_right_turnstile" . #x22aa)
("double_vertical_bar_double_right_turnstile" . #x22ab)
("does_not_prove" . #x22ac)
("not_true" . #x22ad)
("does_not_force" . #x22ae)
("negated_double_vertical_bar_double_right_turnstile" . #x22af)
("precedes_under_relation" . #x22b0)
("succeeds_under_relation" . #x22b1)
("normal_subgroup_of" . #x22b2)
("contains_as_normal_subgroup" . #x22b3)
("normal_subgroup_of_or_equal_to" . #x22b4)
("contains_as_normal_subgroup_or_equal_to" . #x22b5)
("original_of" . #x22b6)
("image_of" . #x22b7)
("multimap" . #x22b8)
("hermitian_conjugate_matrix" . #x22b9)
("intercalate" . #x22ba)
("xor" . #x22bb)
("nand" . #x22bc)
("nor" . #x22bd)
("right_angle_with_arc" . #x22be)
("right_triangle" . #x22bf)
("n_ary_logical_and" . #x22c0)
("n_ary_logical_or" . #x22c1)
("n_ary_intersection" . #x22c2)
("n_ary_union" . #x22c3)
("diamond_operator" . #x22c4)
("dot_operator" . #x22c5)
("star_operator" . #x22c6)
("division_times" . #x22c7)
("bowtie" . #x22c8)
("left_normal_factor_semidirect_product" . #x22c9)
("right_normal_factor_semidirect_product" . #x22ca)
("left_semidirect_product" . #x22cb)
("right_semidirect_product" . #x22cc)
("reversed_tilde_equals" . #x22cd)
("curly_logical_or" . #x22ce)
("curly_logical_and" . #x22cf)
("double_subset" . #x22d0)
("double_superset" . #x22d1)
("double_intersection" . #x22d2)
("double_union" . #x22d3)
("pitchfork" . #x22d4)
("equal_and_parallel_to" . #x22d5)
("less_than_with_dot" . #x22d6)
("greater_than_with_dot" . #x22d7)
("very_much_less_than" . #x22d8)
("very_much_greater_than" . #x22d9)
("less_than_equal_to_or_greater_than" . #x22da)
("greater_than_equal_to_or_less_than" . #x22db)
("equal_to_or_less_than" . #x22dc)
("equal_to_or_greater_than" . #x22dd)
("equal_to_or_precedes" . #x22de)
("equal_to_or_succeeds" . #x22df)
("does_not_precede_or_equal" . #x22e0)
("does_not_succeed_or_equal" . #x22e1)
("not_square_image_of_or_equal_to" . #x22e2)
("not_square_original_of_or_equal_to" . #x22e3)
("square_image_of_or_not_equal_to" . #x22e4)
("square_original_of_or_not_equal_to" . #x22e5)
("less_than_but_not_equivalent_to" . #x22e6)
("greater_than_but_not_equivalent_to" . #x22e7)
("precedes_but_not_equivalent_to" . #x22e8)
("succeeds_but_not_equivalent_to" . #x22e9)
("not_normal_subgroup_of" . #x22ea)
("does_not_contain_as_normal_subgroup" . #x22eb)
("not_normal_subgroup_of_or_equal_to" . #x22ec)
("does_not_contain_as_normal_subgroup_or_equal" . #x22ed)
("vertical_ellipsis" . #x22ee)
("midline_horizontal_ellipsis" . #x22ef)
("up_right_diagonal_ellipsis" . #x22f0)
("down_right_diagonal_ellipsis" . #x22f1)
("house" . #x2302)
("reversed_not_sign" . #x2310)
("arc" . #x2312)
("top_half_integral" . #x2320)
("bottom_half_integral" . #x2321)
("circled_digit_one" . #x2460)
("circled_digit_two" . #x2461)
("circled_digit_three" . #x2462)
("circled_digit_four" . #x2463)
("circled_digit_five" . #x2464)
("circled_digit_six" . #x2465)
("circled_digit_seven" . #x2466)
("circled_digit_eight" . #x2467)
("circled_digit_nine" . #x2468)
("circled_number_ten" . #x2469)
("circled_number_eleven" . #x246a)
("circled_number_twelve" . #x246b)
("circled_number_thirteen" . #x246c)
("circled_number_fourteen" . #x246d)
("circled_number_fifteen" . #x246e)
("circled_number_sixteen" . #x246f)
("circled_number_seventeen" . #x2470)
("circled_number_eighteen" . #x2471)
("circled_number_nineteen" . #x2472)
("circled_number_twenty" . #x2473)
("parenthesized_digit_one" . #x2474)
("parenthesized_digit_two" . #x2475)
("parenthesized_digit_three" . #x2476)
("parenthesized_digit_four" . #x2477)
("parenthesized_digit_five" . #x2478)
("parenthesized_digit_six" . #x2479)
("parenthesized_digit_seven" . #x247a)
("parenthesized_digit_eight" . #x247b)
("parenthesized_digit_nine" . #x247c)
("parenthesized_number_ten" . #x247d)
("parenthesized_number_eleven" . #x247e)
("parenthesized_number_twelve" . #x247f)
("parenthesized_number_thirteen" . #x2480)
("parenthesized_number_fourteen" . #x2481)
("parenthesized_number_fifteen" . #x2482)
("parenthesized_number_sixteen" . #x2483)
("parenthesized_number_seventeen" . #x2484)
("parenthesized_number_eighteen" . #x2485)
("parenthesized_number_nineteen" . #x2486)
("parenthesized_number_twenty" . #x2487)
("digit_one_full_stop" . #x2488)
("digit_two_full_stop" . #x2489)
("digit_three_full_stop" . #x248a)
("digit_four_full_stop" . #x248b)
("digit_five_full_stop" . #x248c)
("digit_six_full_stop" . #x248d)
("digit_seven_full_stop" . #x248e)
("digit_eight_full_stop" . #x248f)
("digit_nine_full_stop" . #x2490)
("number_ten_full_stop" . #x2491)
("number_eleven_full_stop" . #x2492)
("number_twelve_full_stop" . #x2493)
("number_thirteen_full_stop" . #x2494)
("number_fourteen_full_stop" . #x2495)
("number_fifteen_full_stop" . #x2496)
("number_sixteen_full_stop" . #x2497)
("number_seventeen_full_stop" . #x2498)
("number_eighteen_full_stop" . #x2499)
("number_nineteen_full_stop" . #x249a)
("number_twenty_full_stop" . #x249b)
("parenthesized_latin_small_letter_a" . #x249c)
("parenthesized_latin_small_letter_b" . #x249d)
("parenthesized_latin_small_letter_c" . #x249e)
("parenthesized_latin_small_letter_d" . #x249f)
("parenthesized_latin_small_letter_e" . #x24a0)
("parenthesized_latin_small_letter_f" . #x24a1)
("parenthesized_latin_small_letter_g" . #x24a2)
("parenthesized_latin_small_letter_h" . #x24a3)
("parenthesized_latin_small_letter_i" . #x24a4)
("parenthesized_latin_small_letter_j" . #x24a5)
("parenthesized_latin_small_letter_k" . #x24a6)
("parenthesized_latin_small_letter_l" . #x24a7)
("parenthesized_latin_small_letter_m" . #x24a8)
("parenthesized_latin_small_letter_n" . #x24a9)
("parenthesized_latin_small_letter_o" . #x24aa)
("parenthesized_latin_small_letter_p" . #x24ab)
("parenthesized_latin_small_letter_q" . #x24ac)
("parenthesized_latin_small_letter_r" . #x24ad)
("parenthesized_latin_small_letter_s" . #x24ae)
("parenthesized_latin_small_letter_t" . #x24af)
("parenthesized_latin_small_letter_u" . #x24b0)
("parenthesized_latin_small_letter_v" . #x24b1)
("parenthesized_latin_small_letter_w" . #x24b2)
("parenthesized_latin_small_letter_x" . #x24b3)
("parenthesized_latin_small_letter_y" . #x24b4)
("parenthesized_latin_small_letter_z" . #x24b5)
("circled_latin_capital_letter_a" . #x24b6)
("circled_latin_capital_letter_b" . #x24b7)
("circled_latin_capital_letter_c" . #x24b8)
("circled_latin_capital_letter_d" . #x24b9)
("circled_latin_capital_letter_e" . #x24ba)
("circled_latin_capital_letter_f" . #x24bb)
("circled_latin_capital_letter_g" . #x24bc)
("circled_latin_capital_letter_h" . #x24bd)
("circled_latin_capital_letter_i" . #x24be)
("circled_latin_capital_letter_j" . #x24bf)
("circled_latin_capital_letter_k" . #x24c0)
("circled_latin_capital_letter_l" . #x24c1)
("circled_latin_capital_letter_m" . #x24c2)
("circled_latin_capital_letter_n" . #x24c3)
("circled_latin_capital_letter_o" . #x24c4)
("circled_latin_capital_letter_p" . #x24c5)
("circled_latin_capital_letter_q" . #x24c6)
("circled_latin_capital_letter_r" . #x24c7)
("circled_latin_capital_letter_s" . #x24c8)
("circled_latin_capital_letter_t" . #x24c9)
("circled_latin_capital_letter_u" . #x24ca)
("circled_latin_capital_letter_v" . #x24cb)
("circled_latin_capital_letter_w" . #x24cc)
("circled_latin_capital_letter_x" . #x24cd)
("circled_latin_capital_letter_y" . #x24ce)
("circled_latin_capital_letter_z" . #x24cf)
("circled_latin_small_letter_a" . #x24d0)
("circled_latin_small_letter_b" . #x24d1)
("circled_latin_small_letter_c" . #x24d2)
("circled_latin_small_letter_d" . #x24d3)
("circled_latin_small_letter_e" . #x24d4)
("circled_latin_small_letter_f" . #x24d5)
("circled_latin_small_letter_g" . #x24d6)
("circled_latin_small_letter_h" . #x24d7)
("circled_latin_small_letter_i" . #x24d8)
("circled_latin_small_letter_j" . #x24d9)
("circled_latin_small_letter_k" . #x24da)
("circled_latin_small_letter_l" . #x24db)
("circled_latin_small_letter_m" . #x24dc)
("circled_latin_small_letter_n" . #x24dd)
("circled_latin_small_letter_o" . #x24de)
("circled_latin_small_letter_p" . #x24df)
("circled_latin_small_letter_q" . #x24e0)
("circled_latin_small_letter_r" . #x24e1)
("circled_latin_small_letter_s" . #x24e2)
("circled_latin_small_letter_t" . #x24e3)
("circled_latin_small_letter_u" . #x24e4)
("circled_latin_small_letter_v" . #x24e5)
("circled_latin_small_letter_w" . #x24e6)
("circled_latin_small_letter_x" . #x24e7)
("circled_latin_small_letter_y" . #x24e8)
("circled_latin_small_letter_z" . #x24e9)
("circled_digit_zero" . #x24ea)
("box_drawings_light_horizontal" . #x2500)
("box_drawings_heavy_horizontal" . #x2501)
("box_drawings_light_vertical" . #x2502)
("box_drawings_heavy_vertical" . #x2503)
("box_drawings_light_triple_dash_horizontal" . #x2504)
("box_drawings_heavy_triple_dash_horizontal" . #x2505)
("box_drawings_light_triple_dash_vertical" . #x2506)
("box_drawings_heavy_triple_dash_vertical" . #x2507)
("box_drawings_light_quadruple_dash_horizontal" . #x2508)
("box_drawings_heavy_quadruple_dash_horizontal" . #x2509)
("box_drawings_light_quadruple_dash_vertical" . #x250a)
("box_drawings_heavy_quadruple_dash_vertical" . #x250b)
("box_drawings_light_down_and_right" . #x250c)
("box_drawings_down_light_and_right_heavy" . #x250d)
("box_drawings_down_heavy_and_right_light" . #x250e)
("box_drawings_heavy_down_and_right" . #x250f)
("box_drawings_light_down_and_left" . #x2510)
("box_drawings_down_light_and_left_heavy" . #x2511)
("box_drawings_down_heavy_and_left_light" . #x2512)
("box_drawings_heavy_down_and_left" . #x2513)
("box_drawings_light_up_and_right" . #x2514)
("box_drawings_up_light_and_right_heavy" . #x2515)
("box_drawings_up_heavy_and_right_light" . #x2516)
("box_drawings_heavy_up_and_right" . #x2517)
("box_drawings_light_up_and_left" . #x2518)
("box_drawings_up_light_and_left_heavy" . #x2519)
("box_drawings_up_heavy_and_left_light" . #x251a)
("box_drawings_heavy_up_and_left" . #x251b)
("box_drawings_light_vertical_and_right" . #x251c)
("box_drawings_vertical_light_and_right_heavy" . #x251d)
("box_drawings_up_heavy_and_right_down_light" . #x251e)
("box_drawings_down_heavy_and_right_up_light" . #x251f)
("box_drawings_vertical_heavy_and_right_light" . #x2520)
("box_drawings_down_light_and_right_up_heavy" . #x2521)
("box_drawings_up_light_and_right_down_heavy" . #x2522)
("box_drawings_heavy_vertical_and_right" . #x2523)
("box_drawings_light_vertical_and_left" . #x2524)
("box_drawings_vertical_light_and_left_heavy" . #x2525)
("box_drawings_up_heavy_and_left_down_light" . #x2526)
("box_drawings_down_heavy_and_left_up_light" . #x2527)
("box_drawings_vertical_heavy_and_left_light" . #x2528)
("box_drawings_down_light_and_left_up_heavy" . #x2529)
("box_drawings_up_light_and_left_down_heavy" . #x252a)
("box_drawings_heavy_vertical_and_left" . #x252b)
("box_drawings_light_down_and_horizontal" . #x252c)
("box_drawings_left_heavy_and_right_down_light" . #x252d)
("box_drawings_right_heavy_and_left_down_light" . #x252e)
("box_drawings_down_light_and_horizontal_heavy" . #x252f)
("box_drawings_down_heavy_and_horizontal_light" . #x2530)
("box_drawings_right_light_and_left_down_heavy" . #x2531)
("box_drawings_left_light_and_right_down_heavy" . #x2532)
("box_drawings_heavy_down_and_horizontal" . #x2533)
("box_drawings_light_up_and_horizontal" . #x2534)
("box_drawings_left_heavy_and_right_up_light" . #x2535)
("box_drawings_right_heavy_and_left_up_light" . #x2536)
("box_drawings_up_light_and_horizontal_heavy" . #x2537)
("box_drawings_up_heavy_and_horizontal_light" . #x2538)
("box_drawings_right_light_and_left_up_heavy" . #x2539)
("box_drawings_left_light_and_right_up_heavy" . #x253a)
("box_drawings_heavy_up_and_horizontal" . #x253b)
("box_drawings_light_vertical_and_horizontal" . #x253c)
("box_drawings_left_heavy_and_right_vertical_light" . #x253d)
("box_drawings_right_heavy_and_left_vertical_light" . #x253e)
("box_drawings_vertical_light_and_horizontal_heavy" . #x253f)
("box_drawings_up_heavy_and_down_horizontal_light" . #x2540)
("box_drawings_down_heavy_and_up_horizontal_light" . #x2541)
("box_drawings_vertical_heavy_and_horizontal_light" . #x2542)
("box_drawings_left_up_heavy_and_right_down_light" . #x2543)
("box_drawings_right_up_heavy_and_left_down_light" . #x2544)
("box_drawings_left_down_heavy_and_right_up_light" . #x2545)
("box_drawings_right_down_heavy_and_left_up_light" . #x2546)
("box_drawings_down_light_and_up_horizontal_heavy" . #x2547)
("box_drawings_up_light_and_down_horizontal_heavy" . #x2548)
("box_drawings_right_light_and_left_vertical_heavy" . #x2549)
("box_drawings_left_light_and_right_vertical_heavy" . #x254a)
("box_drawings_heavy_vertical_and_horizontal" . #x254b)
("box_drawings_light_double_dash_horizontal" . #x254c)
("box_drawings_heavy_double_dash_horizontal" . #x254d)
("box_drawings_light_double_dash_vertical" . #x254e)
("box_drawings_heavy_double_dash_vertical" . #x254f)
("box_drawings_double_horizontal" . #x2550)
("box_drawings_double_vertical" . #x2551)
("box_drawings_down_single_and_right_double" . #x2552)
("box_drawings_down_double_and_right_single" . #x2553)
("box_drawings_double_down_and_right" . #x2554)
("box_drawings_down_single_and_left_double" . #x2555)
("box_drawings_down_double_and_left_single" . #x2556)
("box_drawings_double_down_and_left" . #x2557)
("box_drawings_up_single_and_right_double" . #x2558)
("box_drawings_up_double_and_right_single" . #x2559)
("box_drawings_double_up_and_right" . #x255a)
("box_drawings_up_single_and_left_double" . #x255b)
("box_drawings_up_double_and_left_single" . #x255c)
("box_drawings_double_up_and_left" . #x255d)
("box_drawings_vertical_single_and_right_double" . #x255e)
("box_drawings_vertical_double_and_right_single" . #x255f)
("box_drawings_double_vertical_and_right" . #x2560)
("box_drawings_vertical_single_and_left_double" . #x2561)
("box_drawings_vertical_double_and_left_single" . #x2562)
("box_drawings_double_vertical_and_left" . #x2563)
("box_drawings_down_single_and_horizontal_double" . #x2564)
("box_drawings_down_double_and_horizontal_single" . #x2565)
("box_drawings_double_down_and_horizontal" . #x2566)
("box_drawings_up_single_and_horizontal_double" . #x2567)
("box_drawings_up_double_and_horizontal_single" . #x2568)
("box_drawings_double_up_and_horizontal" . #x2569)
("box_drawings_vertical_single_and_horizontal_double" . #x256a)
("box_drawings_vertical_double_and_horizontal_single" . #x256b)
("box_drawings_double_vertical_and_horizontal" . #x256c)
("box_drawings_light_arc_down_and_right" . #x256d)
("box_drawings_light_arc_down_and_left" . #x256e)
("box_drawings_light_arc_up_and_left" . #x256f)
("box_drawings_light_arc_up_and_right" . #x2570)
("box_drawings_light_diagonal_upper_right_to_lower_left" . #x2571)
("box_drawings_light_diagonal_upper_left_to_lower_right" . #x2572)
("box_drawings_light_diagonal_cross" . #x2573)
("box_drawings_light_left" . #x2574)
("box_drawings_light_up" . #x2575)
("box_drawings_light_right" . #x2576)
("box_drawings_light_down" . #x2577)
("box_drawings_heavy_left" . #x2578)
("box_drawings_heavy_up" . #x2579)
("box_drawings_heavy_right" . #x257a)
("box_drawings_heavy_down" . #x257b)
("box_drawings_light_left_and_heavy_right" . #x257c)
("box_drawings_light_up_and_heavy_down" . #x257d)
("box_drawings_heavy_left_and_light_right" . #x257e)
("box_drawings_heavy_up_and_light_down" . #x257f)
("upper_half_block" . #x2580)
("lower_one_eighth_block" . #x2581)
("lower_one_quarter_block" . #x2582)
("lower_three_eighths_block" . #x2583)
("lower_half_block" . #x2584)
("lower_five_eighths_block" . #x2585)
("lower_three_quarters_block" . #x2586)
("lower_seven_eighths_block" . #x2587)
("full_block" . #x2588)
("left_seven_eighths_block" . #x2589)
("left_three_quarters_block" . #x258a)
("left_five_eighths_block" . #x258b)
("left_half_block" . #x258c)
("left_three_eighths_block" . #x258d)
("left_one_quarter_block" . #x258e)
("left_one_eighth_block" . #x258f)
("right_half_block" . #x2590)
("light_shade" . #x2591)
("medium_shade" . #x2592)
("dark_shade" . #x2593)
("upper_one_eighth_block" . #x2594)
("right_one_eighth_block" . #x2595)
("black_square" . #x25a0)
("white_square" . #x25a1)
("white_square_with_rounded_corners" . #x25a2)
("white_square_containing_black_small_square" . #x25a3)
("square_with_horizontal_fill" . #x25a4)
("square_with_vertical_fill" . #x25a5)
("square_with_orthogonal_crosshatch_fill" . #x25a6)
("square_with_upper_left_to_lower_right_fill" . #x25a7)
("square_with_upper_right_to_lower_left_fill" . #x25a8)
("square_with_diagonal_crosshatch_fill" . #x25a9)
("black_small_square" . #x25aa)
("white_small_square" . #x25ab)
("black_rectangle" . #x25ac)
("white_rectangle" . #x25ad)
("black_vertical_rectangle" . #x25ae)
("white_vertical_rectangle" . #x25af)
("black_parallelogram" . #x25b0)
("white_parallelogram" . #x25b1)
("black_up_pointing_triangle" . #x25b2)
("white_up_pointing_triangle" . #x25b3)
("black_up_pointing_small_triangle" . #x25b4)
("white_up_pointing_small_triangle" . #x25b5)
("black_right_pointing_triangle" . #x25b6)
("white_right_pointing_triangle" . #x25b7)
("black_right_pointing_small_triangle" . #x25b8)
("white_right_pointing_small_triangle" . #x25b9)
("black_right_pointing_pointer" . #x25ba)
("white_right_pointing_pointer" . #x25bb)
("black_down_pointing_triangle" . #x25bc)
("white_down_pointing_triangle" . #x25bd)
("black_down_pointing_small_triangle" . #x25be)
("white_down_pointing_small_triangle" . #x25bf)
("black_left_pointing_triangle" . #x25c0)
("white_left_pointing_triangle" . #x25c1)
("black_left_pointing_small_triangle" . #x25c2)
("white_left_pointing_small_triangle" . #x25c3)
("black_left_pointing_pointer" . #x25c4)
("white_left_pointing_pointer" . #x25c5)
("black_diamond" . #x25c6)
("white_diamond" . #x25c7)
("white_diamond_containing_black_small_diamond" . #x25c8)
("fisheye" . #x25c9)
("lozenge" . #x25ca)
("white_circle" . #x25cb)
("dotted_circle" . #x25cc)
("circle_with_vertical_fill" . #x25cd)
("bullseye" . #x25ce)
("black_circle" . #x25cf)
("circle_with_left_half_black" . #x25d0)
("circle_with_right_half_black" . #x25d1)
("circle_with_lower_half_black" . #x25d2)
("circle_with_upper_half_black" . #x25d3)
("circle_with_upper_right_quadrant_black" . #x25d4)
("circle_with_all_but_upper_left_quadrant_black" . #x25d5)
("left_half_black_circle" . #x25d6)
("right_half_black_circle" . #x25d7)
("inverse_bullet" . #x25d8)
("inverse_white_circle" . #x25d9)
("upper_half_inverse_white_circle" . #x25da)
("lower_half_inverse_white_circle" . #x25db)
("upper_left_quadrant_circular_arc" . #x25dc)
("upper_right_quadrant_circular_arc" . #x25dd)
("lower_right_quadrant_circular_arc" . #x25de)
("lower_left_quadrant_circular_arc" . #x25df)
("upper_half_circle" . #x25e0)
("lower_half_circle" . #x25e1)
("black_lower_right_triangle" . #x25e2)
("black_lower_left_triangle" . #x25e3)
("black_upper_left_triangle" . #x25e4)
("black_upper_right_triangle" . #x25e5)
("white_bullet" . #x25e6)
("square_with_left_half_black" . #x25e7)
("square_with_right_half_black" . #x25e8)
("square_with_upper_left_diagonal_half_black" . #x25e9)
("square_with_lower_right_diagonal_half_black" . #x25ea)
("white_square_with_vertical_bisecting_line" . #x25eb)
("white_up_pointing_triangle_with_dot" . #x25ec)
("up_pointing_triangle_with_left_half_black" . #x25ed)
("up_pointing_triangle_with_right_half_black" . #x25ee)
("large_circle" . #x25ef)
("black_sun_with_rays" . #x2600)
("cloud" . #x2601)
("umbrella" . #x2602)
("snowman" . #x2603)
("comet" . #x2604)
("black_star" . #x2605)
("white_star" . #x2606)
("lightning" . #x2607)
("thunderstorm" . #x2608)
("sun" . #x2609)
("ascending_node" . #x260a)
("descending_node" . #x260b)
("conjunction" . #x260c)
("opposition" . #x260d)
("black_telephone" . #x260e)
("white_telephone" . #x260f)
("ballot_box" . #x2610)
("ballot_box_with_check" . #x2611)
("ballot_box_with_x" . #x2612)
("saltire" . #x2613)
("black_left_pointing_index" . #x261a)
("black_right_pointing_index" . #x261b)
("white_left_pointing_index" . #x261c)
("white_up_pointing_index" . #x261d)
("white_right_pointing_index" . #x261e)
("white_down_pointing_index" . #x261f)
("skull_and_crossbones" . #x2620)
("caution_sign" . #x2621)
("radioactive_sign" . #x2622)
("biohazard_sign" . #x2623)
("caduceus" . #x2624)
("ankh" . #x2625)
("orthodox_cross" . #x2626)
("chi_rho" . #x2627)
("cross_of_lorraine" . #x2628)
("cross_of_jerusalem" . #x2629)
("star_and_crescent" . #x262a)
("farsi_symbol" . #x262b)
("adi_shakti" . #x262c)
("hammer_and_sickle" . #x262d)
("peace_symbol" . #x262e)
("yin_yang" . #x262f)
("trigram_for_heaven" . #x2630)
("trigram_for_lake" . #x2631)
("trigram_for_fire" . #x2632)
("trigram_for_thunder" . #x2633)
("trigram_for_wind" . #x2634)
("trigram_for_water" . #x2635)
("trigram_for_mountain" . #x2636)
("trigram_for_earth" . #x2637)
("wheel_of_dharma" . #x2638)
("white_frowning_face" . #x2639)
("white_smiling_face" . #x263a)
("black_smiling_face" . #x263b)
("white_sun_with_rays" . #x263c)
("first_quarter_moon" . #x263d)
("last_quarter_moon" . #x263e)
("mercury" . #x263f)
("female_sign" . #x2640)
("earth" . #x2641)
("male_sign" . #x2642)
("jupiter" . #x2643)
("saturn" . #x2644)
("uranus" . #x2645)
("neptune" . #x2646)
("pluto" . #x2647)
("aries" . #x2648)
("taurus" . #x2649)
("gemini" . #x264a)
("cancer" . #x264b)
("leo" . #x264c)
("virgo" . #x264d)
("libra" . #x264e)
("scorpius" . #x264f)
("sagittarius" . #x2650)
("capricorn" . #x2651)
("aquarius" . #x2652)
("pisces" . #x2653)
("white_chess_king" . #x2654)
("white_chess_queen" . #x2655)
("white_chess_rook" . #x2656)
("white_chess_bishop" . #x2657)
("white_chess_knight" . #x2658)
("white_chess_pawn" . #x2659)
("black_chess_king" . #x265a)
("black_chess_queen" . #x265b)
("black_chess_rook" . #x265c)
("black_chess_bishop" . #x265d)
("black_chess_knight" . #x265e)
("black_chess_pawn" . #x265f)
("black_spade_suit" . #x2660)
("white_heart_suit" . #x2661)
("white_diamond_suit" . #x2662)
("black_club_suit" . #x2663)
("white_spade_suit" . #x2664)
("black_heart_suit" . #x2665)
("black_diamond_suit" . #x2666)
("white_club_suit" . #x2667)
("hot_springs" . #x2668)
("quarter_note" . #x2669)
("eighth_note" . #x266a)
("beamed_eighth_notes" . #x266b)
("beamed_sixteenth_notes" . #x266c)
("music_flat_sign" . #x266d)
("music_natural_sign" . #x266e)
("music_sharp_sign" . #x266f)
("upper_blade_scissors" . #x2701)
("black_scissors" . #x2702)
("lower_blade_scissors" . #x2703)
("white_scissors" . #x2704)
("telephone_location_sign" . #x2706)
("tape_drive" . #x2707)
("airplane" . #x2708)
("envelope" . #x2709)
("victory_hand" . #x270c)
("writing_hand" . #x270d)
("lower_right_pencil" . #x270e)
("pencil" . #x270f)
("upper_right_pencil" . #x2710)
("white_nib" . #x2711)
("black_nib" . #x2712)
("check_mark" . #x2713)
("heavy_check_mark" . #x2714)
("multiplication_x" . #x2715)
("heavy_multiplication_x" . #x2716)
("ballot_x" . #x2717)
("heavy_ballot_x" . #x2718)
("outlined_greek_cross" . #x2719)
("heavy_greek_cross" . #x271a)
("open_centre_cross" . #x271b)
("heavy_open_centre_cross" . #x271c)
("latin_cross" . #x271d)
("shadowed_white_latin_cross" . #x271e)
("outlined_latin_cross" . #x271f)
("maltese_cross" . #x2720)
("star_of_david" . #x2721)
("four_teardrop_spoked_asterisk" . #x2722)
("four_balloon_spoked_asterisk" . #x2723)
("heavy_four_balloon_spoked_asterisk" . #x2724)
("four_club_spoked_asterisk" . #x2725)
("black_four_pointed_star" . #x2726)
("white_four_pointed_star" . #x2727)
("stress_outlined_white_star" . #x2729)
("circled_white_star" . #x272a)
("open_centre_black_star" . #x272b)
("black_centre_white_star" . #x272c)
("outlined_black_star" . #x272d)
("heavy_outlined_black_star" . #x272e)
("pinwheel_star" . #x272f)
("shadowed_white_star" . #x2730)
("heavy_asterisk" . #x2731)
("open_centre_asterisk" . #x2732)
("eight_spoked_asterisk" . #x2733)
("eight_pointed_black_star" . #x2734)
("eight_pointed_pinwheel_star" . #x2735)
("six_pointed_black_star" . #x2736)
("eight_pointed_rectilinear_black_star" . #x2737)
("heavy_eight_pointed_rectilinear_black_star" . #x2738)
("twelve_pointed_black_star" . #x2739)
("sixteen_pointed_asterisk" . #x273a)
("teardrop_spoked_asterisk" . #x273b)
("open_centre_teardrop_spoked_asterisk" . #x273c)
("heavy_teardrop_spoked_asterisk" . #x273d)
("six_petalled_black_and_white_florette" . #x273e)
("black_florette" . #x273f)
("white_florette" . #x2740)
("eight_petalled_outlined_black_florette" . #x2741)
("circled_open_centre_eight_pointed_star" . #x2742)
("heavy_teardrop_spoked_pinwheel_asterisk" . #x2743)
("snowflake" . #x2744)
("tight_trifoliate_snowflake" . #x2745)
("heavy_chevron_snowflake" . #x2746)
("sparkle" . #x2747)
("heavy_sparkle" . #x2748)
("balloon_spoked_asterisk" . #x2749)
("eight_teardrop_spoked_propeller_asterisk" . #x274a)
("heavy_eight_teardrop_spoked_propeller_asterisk" . #x274b)
("shadowed_white_circle" . #x274d)
("lower_right_drop_shadowed_white_square" . #x274f)
("upper_right_drop_shadowed_white_square" . #x2750)
("lower_right_shadowed_white_square" . #x2751)
("upper_right_shadowed_white_square" . #x2752)
("black_diamond_minus_white_x" . #x2756)
("light_vertical_bar" . #x2758)
("medium_vertical_bar" . #x2759)
("heavy_vertical_bar" . #x275a)
("heavy_single_turned_comma_quotation_mark_ornament" . #x275b)
("heavy_single_comma_quotation_mark_ornament" . #x275c)
("heavy_double_turned_comma_quotation_mark_ornament" . #x275d)
("heavy_double_comma_quotation_mark_ornament" . #x275e)
("curved_stem_paragraph_sign_ornament" . #x2761)
("heavy_exclamation_mark_ornament" . #x2762)
("heavy_heart_exclamation_mark_ornament" . #x2763)
("heavy_black_heart" . #x2764)
("rotated_heavy_black_heart_bullet" . #x2765)
("floral_heart" . #x2766)
("rotated_floral_heart_bullet" . #x2767)
("dingbat_negative_circled_digit_one" . #x2776)
("dingbat_negative_circled_digit_two" . #x2777)
("dingbat_negative_circled_digit_three" . #x2778)
("dingbat_negative_circled_digit_four" . #x2779)
("dingbat_negative_circled_digit_five" . #x277a)
("dingbat_negative_circled_digit_six" . #x277b)
("dingbat_negative_circled_digit_seven" . #x277c)
("dingbat_negative_circled_digit_eight" . #x277d)
("dingbat_negative_circled_digit_nine" . #x277e)
("dingbat_negative_circled_number_ten" . #x277f)
("dingbat_circled_sans_serif_digit_one" . #x2780)
("dingbat_circled_sans_serif_digit_two" . #x2781)
("dingbat_circled_sans_serif_digit_three" . #x2782)
("dingbat_circled_sans_serif_digit_four" . #x2783)
("dingbat_circled_sans_serif_digit_five" . #x2784)
("dingbat_circled_sans_serif_digit_six" . #x2785)
("dingbat_circled_sans_serif_digit_seven" . #x2786)
("dingbat_circled_sans_serif_digit_eight" . #x2787)
("dingbat_circled_sans_serif_digit_nine" . #x2788)
("dingbat_circled_sans_serif_number_ten" . #x2789)
("dingbat_negative_circled_sans_serif_digit_one" . #x278a)
("dingbat_negative_circled_sans_serif_digit_two" . #x278b)
("dingbat_negative_circled_sans_serif_digit_three" . #x278c)
("dingbat_negative_circled_sans_serif_digit_four" . #x278d)
("dingbat_negative_circled_sans_serif_digit_five" . #x278e)
("dingbat_negative_circled_sans_serif_digit_six" . #x278f)
("dingbat_negative_circled_sans_serif_digit_seven" . #x2790)
("dingbat_negative_circled_sans_serif_digit_eight" . #x2791)
("dingbat_negative_circled_sans_serif_digit_nine" . #x2792)
("dingbat_negative_circled_sans_serif_number_ten" . #x2793)
("heavy_wide_headed_rightwards_arrow" . #x2794)
("heavy_south_east_arrow" . #x2798)
("heavy_rightwards_arrow" . #x2799)
("heavy_north_east_arrow" . #x279a)
("drafting_point_rightwards_arrow" . #x279b)
("heavy_round_tipped_rightwards_arrow" . #x279c)
("triangle_headed_rightwards_arrow" . #x279d)
("heavy_triangle_headed_rightwards_arrow" . #x279e)
("dashed_triangle_headed_rightwards_arrow" . #x279f)
("heavy_dashed_triangle_headed_rightwards_arrow" . #x27a0)
("black_rightwards_arrow" . #x27a1)
("three_d_top_lighted_rightwards_arrowhead" . #x27a2)
("three_d_bottom_lighted_rightwards_arrowhead" . #x27a3)
("black_rightwards_arrowhead" . #x27a4)
("heavy_black_curved_downwards_and_rightwards_arrow" . #x27a5)
("heavy_black_curved_upwards_and_rightwards_arrow" . #x27a6)
("squat_black_rightwards_arrow" . #x27a7)
("heavy_concave_pointed_black_rightwards_arrow" . #x27a8)
("right_shaded_white_rightwards_arrow" . #x27a9)
("left_shaded_white_rightwards_arrow" . #x27aa)
("back_tilted_shadowed_white_rightwards_arrow" . #x27ab)
("front_tilted_shadowed_white_rightwards_arrow" . #x27ac)
("heavy_lower_right_shadowed_white_rightwards_arrow" . #x27ad)
("heavy_upper_right_shadowed_white_rightwards_arrow" . #x27ae)
("notched_lower_right_shadowed_white_rightwards_arrow" . #x27af)
("notched_upper_right_shadowed_white_rightwards_arrow" . #x27b1)
("circled_heavy_white_rightwards_arrow" . #x27b2)
("white_feathered_rightwards_arrow" . #x27b3)
("black_feathered_south_east_arrow" . #x27b4)
("black_feathered_rightwards_arrow" . #x27b5)
("black_feathered_north_east_arrow" . #x27b6)
("heavy_black_feathered_south_east_arrow" . #x27b7)
("heavy_black_feathered_rightwards_arrow" . #x27b8)
("heavy_black_feathered_north_east_arrow" . #x27b9)
("teardrop_barbed_rightwards_arrow" . #x27ba)
("heavy_teardrop_shanked_rightwards_arrow" . #x27bb)
("wedge_tailed_rightwards_arrow" . #x27bc)
("heavy_wedge_tailed_rightwards_arrow" . #x27bd)
("open_outlined_rightwards_arrow" . #x27be)
("ideographic_space" . #x3000)
("ideographic_comma" . #x3001)
("ideographic_full_stop" . #x3002)
("ditto_mark" . #x3003)
("japanese_industrial_standard_symbol" . #x3004)
("ideographic_iteration_mark" . #x3005)
("ideographic_closing_mark" . #x3006)
("ideographic_number_zero" . #x3007)
("left_angle_bracket" . #x3008)
("right_angle_bracket" . #x3009)
("left_double_angle_bracket" . #x300a)
("right_double_angle_bracket" . #x300b)
("left_corner_bracket" . #x300c)
("right_corner_bracket" . #x300d)
("left_white_corner_bracket" . #x300e)
("right_white_corner_bracket" . #x300f)
("left_black_lenticular_bracket" . #x3010)
("right_black_lenticular_bracket" . #x3011)
("postal_mark" . #x3012)
("geta_mark" . #x3013)
("left_tortoise_shell_bracket" . #x3014)
("right_tortoise_shell_bracket" . #x3015)
("left_white_lenticular_bracket" . #x3016)
("right_white_lenticular_bracket" . #x3017)
("left_white_tortoise_shell_bracket" . #x3018)
("right_white_tortoise_shell_bracket" . #x3019)
("left_white_square_bracket" . #x301a)
("right_white_square_bracket" . #x301b)
("wave_dash" . #x301c)
("reversed_double_prime_quotation_mark" . #x301d)
("double_prime_quotation_mark" . #x301e)
("low_double_prime_quotation_mark" . #x301f)
("postal_mark_face" . #x3020)
("hangzhou_numeral_one" . #x3021)
("hangzhou_numeral_two" . #x3022)
("hangzhou_numeral_three" . #x3023)
("hangzhou_numeral_four" . #x3024)
("hangzhou_numeral_five" . #x3025)
("hangzhou_numeral_six" . #x3026)
("hangzhou_numeral_seven" . #x3027)
("hangzhou_numeral_eight" . #x3028)
("hangzhou_numeral_nine" . #x3029)
("wavy_dash" . #x3030)
("vertical_kana_repeat_mark" . #x3031)
("vertical_kana_repeat_with_voiced_sound_mark" . #x3032)
("vertical_kana_repeat_mark_upper_half" . #x3033)
("vertical_kana_repeat_with_voiced_sound_mark_upper_half" . #x3034)
("vertical_kana_repeat_mark_lower_half" . #x3035)
("circled_postal_mark" . #x3036)
("ideographic_telegraph_line_feed_separator_symbol" . #x3037)
("hiragana_letter_small_a" . #x3041)
("hiragana_letter_a" . #x3042)
("hiragana_letter_small_i" . #x3043)
("hiragana_letter_i" . #x3044)
("hiragana_letter_small_u" . #x3045)
("hiragana_letter_u" . #x3046)
("hiragana_letter_small_e" . #x3047)
("hiragana_letter_e" . #x3048)
("hiragana_letter_small_o" . #x3049)
("hiragana_letter_o" . #x304a)
("hiragana_letter_ka" . #x304b)
("hiragana_letter_ga" . #x304c)
("hiragana_letter_ki" . #x304d)
("hiragana_letter_gi" . #x304e)
("hiragana_letter_ku" . #x304f)
("hiragana_letter_gu" . #x3050)
("hiragana_letter_ke" . #x3051)
("hiragana_letter_ge" . #x3052)
("hiragana_letter_ko" . #x3053)
("hiragana_letter_go" . #x3054)
("hiragana_letter_sa" . #x3055)
("hiragana_letter_za" . #x3056)
("hiragana_letter_si" . #x3057)
("hiragana_letter_zi" . #x3058)
("hiragana_letter_su" . #x3059)
("hiragana_letter_zu" . #x305a)
("hiragana_letter_se" . #x305b)
("hiragana_letter_ze" . #x305c)
("hiragana_letter_so" . #x305d)
("hiragana_letter_zo" . #x305e)
("hiragana_letter_ta" . #x305f)
("hiragana_letter_da" . #x3060)
("hiragana_letter_ti" . #x3061)
("hiragana_letter_di" . #x3062)
("hiragana_letter_small_tu" . #x3063)
("hiragana_letter_tu" . #x3064)
("hiragana_letter_du" . #x3065)
("hiragana_letter_te" . #x3066)
("hiragana_letter_de" . #x3067)
("hiragana_letter_to" . #x3068)
("hiragana_letter_do" . #x3069)
("hiragana_letter_na" . #x306a)
("hiragana_letter_ni" . #x306b)
("hiragana_letter_nu" . #x306c)
("hiragana_letter_ne" . #x306d)
("hiragana_letter_no" . #x306e)
("hiragana_letter_ha" . #x306f)
("hiragana_letter_ba" . #x3070)
("hiragana_letter_pa" . #x3071)
("hiragana_letter_hi" . #x3072)
("hiragana_letter_bi" . #x3073)
("hiragana_letter_pi" . #x3074)
("hiragana_letter_hu" . #x3075)
("hiragana_letter_bu" . #x3076)
("hiragana_letter_pu" . #x3077)
("hiragana_letter_he" . #x3078)
("hiragana_letter_be" . #x3079)
("hiragana_letter_pe" . #x307a)
("hiragana_letter_ho" . #x307b)
("hiragana_letter_bo" . #x307c)
("hiragana_letter_po" . #x307d)
("hiragana_letter_ma" . #x307e)
("hiragana_letter_mi" . #x307f)
("hiragana_letter_mu" . #x3080)
("hiragana_letter_me" . #x3081)
("hiragana_letter_mo" . #x3082)
("hiragana_letter_small_ya" . #x3083)
("hiragana_letter_ya" . #x3084)
("hiragana_letter_small_yu" . #x3085)
("hiragana_letter_yu" . #x3086)
("hiragana_letter_small_yo" . #x3087)
("hiragana_letter_yo" . #x3088)
("hiragana_letter_ra" . #x3089)
("hiragana_letter_ri" . #x308a)
("hiragana_letter_ru" . #x308b)
("hiragana_letter_re" . #x308c)
("hiragana_letter_ro" . #x308d)
("hiragana_letter_small_wa" . #x308e)
("hiragana_letter_wa" . #x308f)
("hiragana_letter_wi" . #x3090)
("hiragana_letter_we" . #x3091)
("hiragana_letter_wo" . #x3092)
("hiragana_letter_n" . #x3093)
("hiragana_letter_vu" . #x3094)
("katakana_hiragana_voiced_sound_mark" . #x309b)
("katakana_hiragana_semi_voiced_sound_mark" . #x309c)
("hiragana_iteration_mark" . #x309d)
("hiragana_voiced_iteration_mark" . #x309e)
("katakana_letter_small_a" . #x30a1)
("katakana_letter_a" . #x30a2)
("katakana_letter_small_i" . #x30a3)
("katakana_letter_i" . #x30a4)
("katakana_letter_small_u" . #x30a5)
("katakana_letter_u" . #x30a6)
("katakana_letter_small_e" . #x30a7)
("katakana_letter_e" . #x30a8)
("katakana_letter_small_o" . #x30a9)
("katakana_letter_o" . #x30aa)
("katakana_letter_ka" . #x30ab)
("katakana_letter_ga" . #x30ac)
("katakana_letter_ki" . #x30ad)
("katakana_letter_gi" . #x30ae)
("katakana_letter_ku" . #x30af)
("katakana_letter_gu" . #x30b0)
("katakana_letter_ke" . #x30b1)
("katakana_letter_ge" . #x30b2)
("katakana_letter_ko" . #x30b3)
("katakana_letter_go" . #x30b4)
("katakana_letter_sa" . #x30b5)
("katakana_letter_za" . #x30b6)
("katakana_letter_si" . #x30b7)
("katakana_letter_zi" . #x30b8)
("katakana_letter_su" . #x30b9)
("katakana_letter_zu" . #x30ba)
("katakana_letter_se" . #x30bb)
("katakana_letter_ze" . #x30bc)
("katakana_letter_so" . #x30bd)
("katakana_letter_zo" . #x30be)
("katakana_letter_ta" . #x30bf)
("katakana_letter_da" . #x30c0)
("katakana_letter_ti" . #x30c1)
("katakana_letter_di" . #x30c2)
("katakana_letter_small_tu" . #x30c3)
("katakana_letter_tu" . #x30c4)
("katakana_letter_du" . #x30c5)
("katakana_letter_te" . #x30c6)
("katakana_letter_de" . #x30c7)
("katakana_letter_to" . #x30c8)
("katakana_letter_do" . #x30c9)
("katakana_letter_na" . #x30ca)
("katakana_letter_ni" . #x30cb)
("katakana_letter_nu" . #x30cc)
("katakana_letter_ne" . #x30cd)
("katakana_letter_no" . #x30ce)
("katakana_letter_ha" . #x30cf)
("katakana_letter_ba" . #x30d0)
("katakana_letter_pa" . #x30d1)
("katakana_letter_hi" . #x30d2)
("katakana_letter_bi" . #x30d3)
("katakana_letter_pi" . #x30d4)
("katakana_letter_hu" . #x30d5)
("katakana_letter_bu" . #x30d6)
("katakana_letter_pu" . #x30d7)
("katakana_letter_he" . #x30d8)
("katakana_letter_be" . #x30d9)
("katakana_letter_pe" . #x30da)
("katakana_letter_ho" . #x30db)
("katakana_letter_bo" . #x30dc)
("katakana_letter_po" . #x30dd)
("katakana_letter_ma" . #x30de)
("katakana_letter_mi" . #x30df)
("katakana_letter_mu" . #x30e0)
("katakana_letter_me" . #x30e1)
("katakana_letter_mo" . #x30e2)
("katakana_letter_small_ya" . #x30e3)
("katakana_letter_ya" . #x30e4)
("katakana_letter_small_yu" . #x30e5)
("katakana_letter_yu" . #x30e6)
("katakana_letter_small_yo" . #x30e7)
("katakana_letter_yo" . #x30e8)
("katakana_letter_ra" . #x30e9)
("katakana_letter_ri" . #x30ea)
("katakana_letter_ru" . #x30eb)
("katakana_letter_re" . #x30ec)
("katakana_letter_ro" . #x30ed)
("katakana_letter_small_wa" . #x30ee)
("katakana_letter_wa" . #x30ef)
("katakana_letter_wi" . #x30f0)
("katakana_letter_we" . #x30f1)
("katakana_letter_wo" . #x30f2)
("katakana_letter_n" . #x30f3)
("katakana_letter_vu" . #x30f4)
("katakana_letter_small_ka" . #x30f5)
("katakana_letter_small_ke" . #x30f6)
("katakana_letter_va" . #x30f7)
("katakana_letter_vi" . #x30f8)
("katakana_letter_ve" . #x30f9)
("katakana_letter_vo" . #x30fa)
("katakana_middle_dot" . #x30fb)
("katakana_hiragana_prolonged_sound_mark" . #x30fc)
("katakana_iteration_mark" . #x30fd)
("katakana_voiced_iteration_mark" . #x30fe)
("bopomofo_letter_b" . #x3105)
("bopomofo_letter_p" . #x3106)
("bopomofo_letter_m" . #x3107)
("bopomofo_letter_f" . #x3108)
("bopomofo_letter_d" . #x3109)
("bopomofo_letter_t" . #x310a)
("bopomofo_letter_n" . #x310b)
("bopomofo_letter_l" . #x310c)
("bopomofo_letter_g" . #x310d)
("bopomofo_letter_k" . #x310e)
("bopomofo_letter_h" . #x310f)
("bopomofo_letter_j" . #x3110)
("bopomofo_letter_q" . #x3111)
("bopomofo_letter_x" . #x3112)
("bopomofo_letter_zh" . #x3113)
("bopomofo_letter_ch" . #x3114)
("bopomofo_letter_sh" . #x3115)
("bopomofo_letter_r" . #x3116)
("bopomofo_letter_z" . #x3117)
("bopomofo_letter_c" . #x3118)
("bopomofo_letter_s" . #x3119)
("bopomofo_letter_a" . #x311a)
("bopomofo_letter_o" . #x311b)
("bopomofo_letter_e" . #x311c)
("bopomofo_letter_eh" . #x311d)
("bopomofo_letter_ai" . #x311e)
("bopomofo_letter_ei" . #x311f)
("bopomofo_letter_au" . #x3120)
("bopomofo_letter_ou" . #x3121)
("bopomofo_letter_an" . #x3122)
("bopomofo_letter_en" . #x3123)
("bopomofo_letter_ang" . #x3124)
("bopomofo_letter_eng" . #x3125)
("bopomofo_letter_er" . #x3126)
("bopomofo_letter_i" . #x3127)
("bopomofo_letter_u" . #x3128)
("bopomofo_letter_iu" . #x3129)
("hangul_letter_kiyeok" . #x3131)
("hangul_letter_ssangkiyeok" . #x3132)
("hangul_letter_kiyeok_sios" . #x3133)
("hangul_letter_nieun" . #x3134)
("hangul_letter_nieun_cieuc" . #x3135)
("hangul_letter_nieun_hieuh" . #x3136)
("hangul_letter_tikeut" . #x3137)
("hangul_letter_ssangtikeut" . #x3138)
("hangul_letter_rieul" . #x3139)
("hangul_letter_rieul_kiyeok" . #x313a)
("hangul_letter_rieul_mieum" . #x313b)
("hangul_letter_rieul_pieup" . #x313c)
("hangul_letter_rieul_sios" . #x313d)
("hangul_letter_rieul_thieuth" . #x313e)
("hangul_letter_rieul_phieuph" . #x313f)
("hangul_letter_rieul_hieuh" . #x3140)
("hangul_letter_mieum" . #x3141)
("hangul_letter_pieup" . #x3142)
("hangul_letter_ssangpieup" . #x3143)
("hangul_letter_pieup_sios" . #x3144)
("hangul_letter_sios" . #x3145)
("hangul_letter_ssangsios" . #x3146)
("hangul_letter_ieung" . #x3147)
("hangul_letter_cieuc" . #x3148)
("hangul_letter_ssangcieuc" . #x3149)
("hangul_letter_chieuch" . #x314a)
("hangul_letter_khieukh" . #x314b)
("hangul_letter_thieuth" . #x314c)
("hangul_letter_phieuph" . #x314d)
("hangul_letter_hieuh" . #x314e)
("hangul_letter_a" . #x314f)
("hangul_letter_ae" . #x3150)
("hangul_letter_ya" . #x3151)
("hangul_letter_yae" . #x3152)
("hangul_letter_eo" . #x3153)
("hangul_letter_e" . #x3154)
("hangul_letter_yeo" . #x3155)
("hangul_letter_ye" . #x3156)
("hangul_letter_o" . #x3157)
("hangul_letter_wa" . #x3158)
("hangul_letter_wae" . #x3159)
("hangul_letter_oe" . #x315a)
("hangul_letter_yo" . #x315b)
("hangul_letter_u" . #x315c)
("hangul_letter_weo" . #x315d)
("hangul_letter_we" . #x315e)
("hangul_letter_wi" . #x315f)
("hangul_letter_yu" . #x3160)
("hangul_letter_eu" . #x3161)
("hangul_letter_yi" . #x3162)
("hangul_letter_i" . #x3163)
("hangul_filler" . #x3164)
("hangul_letter_ssangnieun" . #x3165)
("hangul_letter_nieun_tikeut" . #x3166)
("hangul_letter_nieun_sios" . #x3167)
("hangul_letter_nieun_pansios" . #x3168)
("hangul_letter_rieul_kiyeok_sios" . #x3169)
("hangul_letter_rieul_tikeut" . #x316a)
("hangul_letter_rieul_pieup_sios" . #x316b)
("hangul_letter_rieul_pansios" . #x316c)
("hangul_letter_rieul_yeorinhieuh" . #x316d)
("hangul_letter_mieum_pieup" . #x316e)
("hangul_letter_mieum_sios" . #x316f)
("hangul_letter_mieum_pansios" . #x3170)
("hangul_letter_kapyeounmieum" . #x3171)
("hangul_letter_pieup_kiyeok" . #x3172)
("hangul_letter_pieup_tikeut" . #x3173)
("hangul_letter_pieup_sios_kiyeok" . #x3174)
("hangul_letter_pieup_sios_tikeut" . #x3175)
("hangul_letter_pieup_cieuc" . #x3176)
("hangul_letter_pieup_thieuth" . #x3177)
("hangul_letter_kapyeounpieup" . #x3178)
("hangul_letter_kapyeounssangpieup" . #x3179)
("hangul_letter_sios_kiyeok" . #x317a)
("hangul_letter_sios_nieun" . #x317b)
("hangul_letter_sios_tikeut" . #x317c)
("hangul_letter_sios_pieup" . #x317d)
("hangul_letter_sios_cieuc" . #x317e)
("hangul_letter_pansios" . #x317f)
("hangul_letter_ssangieung" . #x3180)
("hangul_letter_yesieung" . #x3181)
("hangul_letter_yesieung_sios" . #x3182)
("hangul_letter_yesieung_pansios" . #x3183)
("hangul_letter_kapyeounphieuph" . #x3184)
("hangul_letter_ssanghieuh" . #x3185)
("hangul_letter_yeorinhieuh" . #x3186)
("hangul_letter_yo_ya" . #x3187)
("hangul_letter_yo_yae" . #x3188)
("hangul_letter_yo_i" . #x3189)
("hangul_letter_yu_yeo" . #x318a)
("hangul_letter_yu_ye" . #x318b)
("hangul_letter_yu_i" . #x318c)
("hangul_letter_araea" . #x318d)
("hangul_letter_araeae" . #x318e)
("parenthesized_hangul_kiyeok" . #x3200)
("parenthesized_hangul_nieun" . #x3201)
("parenthesized_hangul_tikeut" . #x3202)
("parenthesized_hangul_rieul" . #x3203)
("parenthesized_hangul_mieum" . #x3204)
("parenthesized_hangul_pieup" . #x3205)
("parenthesized_hangul_sios" . #x3206)
("parenthesized_hangul_ieung" . #x3207)
("parenthesized_hangul_cieuc" . #x3208)
("parenthesized_hangul_chieuch" . #x3209)
("parenthesized_hangul_khieukh" . #x320a)
("parenthesized_hangul_thieuth" . #x320b)
("parenthesized_hangul_phieuph" . #x320c)
("parenthesized_hangul_hieuh" . #x320d)
("parenthesized_hangul_kiyeok_a" . #x320e)
("parenthesized_hangul_nieun_a" . #x320f)
("parenthesized_hangul_tikeut_a" . #x3210)
("parenthesized_hangul_rieul_a" . #x3211)
("parenthesized_hangul_mieum_a" . #x3212)
("parenthesized_hangul_pieup_a" . #x3213)
("parenthesized_hangul_sios_a" . #x3214)
("parenthesized_hangul_ieung_a" . #x3215)
("parenthesized_hangul_cieuc_a" . #x3216)
("parenthesized_hangul_chieuch_a" . #x3217)
("parenthesized_hangul_khieukh_a" . #x3218)
("parenthesized_hangul_thieuth_a" . #x3219)
("parenthesized_hangul_phieuph_a" . #x321a)
("parenthesized_hangul_hieuh_a" . #x321b)
("parenthesized_hangul_cieuc_u" . #x321c)
("parenthesized_ideograph_one" . #x3220)
("parenthesized_ideograph_two" . #x3221)
("parenthesized_ideograph_three" . #x3222)
("parenthesized_ideograph_four" . #x3223)
("parenthesized_ideograph_five" . #x3224)
("parenthesized_ideograph_six" . #x3225)
("parenthesized_ideograph_seven" . #x3226)
("parenthesized_ideograph_eight" . #x3227)
("parenthesized_ideograph_nine" . #x3228)
("parenthesized_ideograph_ten" . #x3229)
("parenthesized_ideograph_moon" . #x322a)
("parenthesized_ideograph_fire" . #x322b)
("parenthesized_ideograph_water" . #x322c)
("parenthesized_ideograph_wood" . #x322d)
("parenthesized_ideograph_metal" . #x322e)
("parenthesized_ideograph_earth" . #x322f)
("parenthesized_ideograph_sun" . #x3230)
("parenthesized_ideograph_stock" . #x3231)
("parenthesized_ideograph_have" . #x3232)
("parenthesized_ideograph_society" . #x3233)
("parenthesized_ideograph_name" . #x3234)
("parenthesized_ideograph_special" . #x3235)
("parenthesized_ideograph_financial" . #x3236)
("parenthesized_ideograph_congratulation" . #x3237)
("parenthesized_ideograph_labor" . #x3238)
("parenthesized_ideograph_represent" . #x3239)
("parenthesized_ideograph_call" . #x323a)
("parenthesized_ideograph_study" . #x323b)
("parenthesized_ideograph_supervise" . #x323c)
("parenthesized_ideograph_enterprise" . #x323d)
("parenthesized_ideograph_resource" . #x323e)
("parenthesized_ideograph_alliance" . #x323f)
("parenthesized_ideograph_festival" . #x3240)
("parenthesized_ideograph_rest" . #x3241)
("parenthesized_ideograph_self" . #x3242)
("parenthesized_ideograph_reach" . #x3243)
("circled_hangul_kiyeok" . #x3260)
("circled_hangul_nieun" . #x3261)
("circled_hangul_tikeut" . #x3262)
("circled_hangul_rieul" . #x3263)
("circled_hangul_mieum" . #x3264)
("circled_hangul_pieup" . #x3265)
("circled_hangul_sios" . #x3266)
("circled_hangul_ieung" . #x3267)
("circled_hangul_cieuc" . #x3268)
("circled_hangul_chieuch" . #x3269)
("circled_hangul_khieukh" . #x326a)
("circled_hangul_thieuth" . #x326b)
("circled_hangul_phieuph" . #x326c)
("circled_hangul_hieuh" . #x326d)
("circled_hangul_kiyeok_a" . #x326e)
("circled_hangul_nieun_a" . #x326f)
("circled_hangul_tikeut_a" . #x3270)
("circled_hangul_rieul_a" . #x3271)
("circled_hangul_mieum_a" . #x3272)
("circled_hangul_pieup_a" . #x3273)
("circled_hangul_sios_a" . #x3274)
("circled_hangul_ieung_a" . #x3275)
("circled_hangul_cieuc_a" . #x3276)
("circled_hangul_chieuch_a" . #x3277)
("circled_hangul_khieukh_a" . #x3278)
("circled_hangul_thieuth_a" . #x3279)
("circled_hangul_phieuph_a" . #x327a)
("circled_hangul_hieuh_a" . #x327b)
("korean_standard_symbol" . #x327f)
("circled_ideograph_one" . #x3280)
("circled_ideograph_two" . #x3281)
("circled_ideograph_three" . #x3282)
("circled_ideograph_four" . #x3283)
("circled_ideograph_five" . #x3284)
("circled_ideograph_six" . #x3285)
("circled_ideograph_seven" . #x3286)
("circled_ideograph_eight" . #x3287)
("circled_ideograph_nine" . #x3288)
("circled_ideograph_ten" . #x3289)
("circled_ideograph_moon" . #x328a)
("circled_ideograph_fire" . #x328b)
("circled_ideograph_water" . #x328c)
("circled_ideograph_wood" . #x328d)
("circled_ideograph_metal" . #x328e)
("circled_ideograph_earth" . #x328f)
("circled_ideograph_sun" . #x3290)
("circled_ideograph_stock" . #x3291)
("circled_ideograph_have" . #x3292)
("circled_ideograph_society" . #x3293)
("circled_ideograph_name" . #x3294)
("circled_ideograph_special" . #x3295)
("circled_ideograph_financial" . #x3296)
("circled_ideograph_congratulation" . #x3297)
("circled_ideograph_labor" . #x3298)
("circled_ideograph_secret" . #x3299)
("circled_ideograph_male" . #x329a)
("circled_ideograph_female" . #x329b)
("circled_ideograph_suitable" . #x329c)
("circled_ideograph_excellent" . #x329d)
("circled_ideograph_print" . #x329e)
("circled_ideograph_attention" . #x329f)
("circled_ideograph_item" . #x32a0)
("circled_ideograph_rest" . #x32a1)
("circled_ideograph_copy" . #x32a2)
("circled_ideograph_correct" . #x32a3)
("circled_ideograph_high" . #x32a4)
("circled_ideograph_centre" . #x32a5)
("circled_ideograph_low" . #x32a6)
("circled_ideograph_left" . #x32a7)
("circled_ideograph_right" . #x32a8)
("circled_ideograph_medicine" . #x32a9)
("circled_ideograph_religion" . #x32aa)
("circled_ideograph_study" . #x32ab)
("circled_ideograph_supervise" . #x32ac)
("circled_ideograph_enterprise" . #x32ad)
("circled_ideograph_resource" . #x32ae)
("circled_ideograph_alliance" . #x32af)
("circled_ideograph_night" . #x32b0)
("ideographic_telegraph_symbol_for_january" . #x32c0)
("ideographic_telegraph_symbol_for_february" . #x32c1)
("ideographic_telegraph_symbol_for_march" . #x32c2)
("ideographic_telegraph_symbol_for_april" . #x32c3)
("ideographic_telegraph_symbol_for_may" . #x32c4)
("ideographic_telegraph_symbol_for_june" . #x32c5)
("ideographic_telegraph_symbol_for_july" . #x32c6)
("ideographic_telegraph_symbol_for_august" . #x32c7)
("ideographic_telegraph_symbol_for_september" . #x32c8)
("ideographic_telegraph_symbol_for_october" . #x32c9)
("ideographic_telegraph_symbol_for_november" . #x32ca)
("ideographic_telegraph_symbol_for_december" . #x32cb)
("circled_katakana_a" . #x32d0)
("circled_katakana_i" . #x32d1)
("circled_katakana_u" . #x32d2)
("circled_katakana_e" . #x32d3)
("circled_katakana_o" . #x32d4)
("circled_katakana_ka" . #x32d5)
("circled_katakana_ki" . #x32d6)
("circled_katakana_ku" . #x32d7)
("circled_katakana_ke" . #x32d8)
("circled_katakana_ko" . #x32d9)
("circled_katakana_sa" . #x32da)
("circled_katakana_si" . #x32db)
("circled_katakana_su" . #x32dc)
("circled_katakana_se" . #x32dd)
("circled_katakana_so" . #x32de)
("circled_katakana_ta" . #x32df)
("circled_katakana_ti" . #x32e0)
("circled_katakana_tu" . #x32e1)
("circled_katakana_te" . #x32e2)
("circled_katakana_to" . #x32e3)
("circled_katakana_na" . #x32e4)
("circled_katakana_ni" . #x32e5)
("circled_katakana_nu" . #x32e6)
("circled_katakana_ne" . #x32e7)
("circled_katakana_no" . #x32e8)
("circled_katakana_ha" . #x32e9)
("circled_katakana_hi" . #x32ea)
("circled_katakana_hu" . #x32eb)
("circled_katakana_he" . #x32ec)
("circled_katakana_ho" . #x32ed)
("circled_katakana_ma" . #x32ee)
("circled_katakana_mi" . #x32ef)
("circled_katakana_mu" . #x32f0)
("circled_katakana_me" . #x32f1)
("circled_katakana_mo" . #x32f2)
("circled_katakana_ya" . #x32f3)
("circled_katakana_yu" . #x32f4)
("circled_katakana_yo" . #x32f5)
("circled_katakana_ra" . #x32f6)
("circled_katakana_ri" . #x32f7)
("circled_katakana_ru" . #x32f8)
("circled_katakana_re" . #x32f9)
("circled_katakana_ro" . #x32fa)
("circled_katakana_wa" . #x32fb)
("circled_katakana_wi" . #x32fc)
("circled_katakana_we" . #x32fd)
("circled_katakana_wo" . #x32fe)
("square_apaato" . #x3300)
("square_aruhua" . #x3301)
("square_anpea" . #x3302)
("square_aaru" . #x3303)
("square_iningu" . #x3304)
("square_inti" . #x3305)
("square_uon" . #x3306)
("square_esukuudo" . #x3307)
("square_eekaa" . #x3308)
("square_onsu" . #x3309)
("square_oomu" . #x330a)
("square_kairi" . #x330b)
("square_karatto" . #x330c)
("square_karorii" . #x330d)
("square_garon" . #x330e)
("square_ganma" . #x330f)
("square_giga" . #x3310)
("square_ginii" . #x3311)
("square_kyurii" . #x3312)
("square_girudaa" . #x3313)
("square_kiro" . #x3314)
("square_kiroguramu" . #x3315)
("square_kiromeetoru" . #x3316)
("square_kirowatto" . #x3317)
("square_guramu" . #x3318)
("square_guramuton" . #x3319)
("square_kuruzeiro" . #x331a)
("square_kuroone" . #x331b)
("square_keesu" . #x331c)
("square_koruna" . #x331d)
("square_koopo" . #x331e)
("square_saikuru" . #x331f)
("square_santiimu" . #x3320)
("square_siringu" . #x3321)
("square_senti" . #x3322)
("square_sento" . #x3323)
("square_daasu" . #x3324)
("square_desi" . #x3325)
("square_doru" . #x3326)
("square_ton" . #x3327)
("square_nano" . #x3328)
("square_notto" . #x3329)
("square_haitu" . #x332a)
("square_paasento" . #x332b)
("square_paatu" . #x332c)
("square_baareru" . #x332d)
("square_piasutoru" . #x332e)
("square_pikuru" . #x332f)
("square_piko" . #x3330)
("square_biru" . #x3331)
("square_huaraddo" . #x3332)
("square_huiito" . #x3333)
("square_bussyeru" . #x3334)
("square_huran" . #x3335)
("square_hekutaaru" . #x3336)
("square_peso" . #x3337)
("square_penihi" . #x3338)
("square_herutu" . #x3339)
("square_pensu" . #x333a)
("square_peezi" . #x333b)
("square_beeta" . #x333c)
("square_pointo" . #x333d)
("square_boruto" . #x333e)
("square_hon" . #x333f)
("square_pondo" . #x3340)
("square_hooru" . #x3341)
("square_hoon" . #x3342)
("square_maikuro" . #x3343)
("square_mairu" . #x3344)
("square_mahha" . #x3345)
("square_maruku" . #x3346)
("square_mansyon" . #x3347)
("square_mikuron" . #x3348)
("square_miri" . #x3349)
("square_miribaaru" . #x334a)
("square_mega" . #x334b)
("square_megaton" . #x334c)
("square_meetoru" . #x334d)
("square_yaado" . #x334e)
("square_yaaru" . #x334f)
("square_yuan" . #x3350)
("square_rittoru" . #x3351)
("square_rira" . #x3352)
("square_rupii" . #x3353)
("square_ruuburu" . #x3354)
("square_remu" . #x3355)
("square_rentogen" . #x3356)
("square_watto" . #x3357)
("ideographic_telegraph_symbol_for_hour_zero" . #x3358)
("ideographic_telegraph_symbol_for_hour_one" . #x3359)
("ideographic_telegraph_symbol_for_hour_two" . #x335a)
("ideographic_telegraph_symbol_for_hour_three" . #x335b)
("ideographic_telegraph_symbol_for_hour_four" . #x335c)
("ideographic_telegraph_symbol_for_hour_five" . #x335d)
("ideographic_telegraph_symbol_for_hour_six" . #x335e)
("ideographic_telegraph_symbol_for_hour_seven" . #x335f)
("ideographic_telegraph_symbol_for_hour_eight" . #x3360)
("ideographic_telegraph_symbol_for_hour_nine" . #x3361)
("ideographic_telegraph_symbol_for_hour_ten" . #x3362)
("ideographic_telegraph_symbol_for_hour_eleven" . #x3363)
("ideographic_telegraph_symbol_for_hour_twelve" . #x3364)
("ideographic_telegraph_symbol_for_hour_thirteen" . #x3365)
("ideographic_telegraph_symbol_for_hour_fourteen" . #x3366)
("ideographic_telegraph_symbol_for_hour_fifteen" . #x3367)
("ideographic_telegraph_symbol_for_hour_sixteen" . #x3368)
("ideographic_telegraph_symbol_for_hour_seventeen" . #x3369)
("ideographic_telegraph_symbol_for_hour_eighteen" . #x336a)
("ideographic_telegraph_symbol_for_hour_nineteen" . #x336b)
("ideographic_telegraph_symbol_for_hour_twenty" . #x336c)
("ideographic_telegraph_symbol_for_hour_twenty_one" . #x336d)
("ideographic_telegraph_symbol_for_hour_twenty_two" . #x336e)
("ideographic_telegraph_symbol_for_hour_twenty_three" . #x336f)
("ideographic_telegraph_symbol_for_hour_twenty_four" . #x3370)
("square_hpa" . #x3371)
("square_da" . #x3372)
("square_au" . #x3373)
("square_bar" . #x3374)
("square_ov" . #x3375)
("square_pc" . #x3376)
("square_era_name_heisei" . #x337b)
("square_era_name_syouwa" . #x337c)
("square_era_name_taisyou" . #x337d)
("square_era_name_meizi" . #x337e)
("square_corporation" . #x337f)
("square_pa_amps" . #x3380)
("square_na" . #x3381)
("square_mu_a" . #x3382)
("square_ma" . #x3383)
("square_ka" . #x3384)
("square_kb" . #x3385)
("square_mb" . #x3386)
("square_gb" . #x3387)
("square_cal" . #x3388)
("square_kcal" . #x3389)
("square_pf" . #x338a)
("square_nf" . #x338b)
("square_mu_f" . #x338c)
("square_mu_g" . #x338d)
("square_mg" . #x338e)
("square_kg" . #x338f)
("square_hz" . #x3390)
("square_khz" . #x3391)
("square_mhz" . #x3392)
("square_ghz" . #x3393)
("square_thz" . #x3394)
("square_mu_l" . #x3395)
("square_ml" . #x3396)
("square_dl" . #x3397)
("square_kl" . #x3398)
("square_fm" . #x3399)
("square_nm" . #x339a)
("square_mu_m" . #x339b)
("square_mm" . #x339c)
("square_cm" . #x339d)
("square_km" . #x339e)
("square_mm_squared" . #x339f)
("square_cm_squared" . #x33a0)
("square_m_squared" . #x33a1)
("square_km_squared" . #x33a2)
("square_mm_cubed" . #x33a3)
("square_cm_cubed" . #x33a4)
("square_m_cubed" . #x33a5)
("square_km_cubed" . #x33a6)
("square_m_over_s" . #x33a7)
("square_m_over_s_squared" . #x33a8)
("square_pa" . #x33a9)
("square_kpa" . #x33aa)
("square_mpa" . #x33ab)
("square_gpa" . #x33ac)
("square_rad" . #x33ad)
("square_rad_over_s" . #x33ae)
("square_rad_over_s_squared" . #x33af)
("square_ps" . #x33b0)
("square_ns" . #x33b1)
("square_mu_s" . #x33b2)
("square_ms" . #x33b3)
("square_pv" . #x33b4)
("square_nv" . #x33b5)
("square_mu_v" . #x33b6)
("square_mv" . #x33b7)
("square_kv" . #x33b8)
("square_mv_mega" . #x33b9)
("square_pw" . #x33ba)
("square_nw" . #x33bb)
("square_mu_w" . #x33bc)
("square_mw" . #x33bd)
("square_kw" . #x33be)
("square_mw_mega" . #x33bf)
("square_k_ohm" . #x33c0)
("square_m_ohm" . #x33c1)
("square_am" . #x33c2)
("square_bq" . #x33c3)
("square_cc" . #x33c4)
("square_cd" . #x33c5)
("square_c_over_kg" . #x33c6)
("square_co" . #x33c7)
("square_db" . #x33c8)
("square_gy" . #x33c9)
("square_ha" . #x33ca)
("square_hp" . #x33cb)
("square_in" . #x33cc)
("square_kk" . #x33cd)
("square_km_capital" . #x33ce)
("square_kt" . #x33cf)
("square_lm" . #x33d0)
("square_ln" . #x33d1)
("square_log" . #x33d2)
("square_lx" . #x33d3)
("square_mb_small" . #x33d4)
("square_mil" . #x33d5)
("square_mol" . #x33d6)
("square_ph" . #x33d7)
("square_pm" . #x33d8)
("square_ppm" . #x33d9)
("square_pr" . #x33da)
("square_sr" . #x33db)
("square_sv" . #x33dc)
("square_wb" . #x33dd)
("ideographic_telegraph_symbol_for_day_one" . #x33e0)
("ideographic_telegraph_symbol_for_day_two" . #x33e1)
("ideographic_telegraph_symbol_for_day_three" . #x33e2)
("ideographic_telegraph_symbol_for_day_four" . #x33e3)
("ideographic_telegraph_symbol_for_day_five" . #x33e4)
("ideographic_telegraph_symbol_for_day_six" . #x33e5)
("ideographic_telegraph_symbol_for_day_seven" . #x33e6)
("ideographic_telegraph_symbol_for_day_eight" . #x33e7)
("ideographic_telegraph_symbol_for_day_nine" . #x33e8)
("ideographic_telegraph_symbol_for_day_ten" . #x33e9)
("ideographic_telegraph_symbol_for_day_eleven" . #x33ea)
("ideographic_telegraph_symbol_for_day_twelve" . #x33eb)
("ideographic_telegraph_symbol_for_day_thirteen" . #x33ec)
("ideographic_telegraph_symbol_for_day_fourteen" . #x33ed)
("ideographic_telegraph_symbol_for_day_fifteen" . #x33ee)
("ideographic_telegraph_symbol_for_day_sixteen" . #x33ef)
("ideographic_telegraph_symbol_for_day_seventeen" . #x33f0)
("ideographic_telegraph_symbol_for_day_eighteen" . #x33f1)
("ideographic_telegraph_symbol_for_day_nineteen" . #x33f2)
("ideographic_telegraph_symbol_for_day_twenty" . #x33f3)
("ideographic_telegraph_symbol_for_day_twenty_one" . #x33f4)
("ideographic_telegraph_symbol_for_day_twenty_two" . #x33f5)
("ideographic_telegraph_symbol_for_day_twenty_three" . #x33f6)
("ideographic_telegraph_symbol_for_day_twenty_four" . #x33f7)
("ideographic_telegraph_symbol_for_day_twenty_five" . #x33f8)
("ideographic_telegraph_symbol_for_day_twenty_six" . #x33f9)
("ideographic_telegraph_symbol_for_day_twenty_seven" . #x33fa)
("ideographic_telegraph_symbol_for_day_twenty_eight" . #x33fb)
("ideographic_telegraph_symbol_for_day_twenty_nine" . #x33fc)
("ideographic_telegraph_symbol_for_day_thirty" . #x33fd)
("ideographic_telegraph_symbol_for_day_thirty_one" . #x33fe)
("latin_small_ligature_fi" . #xfb01)
("latin_small_ligature_fl" . #xfb02)
("presentation_form_for_vertical_two_dot_leader" . #xfe30)
("presentation_form_for_vertical_em_dash" . #xfe31)
("presentation_form_for_vertical_low_line" . #xfe33)
("presentation_form_for_vertical_wavy_low_line" . #xfe34)
("presentation_form_for_vertical_left_parenthesis" . #xfe35)
("presentation_form_for_vertical_right_parenthesis" . #xfe36)
("presentation_form_for_vertical_left_curly_bracket" . #xfe37)
("presentation_form_for_vertical_right_curly_bracket" . #xfe38)
("presentation_form_for_vertical_left_tortoise_shell_bracket" . #xfe39)
("presentation_form_for_vertical_right_tortoise_shell_bracket" . #xfe3a)
("presentation_form_for_vertical_left_black_lenticular_bracket" . #xfe3b)
("presentation_form_for_vertical_right_black_lenticular_bracket" . #xfe3c)
("presentation_form_for_vertical_left_double_angle_bracket" . #xfe3d)
("presentation_form_for_vertical_right_double_angle_bracket" . #xfe3e)
("presentation_form_for_vertical_left_angle_bracket" . #xfe3f)
("presentation_form_for_vertical_right_angle_bracket" . #xfe40)
("presentation_form_for_vertical_left_corner_bracket" . #xfe41)
("presentation_form_for_vertical_right_corner_bracket" . #xfe42)
("presentation_form_for_vertical_left_white_corner_bracket" . #xfe43)
("presentation_form_for_vertical_right_white_corner_bracket" . #xfe44)
("dashed_overline" . #xfe49)
("centreline_overline" . #xfe4a)
("wavy_overline" . #xfe4b)
("double_wavy_overline" . #xfe4c)
("dashed_low_line" . #xfe4d)
("centreline_low_line" . #xfe4e)
("wavy_low_line" . #xfe4f)
("small_comma" . #xfe50)
("small_full_stop" . #xfe52)
("small_semicolon" . #xfe54)
("small_colon" . #xfe55)
("small_question_mark" . #xfe56)
("small_exclamation_mark" . #xfe57)
("small_left_parenthesis" . #xfe59)
("small_right_parenthesis" . #xfe5a)
("small_left_curly_bracket" . #xfe5b)
("small_right_curly_bracket" . #xfe5c)
("small_left_tortoise_shell_bracket" . #xfe5d)
("small_right_tortoise_shell_bracket" . #xfe5e)
("small_number_sign" . #xfe5f)
("small_ampersand" . #xfe60)
("small_asterisk" . #xfe61)
("small_plus_sign" . #xfe62)
("small_hyphen_minus" . #xfe63)
("small_less_than_sign" . #xfe64)
("small_greater_than_sign" . #xfe65)
("small_equals_sign" . #xfe66)
("small_dollar_sign" . #xfe69)
("small_percent_sign" . #xfe6a)
("small_commercial_at" . #xfe6b)
("fullwidth_exclamation_mark" . #xff01)
("fullwidth_quotation_mark" . #xff02)
("fullwidth_number_sign" . #xff03)
("fullwidth_dollar_sign" . #xff04)
("fullwidth_percent_sign" . #xff05)
("fullwidth_ampersand" . #xff06)
("fullwidth_apostrophe" . #xff07)
("fullwidth_left_parenthesis" . #xff08)
("fullwidth_right_parenthesis" . #xff09)
("fullwidth_asterisk" . #xff0a)
("fullwidth_plus_sign" . #xff0b)
("fullwidth_comma" . #xff0c)
("fullwidth_hyphen_minus" . #xff0d)
("fullwidth_full_stop" . #xff0e)
("fullwidth_solidus" . #xff0f)
("fullwidth_digit_zero" . #xff10)
("fullwidth_digit_one" . #xff11)
("fullwidth_digit_two" . #xff12)
("fullwidth_digit_three" . #xff13)
("fullwidth_digit_four" . #xff14)
("fullwidth_digit_five" . #xff15)
("fullwidth_digit_six" . #xff16)
("fullwidth_digit_seven" . #xff17)
("fullwidth_digit_eight" . #xff18)
("fullwidth_digit_nine" . #xff19)
("fullwidth_colon" . #xff1a)
("fullwidth_semicolon" . #xff1b)
("fullwidth_less_than_sign" . #xff1c)
("fullwidth_equals_sign" . #xff1d)
("fullwidth_greater_than_sign" . #xff1e)
("fullwidth_question_mark" . #xff1f)
("fullwidth_commercial_at" . #xff20)
("fullwidth_latin_capital_letter_a" . #xff21)
("fullwidth_latin_capital_letter_b" . #xff22)
("fullwidth_latin_capital_letter_c" . #xff23)
("fullwidth_latin_capital_letter_d" . #xff24)
("fullwidth_latin_capital_letter_e" . #xff25)
("fullwidth_latin_capital_letter_f" . #xff26)
("fullwidth_latin_capital_letter_g" . #xff27)
("fullwidth_latin_capital_letter_h" . #xff28)
("fullwidth_latin_capital_letter_i" . #xff29)
("fullwidth_latin_capital_letter_j" . #xff2a)
("fullwidth_latin_capital_letter_k" . #xff2b)
("fullwidth_latin_capital_letter_l" . #xff2c)
("fullwidth_latin_capital_letter_m" . #xff2d)
("fullwidth_latin_capital_letter_n" . #xff2e)
("fullwidth_latin_capital_letter_o" . #xff2f)
("fullwidth_latin_capital_letter_p" . #xff30)
("fullwidth_latin_capital_letter_q" . #xff31)
("fullwidth_latin_capital_letter_r" . #xff32)
("fullwidth_latin_capital_letter_s" . #xff33)
("fullwidth_latin_capital_letter_t" . #xff34)
("fullwidth_latin_capital_letter_u" . #xff35)
("fullwidth_latin_capital_letter_v" . #xff36)
("fullwidth_latin_capital_letter_w" . #xff37)
("fullwidth_latin_capital_letter_x" . #xff38)
("fullwidth_latin_capital_letter_y" . #xff39)
("fullwidth_latin_capital_letter_z" . #xff3a)
("fullwidth_left_square_bracket" . #xff3b)
("fullwidth_reverse_solidus" . #xff3c)
("fullwidth_right_square_bracket" . #xff3d)
("fullwidth_circumflex_accent" . #xff3e)
("fullwidth_low_line" . #xff3f)
("fullwidth_grave_accent" . #xff40)
("fullwidth_latin_small_letter_a" . #xff41)
("fullwidth_latin_small_letter_b" . #xff42)
("fullwidth_latin_small_letter_c" . #xff43)
("fullwidth_latin_small_letter_d" . #xff44)
("fullwidth_latin_small_letter_e" . #xff45)
("fullwidth_latin_small_letter_f" . #xff46)
("fullwidth_latin_small_letter_g" . #xff47)
("fullwidth_latin_small_letter_h" . #xff48)
("fullwidth_latin_small_letter_i" . #xff49)
("fullwidth_latin_small_letter_j" . #xff4a)
("fullwidth_latin_small_letter_k" . #xff4b)
("fullwidth_latin_small_letter_l" . #xff4c)
("fullwidth_latin_small_letter_m" . #xff4d)
("fullwidth_latin_small_letter_n" . #xff4e)
("fullwidth_latin_small_letter_o" . #xff4f)
("fullwidth_latin_small_letter_p" . #xff50)
("fullwidth_latin_small_letter_q" . #xff51)
("fullwidth_latin_small_letter_r" . #xff52)
("fullwidth_latin_small_letter_s" . #xff53)
("fullwidth_latin_small_letter_t" . #xff54)
("fullwidth_latin_small_letter_u" . #xff55)
("fullwidth_latin_small_letter_v" . #xff56)
("fullwidth_latin_small_letter_w" . #xff57)
("fullwidth_latin_small_letter_x" . #xff58)
("fullwidth_latin_small_letter_y" . #xff59)
("fullwidth_latin_small_letter_z" . #xff5a)
("fullwidth_left_curly_bracket" . #xff5b)
("fullwidth_vertical_line" . #xff5c)
("fullwidth_right_curly_bracket" . #xff5d)
("fullwidth_tilde" . #xff5e)
("halfwidth_ideographic_full_stop" . #xff61)
("halfwidth_left_corner_bracket" . #xff62)
("halfwidth_right_corner_bracket" . #xff63)
("halfwidth_ideographic_comma" . #xff64)
("halfwidth_katakana_middle_dot" . #xff65)
("halfwidth_katakana_letter_wo" . #xff66)
("halfwidth_katakana_letter_small_a" . #xff67)
("halfwidth_katakana_letter_small_i" . #xff68)
("halfwidth_katakana_letter_small_u" . #xff69)
("halfwidth_katakana_letter_small_e" . #xff6a)
("halfwidth_katakana_letter_small_o" . #xff6b)
("halfwidth_katakana_letter_small_ya" . #xff6c)
("halfwidth_katakana_letter_small_yu" . #xff6d)
("halfwidth_katakana_letter_small_yo" . #xff6e)
("halfwidth_katakana_letter_small_tu" . #xff6f)
("halfwidth_katakana_hiragana_prolonged_sound_mark" . #xff70)
("halfwidth_katakana_letter_a" . #xff71)
("halfwidth_katakana_letter_i" . #xff72)
("halfwidth_katakana_letter_u" . #xff73)
("halfwidth_katakana_letter_e" . #xff74)
("halfwidth_katakana_letter_o" . #xff75)
("halfwidth_katakana_letter_ka" . #xff76)
("halfwidth_katakana_letter_ki" . #xff77)
("halfwidth_katakana_letter_ku" . #xff78)
("halfwidth_katakana_letter_ke" . #xff79)
("halfwidth_katakana_letter_ko" . #xff7a)
("halfwidth_katakana_letter_sa" . #xff7b)
("halfwidth_katakana_letter_si" . #xff7c)
("halfwidth_katakana_letter_su" . #xff7d)
("halfwidth_katakana_letter_se" . #xff7e)
("halfwidth_katakana_letter_so" . #xff7f)
("halfwidth_katakana_letter_ta" . #xff80)
("halfwidth_katakana_letter_ti" . #xff81)
("halfwidth_katakana_letter_tu" . #xff82)
("halfwidth_katakana_letter_te" . #xff83)
("halfwidth_katakana_letter_to" . #xff84)
("halfwidth_katakana_letter_na" . #xff85)
("halfwidth_katakana_letter_ni" . #xff86)
("halfwidth_katakana_letter_nu" . #xff87)
("halfwidth_katakana_letter_ne" . #xff88)
("halfwidth_katakana_letter_no" . #xff89)
("halfwidth_katakana_letter_ha" . #xff8a)
("halfwidth_katakana_letter_hi" . #xff8b)
("halfwidth_katakana_letter_hu" . #xff8c)
("halfwidth_katakana_letter_he" . #xff8d)
("halfwidth_katakana_letter_ho" . #xff8e)
("halfwidth_katakana_letter_ma" . #xff8f)
("halfwidth_katakana_letter_mi" . #xff90)
("halfwidth_katakana_letter_mu" . #xff91)
("halfwidth_katakana_letter_me" . #xff92)
("halfwidth_katakana_letter_mo" . #xff93)
("halfwidth_katakana_letter_ya" . #xff94)
("halfwidth_katakana_letter_yu" . #xff95)
("halfwidth_katakana_letter_yo" . #xff96)
("halfwidth_katakana_letter_ra" . #xff97)
("halfwidth_katakana_letter_ri" . #xff98)
("halfwidth_katakana_letter_ru" . #xff99)
("halfwidth_katakana_letter_re" . #xff9a)
("halfwidth_katakana_letter_ro" . #xff9b)
("halfwidth_katakana_letter_wa" . #xff9c)
("halfwidth_katakana_letter_n" . #xff9d)
("halfwidth_katakana_voiced_sound_mark" . #xff9e)
("halfwidth_katakana_semi_voiced_sound_mark" . #xff9f)
("fullwidth_cent_sign" . #xffe0)
("fullwidth_pound_sign" . #xffe1)
("fullwidth_not_sign" . #xffe2)
("fullwidth_macron" . #xffe3)
("fullwidth_broken_bar" . #xffe4)
("fullwidth_yen_sign" . #xffe5)
("fullwidth_won_sign" . #xffe6)
))
