﻿/**
* @author b2ox
*/
package org.b2ox.flash3d.MikuMikuDance
{
	import org.b2ox.math.Number3D;

	/**
	 * PMDの表情を保持するためのクラス
	 */
	public class PMDSkin
	{
		public static const TYPE_BASE:int = 0;
		public static const TYPE_EYEBROW:int = 1;
		public static const TYPE_EYE:int = 2;
		public static const TYPE_LIP:int = 3;
		public static const TYPE_OTHER:int = 4;

		private var _name:String;
		private var _type:int;
		private var _vertex:Vector.<VertexInfo>;
		private var _size:int;
		private var _weight:Number;

		public function get name():String { return _name; }
		public function get type():int { return _type; }
		public function get size():int { return _size; }
		public function get weight():Number { return _weight; }
		public function set weight(w:Number):void { _weight = (w < 0) ? 0 : ((w > 1) ? 1 : w); }

		/**
		 * 
		 * @param	name
		 * @param	vcount
		 * @param	type
		 */
		public function PMDSkin(name:String, vcount:int, type:int):void
		{
			_name = name;
			_type = (type < 0 || 4 < type) ? 4 : type;
			_size = vcount;
			_vertex = new Vector.<VertexInfo>(vcount);
			_weight = 0;
		}

		/**
		 * 
		 * @param	i
		 * @param	bi	基準頂点のインデックス
		 * @param	x
		 * @param	y
		 * @param	z
		 */
		public function setVertex(i:int, bi:int, x:Number, y:Number, z:Number):void
		{
			_vertex[i] = new VertexInfo(bi, x, y, z);
		}

		/**
		 * baseSkinが指しているオリジナルの頂点番号を取得する
		 * @param	baseSkin
		 */
		public function calcTargetIndices(baseSkin:PMDSkin):void
		{
			if (_type == TYPE_BASE) return;
			for each(var v:VertexInfo in _vertex) v.target_index = baseSkin._vertex[v.index].index;
		}

		/**
		 * ターゲットに対して表情変形を適用する
		 * @param	target
		 * @param	baseSkin
		 */
		public function effect(target:Vector.<Number3D>, baseSkin:PMDSkin):void
		{
			var v:VertexInfo;
			if (_type == TYPE_BASE)
			{
				for each(v in _vertex) target[v.index].reset(v.x, v.y, v.z);
			} else {
				for each(v in _vertex)
				{
					var w:VertexInfo = baseSkin._vertex[v.index];
					target[w.index].reset( w.x + v.x * _weight, w.y + v.y * _weight, w.z + v.z * _weight );
				}
			}
		}

		/**
		 * 表情変形を重ねがけする.
		 * これを使う前には必ずcalcTargetIndicesを実行すること(PMDController.addSkinの時に実行するのでユーザーは気にしなくて良い)
		 * @param	target
		 */
		public function effectPlus(target:Vector.<Number3D>):void
		{
			if (_weight == 0 || _type == TYPE_BASE) return;
			for each(var v:VertexInfo in _vertex)
			{
				var t:Number3D = target[v.target_index];
				t.x += v.x * _weight;
				t.y += v.y * _weight;
				t.z += v.z * _weight;
			}
		}
	}
}

class VertexInfo
{
	public var index:int;
	public var target_index:int = -1;
	public var x:Number, y:Number, z:Number;
	public function VertexInfo(index:int, x:Number, y:Number, z:Number):void
	{
		this.index = index;
		this.x = x;
		this.y = y;
		this.z = z;
	}
}