﻿/**
* @author b2ox
*/
package org.b2ox.flash3d.MikuMikuDance
{
	import org.b2ox.flash3d.*;
	import org.b2ox.flash3d.MikuMikuDance.debug.*;
	import org.b2ox.math.*;
	import org.papervision3d.*;	// _attachment絡みで使用
	import org.papervision3d.objects.*;	// _attachment絡みで使用

	/**
	 * ボーン情報の格納とボーン変形の計算など
	 */
	public class PMDBone
	{
		private var _boneName:String;
		private var _parentID:int, _tailID:int, _boneType:int, _ikParentID:int;
		private var _offset:Number3D;
		private var _translation:Number3D;
		private var _translation_world:Number3D;
		private var _rotation:Quaternion;
		private var _rotation_world:Quaternion;
		private var _parentBone:PMDBone;
		private var _bindVerts:Vector.<BindingInfo>;
		private var _children:Vector.<PMDBone>;
		private var _isRootBone: Boolean;
		private var _isKnee: Boolean;
		private var _mmd: MikuMikuDance;
		private var _attachment: DisplayObject3D; // PV3D

		private var tmpQ:Quaternion;
		private var tmpV1:Number3D, tmpV2:Number3D, tmpV3:Number3D;

		/**
		 * コンストラクタ.
		 * @param	bone_name
		 * @param	parent_id
		 * @param	tail_id
		 * @param	bone_type
		 * @param	ik_parent_id
		 */
		public function PMDBone(bone_name:String, parent_id:int, tail_id:int, bone_type:int, ik_parent_id:int):void
		{
			_boneName = bone_name;
			_parentID = parent_id; 
			_tailID = tail_id;
			_boneType = bone_type;
			_ikParentID = ik_parent_id;
			_isKnee = bone_name == "右ひざ" || bone_name == "左ひざ";
			_isRootBone = parent_id == 65535; // parent_idが65535はルートボーン

			_translation = new Number3D();
			_offset = new Number3D();
			_translation_world = new Number3D();

			_rotation = new Quaternion();
			_rotation_world = new Quaternion();

			_attachment = new DisplayObject3D();

			_bindVerts = new Vector.<BindingInfo>();
			_children = new Vector.<PMDBone>();
			_parentBone = null;
			tmpQ = new Quaternion();
			tmpV1 = new Number3D();
			tmpV2 = new Number3D();
			tmpV3 = new Number3D();
		}

		//-------------------------------------------------
		// 各種プロパティ
		public function get name():String { return _boneName; }
		public function get parentID():int { return _parentID; }
		public function get isRootBone():Boolean { return _isRootBone; }
		public function get translation():Number3D { return _translation; }
		public function get translationWorld():Number3D { return _translation_world; }
		public function set rotation(q:Quaternion):void { _rotation.copyFrom(q); }
		public function get rotation():Quaternion { return _rotation; }
		public function get rotationWorld():Quaternion { return _rotation_world; }

		public function set mmd(m:MikuMikuDance):void { _mmd = m; _mmd.addChild(_attachment); }

		//-------------------------------------------------
		/**
		 * 初期位置の設定
		 * @param	x
		 * @param	y
		 * @param	z
		 */
		public function initTranslation(x:Number, y:Number, z:Number):void
		{
			_translation.reset(x,y,z);
			_offset.reset(x, y, z);
		}

		/**
		 * 初期位置からの変位を設定
		 */
		public function move(dv:Number3D):void
		{
			_translation.copyFrom(_offset);
			_translation.plusEq(dv);
		}

		/**
		 * 初期位置・回転に戻す
		 */
		public function reset():void
		{
			_translation.copyFrom(_offset);
			_rotation.reset(0,0,0,1);
		}

		//-------------------------------------------------
		/**
		 * 子ボーンを追加
		 * @param	bone
		 */
		public function addChildBone(bone:PMDBone):void
		{
			bone._parentBone = this;
			_children.push(bone);
		}

		/**
		 * 現在のボーンに頂点をバインドする
		 * @param	vertexID
		 * @param	weight
		 */
		public function bindVertex(vertexID:int, weight:Number):void
		{
			_bindVerts.push(new BindingInfo(vertexID, weight));
		}

		/**
		 * ボーンのワールド座標での位置・回転を計算する
		 * 親ボーンから順に計算する必要有り。ただし、PMDでは親ボーンから順に並んで格納されているので特に気にする必要なし
		 */
		public function calcTransformWorld():void
		{
			if (_isRootBone)
			{
				_rotation_world.copyFrom(_rotation);
				_translation_world.copyFrom(_translation);
			} else {
				_rotation_world.copyFrom(_rotation);
				_rotation_world.multiplyEq(_parentBone._rotation_world);
				_rotation_world.normalize();

				_translation_world.copyFrom(_translation);
				// 第二引数を _parentBone._translation にしてしまうとボーンの変位がおかしくなる
				_parentBone._rotation_world.transformVector(_translation_world, _parentBone._offset, _parentBone._translation_world);
			}
			_attachment.x = _translation_world.x;
			_attachment.y = _translation_world.y;
			_attachment.z = _translation_world.z;
			_rotation_world.eulerSetTo(tmpV1);
			var b:Boolean = Papervision3D.useDEGREES;
			Papervision3D.useDEGREES = false;
			_attachment.rotationX = tmpV1.x;
			_attachment.rotationY = tmpV1.y;
			_attachment.rotationZ = tmpV1.z;
			Papervision3D.useDEGREES = b;
		}

		/**
		 * ボーン変形を影響頂点に適用する
		 * 
		 * @param	target
		 * @param	source
		 */
		public function effectBone(target:Vector.<Number3D>, source:Vector.<Number3D>):void
		{
			var transformer:Function = _rotation_world.getVectorTransformer(_translation, _translation_world);
			for each (var bi:BindingInfo in _bindVerts) transformer(target[bi.vertexID], source[bi.vertexID], bi.weight);
		}

		//-------------------------------------------------
		// IK計算用
		private var _IKiterations:int = 0;
		private var _IKweight:Number = 0;
		private var _IKchain:Array = null;
		private var _isIKbone:Boolean = false;
		private var _isIKchain:Boolean = false;
		private var _isIKeffector:Boolean = false;
		public function get isIKbone():Boolean { return _isIKbone; }
		public function get isIKchain():Boolean { return _isIKchain; }
		public function get isIKeffector():Boolean { return _isIKeffector; }

		private const AproxEpsilon:Number = 0.00001;
		private const LimitAngle:Number = 0.002;

		/**
		 * IKパラメータの登録
		 * @param	iterations
		 * @param	weight
		 * @param	chain
		 */
		public function regIKparams(iterations:int, weight:Number, chain:Array):void
		{
			_IKiterations = iterations;
			_IKweight = weight * Math.PI;
			_IKchain = chain;
			_isIKbone = true;
			_IKchain[0]._isIKeffector = true;
			for each (var bone:PMDBone in chain) bone._isIKchain = true;
		}

		/**
		 * IK計算(CCD-IKのつもり)
		 */
		public function calcIK():void
		{
			if (_isIKbone != true) return; // IKボーンでなければ無視
			var effector:PMDBone = _IKchain[0];
			var n:int = _IKchain.length;
			for (var k:int = 0; k < _IKiterations; k++)
			{
				for (var i:int = 1; i < n; i++)
				{
					// _translation_worldが目標点
					tmpV1.copyFrom(_translation_world);
					tmpV1.minusEq(effector._translation_world);
					if (tmpV1.isModuloLessThan(AproxEpsilon)) return; // エフェクタが十分近ければ終了

					var bone:PMDBone = _IKchain[i];

					// tmpV1: boneからeffectorへのベクトル
					tmpV1.setSub(effector._translation_world, bone._translation_world);

					// tmpV2: boneからIKboneへのベクトル
					tmpV2.setSub(_translation_world, bone._translation_world);

					// theta: tmpV1,tmpV2のなす角
					var theta:Number = tmpV1.angle(tmpV2);
					if (AproxEpsilon < Math.abs(theta)) theta = (theta < -_IKweight) ? -_IKweight : ((theta > _IKweight) ? _IKweight : theta);

					// tmpV3 = (tmpV1 x tmpV2)/|tmpV1 x tmpV2|
					tmpV3.setCross(tmpV1, tmpV2);
					if (tmpV3.modulo < AproxEpsilon) continue;
					bone._rotation_world.applyLeft(tmpV3);
					tmpV3.normalize();

					// tmpQ: tmpV1からtmpV2への回転
					tmpQ.setFromAxisAngle(tmpV3.x, tmpV3.y, tmpV3.z, theta);
					bone._rotation.multiplyEq(tmpQ);
					bone._rotation.normalize();

					// 膝関節では角度制限する
					if (bone._isKnee)
					{
						bone._rotation.eulerSetTo(tmpV1);
						theta = tmpV1.z;
						theta = (theta > Math.PI) ? Math.PI : ((theta < LimitAngle) ? LimitAngle : theta);
						bone._rotation.setFromEuler(0, 0, theta)
					}

					// 先端方向に向かって回転の再計算
					for (var j:int = i; j >= 0; j--) _IKchain[j].calcTransformWorld();
				}
			}
		}

		//-------------------------------------------------
		/**
		 * ボーンにアクセサリを取り付ける
		 * @param	mdl
		 * @param	mdlName
		 */
		public function attachModel(mdl:DisplayObject3D, mdlName:String):void
		{
			_attachment.addChild(mdl, mdlName);
		}
		/**
		 * ボーンかアクセサリを取り外す
		 * @param	mdlName
		 */
		public function removeModel(mdlName:String):void
		{
			_attachment.removeChildByName(mdlName);
		}

		//-------------------------------------------------
		// デバッグ用
		/**
		 * 基点位置に立方体を表示する.
		 * ボーンの種類ごとに違う色になる
		 */
		public function showCube():void
		{
			PMDBoneDbg.addCube(this);
		}
		/**
		 * ボーン情報文字列
		 */
		public function get boneInfo():String {
			var str:String;
			str = _boneName + " (parent: " + (_parentBone == null ? "none" : _parentBone.name) + ")";
			str += "\n   rot: " + _rotation + " trans: " + _translation + " init: " + _offset;
			str += "\n   global rot: " + _rotation_world + " trans: " + _translation_world;
			str += "\n   (tailID, IKparentID, boneType) = (" + [_tailID, _ikParentID, _boneType] + ")";
			return str;
		}
	}
}

class BindingInfo
{
	public var vertexID:int;
	public var weight:Number;
	public function BindingInfo(vertexID:int, weight:Number):void
	{
		this.vertexID = vertexID;
		this.weight = weight;
	}
}