﻿/**
 * basic template for Alternativa3D 7.5
 * http://wonderfl.net/c/mPMv
 * Alternativa3D 7.5を扱いやすくするためのテンプレートです
 * @author narutohyper & clockmaker
 */

package net.wonderfl.alternativa3d {
	import alternativa.engine3d.containers.BSPContainer;
	import alternativa.engine3d.containers.ConflictContainer;
	import alternativa.engine3d.containers.DistanceSortContainer;
	import alternativa.engine3d.containers.KDContainer;
	import alternativa.engine3d.containers.LODContainer;
	import alternativa.engine3d.controllers.SimpleObjectController;
	import alternativa.engine3d.core.Camera3D;
	import alternativa.engine3d.core.Object3DContainer;
	import alternativa.engine3d.core.View;
	import flash.display.DisplayObject;

	import flash.display.DisplayObjectContainer;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;

	import flash.events.Event;

	public class AlternativaTemplate extends Sprite
	{
		/**
		 * 子オブジェクトを最適な方法でソートするコンテナ
		 * (ConflictContainer)
		 */
		public static const CONFLICT:String = 'conflict';
		/**
		 * 子オブジェクトをBSP(バイナリ空間分割法)によってソートするコンテナ
		 * (BSPContainer)
		 */
		public static const BSP:String = 'bsp';

		/**
		 * 子オブジェクトをカメラからのZ値でソートするコンテナ
		 * (DistanceSortContainer)
		 */
		public static const ZSORT:String = 'zsort';
		/**
		 * KDツリー(http://ja.wikipedia.org/wiki/Kd%E6%9C%A8)によってソートするコンテナ
		 * (KDContainer)
		 */
		public static const KD:String = 'kd';
		/**
		 * detalizationと子オブジェクトの距離でソートするコンテナ（詳細は調査中）
		 * (LODContainer)
		 */
		public static const LOD:String = 'lod';

		/**
		 * 3dオブジェクト格納するコンテナインスタンス。
		 */
		public var container:Object3DContainer;

		/**
		 * ビューインスタンスです。
		 */
		public var view:View;

		/**
		 * カメラインスタンスです。
		 */
		public var camera:Camera3D;

		/**
		 * カメラコントローラーです。
		 */
		public var cameraController:SimpleObjectController;

		private var _mc:DisplayObjectContainer;
		private var _viewWidth:int;
		private var _viewHeight:int;
		private var _scaleToStage:Boolean;
		private var _containerType:String;

		/**
		 * 新しい Alternativa3DTemplate インスタンスを作成します。
		 * @param    mc
		 * @param    containerType
		 * @param    viewWidth
		 * @param    viewHeight
		 * @param    scaleToStage
		 */
		public function AlternativaTemplate(mc:DisplayObjectContainer,containerType:String=CONFLICT,viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true)
		{

			_mc = mc;
			_mc.addChild(this);

			_containerType = containerType;
			_viewWidth = viewWidth;
			_viewHeight = viewHeight;
			_scaleToStage = scaleToStage;

			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}

		/**
		 * 初期化されたときに実行されるイベントです。
		 * 初期化時に実行したい処理をオーバーライドして記述します。
		 */
		protected function atInit():void {}

		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング前に実行したい処理をオーバーライドして記述します。
		 */
		protected function atPreRender():void {}

		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング前に実行したい処理をオーバーライドして記述します。
		 */
		private var _onPreRender:Function = function():void{};
		public function get onPreRender():Function { return _onPreRender; }
		public function set onPreRender(value:Function):void
		{
			_onPreRender = value;
		}

		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング後に実行したい処理をオーバーライドして記述します。
		 */
		protected function atPostRender():void {}

		/**
		 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
		 * レンダリング後に実行したい処理を記述します。
		 */
		private var _onPostRender:Function = function():void{};
		public function get onPostRender():Function { return _onPostRender; }
		public function set onPostRender(value:Function):void
		{
			_onPostRender = value;
		}

		/**
		 * レンダリングを開始します。
		 */
		public function startRendering():void
		{
			addEventListener(Event.ENTER_FRAME, onRenderTick);
		}

		/**
		 * レンダリングを停止します。
		 */
		public function stopRendering():void
		{
			removeEventListener(Event.ENTER_FRAME, onRenderTick);
		}

		/**
		 * シングルレンダリング(レンダリングを一回だけ)を実行します。
		 */
		public function singleRender():void
		{
			onRenderTick();
		}

		/**
		 * @private
		 */
		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.HIGH;

			//Root objectの作成
			if (_containerType == CONFLICT) {
				container = new ConflictContainer();
			} else if (_containerType == BSP) {
				container = new BSPContainer();
			} else if (_containerType == ZSORT) {
				container = new DistanceSortContainer();
			} else if (_containerType == KD) {
				container = new KDContainer();
			} else if (_containerType == LOD) {
				container = new LODContainer();
			}
			//Viewの作成
			view = new View(stage.stageWidth, stage.stageHeight);
			view.interactive = true;
			view.hideLogo(); // 右下のロゴを消す
			_mc.addChild(view);

			//cameraの作成
			camera = new Camera3D();
			camera.view = view;
			camera.x = 0;
			camera.y = -500;
			camera.z = 0;
			container.addChild(camera);

			// Camera controller
			cameraController = new SimpleObjectController(stage, camera, 10);
			cameraController.mouseSensitivity = 0;
			cameraController.unbindAll();
			cameraController.lookAtXYZ(0, 0, 0);

			onResize();
			stage.addEventListener(Event.RESIZE, onResize);

			atInit();
		}

		/**
		 * @private
		 */
		private function onResize(e:Event = null):void
		{
			if (_scaleToStage)
			{
				view.width = stage.stageWidth;
				view.height = stage.stageHeight;
			}
			else
			{
				view.width = _viewWidth;
				view.height = _viewHeight;
			}
		}

		/**
		 * @private
		 */
		private function onRenderTick(e:Event = null):void
		{
			atPreRender();
			_onPreRender();
			cameraController.update();
			camera.render();
			atPostRender();
			_onPostRender();
		}
	}
}