#pragma once

//----------------------------------------------------------------------
//
//			File:			"ViEngine.h"
//			Created:		24-Feb-2011
//			Author:			Nobuhide Tsuda
//			Description:	viGWNX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#ifndef VIENGINE_H
#define VIENGINE_H

#include <QObject>
#include <QStringList>
#include "vi.h"

class QKeyEvent;
class TextView;
class TextDocument;
class ViewCursor;

class ViEngine : public QObject
{
	Q_OBJECT

#if 0
public:
	enum Mode {
		CMD = 0,
		INSERT,
	};
#endif

public:
	ViEngine(QObject *parent = 0);
	~ViEngine();

public:
	bool	viSupported() const { return m_viSupported; }
	Mode	mode() const { return m_mode; }
	const QString &message() const { return m_message; }
	const QStringList &exCommands() const { return m_exCommands; }

public:
	void	setViSupported(bool);
	bool	doViCommand(const QChar &);
	void	onImeOpenStatusChanged();
	void	setMode(Mode mode, ushort=0);
	void	setEditor(TextView *editor);	//{ m_view = editor; }
	TextView *editor() { return m_view; }
	TextDocument	*document();
	void	doExCommand(const QString &);			//	ɂ́A擪 : ܂܂Ȃ񂪓n
	void	doSet(const QString &);
	void	doSet(const QString &, const QString &);
	void	doFind(const QString &, bool);			//	
	bool	processKeyPressEvent( QKeyEvent * event );

public slots:
	void	doViCommand(const QString &);

signals:
	void	modeChanged(Mode, ushort=0);
	void	modeChanged(uchar);
	void	reOpen();
	void	open(const QString &);
	void	save(const QString &);
	void	regexpSearched(const QString &);
	void	testViCommands(QString fileName);
	void	showMessage(const QString &);
	void	doOutput(const QString &);
	void	clearOutput();
	void	closeView(TextView*, bool = false);
	void	closeAllViews(bool = false);

protected:
	bool	eventFilter(QObject *obj, QEvent *event);

	bool	cmdModeKeyPressEvent(QKeyEvent *);
	bool	insModeKeyPressEvent(QKeyEvent *);
	void	doJoin(int n);
	bool	doShiftRight(ViewCursor&, int n);
	bool	doShiftLeft(ViewCursor&, int n);
	bool	doFindNext(ViewCursor &cur, int nth, bool revers=false);
	void	doSubst(const QString &, int, int);
	bool	parseSubstCmd(const QString &, QString &, QString &, bool &);
	void	doDelete();
	void	copyToYankBuffer(bool, const QString &);

	void	printSettings();
	void	printCursorPosition();

	int		repeatCount() const;
	//{ return !m_repeatCount ? 1 : m_repeatCount; }
	QString	yankText(bool &byLine) const;


	void	getLineNumbers(const QString &, int &);		//	ex command ̍sԍ͈͕
	bool	getLineNumber(const QString &, int &, int &);	//	l
	bool	getAddSubTerm(const QString &, int &, int &);	//	l [{+|-} l]...
	QString	getExCommand(const QString &, int &, bool &exclamation);

private:
	bool	m_viSupported;			//	vi R}hL
	bool	m_noRepeatCount;		//	JԂ񐔎wsifor fFtTj
	bool	m_redoRecording;		//	.(redo) ̂߂ɑ}L^
	bool	m_redoing;				//	.(redo) s
	bool	m_noInsModeAtImeOpenStatus;		//	IME ONEOFFςĂ}[hɑJڂȂ
	bool	m_joinPrevEditBlock;		//	
	bool	m_findForward;			//	
	bool	m_moveByLine;			//	sPʈړ } { H M L G
	uchar	m_yankBufferName;		//	'a' ` 'z'
	Mode	m_mode;
	int		m_repeatCount;
	int		m_repeatCount2;			//	c2w ̂悤ɃR}h̊ԂɎw肳ꂽJԂ
	int		m_redoRepeatCount;
	int		m_insCount;				//	}
	int		m_cdyPos;				//	c|d|y ꂽ̃J[\ʒu
	//int		m_cursorX;				//	ubN擪xψ
	ushort	m_cmdPrefix;			//	]] [[ ̗lȂQXg[NR}h̍ŏ̕
	ushort	m_cdyCmd;				//	c | d | y R}h
	ushort	m_lastFTCmd;			//	'f' or 'F' or't' or 'T'
	QChar	m_lastFTChar;			//	fFtT 
	QString	m_findString;			//	K\
	QString	m_cmdString;			//	͒R}heLXg
	QString	m_redoCmd;				//	.(redo) ōĎsR}h
	QString	m_insertedText;			//	}ꂽeLXg
	QString	m_message;
	bool	m_yankByLine;			//	Nobt@FsP
	QString	m_yankBuffer;			//	Nobt@
	bool	m_namedYankByLine[26];	//	Nobt@FsP
	QString	m_namedYankBuffer[26];	//	OtNobt@i'a'`'z'j
	QStringList	m_exCommands;		//	͂ꂽ ex-command 
	TextView	*m_view;

	//	undone C sԍ֌W͓Ɨ\̂ɂ悳
	int		m_nLineNum;				//	w肳ꂽsԍ
	int		m_lineNum1;				//	ex command range from
	int		m_lineNum2;				//	ex command range to
	int		m_curLineNum;			//	. lineNumber
};

#endif // VIENGINE_H
