/*
 * obsolete_chroot_su.c
 *
 * A combined program for "chroot" and "su".
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 *
 * This program is intended to start programs as non-root
 * under chroot'ed environment, without placing "su".
 * Placing "su" in the chroot'ed environment may allow
 * programs to become root. Thats why I made this program.
 *
 * This program is obsolete.
 */
#include <stdio.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#define MAXGROUPS 32

static int group_count = 0;
static gid_t group_list[MAXGROUPS];

static void AddGroups(gid_t gid) {
	int i;
	if (group_count < MAXGROUPS) {
		for (i = 0; i < group_count; i++) if (group_list[i] == gid) break;
		if (i == group_count) group_list[group_count++] = gid;
	}
}

int main(int argc, char *argv[]) {
	struct passwd *pw;
	struct group *gr;
	const char *new_user;
	const char *new_root;
	const char *program_to_run;
	if (argc < 4) {
		fprintf(stderr, "%s new_root new_user program_to_run [param]\n", argv[0]);
		return 1;
	}
	new_root = *(++argv);
	new_user = *(++argv);
	program_to_run = *(++argv);
	if ((pw = getpwnam(new_user)) == NULL) {
		fprintf(stderr, "user '%s' does not exist.\n", new_user);
		return 1;
	}
	AddGroups(pw->pw_gid);
	setgrent();
	while ((gr = getgrent()) != NULL) {
		char **list = gr->gr_mem;
		while (*list != NULL) {
			if (strcmp(*list, new_user) == 0) AddGroups(gr->gr_gid);
			list++;
		}
	}
	endgrent();
	if (chroot(new_root) || chdir("/")) {
		fprintf(stderr, "Can't chroot to '%s' : %s.\n", new_root, strerror(errno));
		return 1;
	}
	if (setgroups(group_count, group_list)) {
		fprintf(stderr, "Can't change groups for '%s' : %s\n.", new_user, strerror(errno));
		return 1;
	}
	if (setgid(pw->pw_gid)) {
		fprintf(stderr, "Can't change gid for '%s' : %s\n.", new_user, strerror(errno));
		return 1;
	}
	if (setuid(pw->pw_uid)) {
		fprintf(stderr, "Can't change uid for '%s' : %s\n.", new_user, strerror(errno));
		return 1;
	}
	execvp(program_to_run, argv);
	fprintf(stderr, "Can't exec '%s' : %s\n", program_to_run, strerror(errno));
	return 1;
}
