#! /bin/bash
#
# Initial policy generator.
#
# Copyright (C) 2005-2007  NTT DATA CORPORATION
#
# Version: 1.4.1   2007/06/05
#

cd ${0%/*}
export PATH=$PWD:/sbin:/bin:${PATH}

PROFILE_TYPE="--full-profile"

while [ $# -gt 0 ]
do
	case "$1" in
	--file-only-profile|--full-profile)
		PROFILE_TYPE="$1"
		;;
	esac
	shift
done

if [ ! -d /etc/ccs/ ]; then
	echo Creating policy directory.
	mkdir -p /etc/ccs
fi
chmod 700 /etc/ccs/
chown root:root /etc/ccs/

if [ ! -r /etc/ccs/manager.txt ]; then
	echo Creating manager policy.
	echo $PWD/loadpolicy  > /etc/ccs/manager.txt
	echo $PWD/editpolicy >> /etc/ccs/manager.txt
	echo $PWD/setlevel   >> /etc/ccs/manager.txt
	echo $PWD/setprofile >> /etc/ccs/manager.txt
	echo $PWD/ld-watch   >> /etc/ccs/manager.txt
	echo $PWD/ccs-queryd >> /etc/ccs/manager.txt
fi

if [ ! -r /etc/ccs/status.txt ]; then
	echo Creating default profile.
	case "$PROFILE_TYPE" in
	--file-only-profile)
		cat > /etc/ccs/status.txt << EOF
0-COMMENT=-----Disabled Mode-----
0-MAC_FOR_FILE=0
0-TOMOYO_VERBOSE=0
1-COMMENT=-----Learning Mode-----
1-MAC_FOR_FILE=1
1-TOMOYO_VERBOSE=0
2-COMMENT=-----Permissive Mode-----
2-MAC_FOR_FILE=2
2-TOMOYO_VERBOSE=1
3-COMMENT=-----Enforcing Mode-----
3-MAC_FOR_FILE=3
3-TOMOYO_VERBOSE=1
EOF
		;;
	*)
		cat > /etc/ccs/status.txt << EOF
0-COMMENT=-----Disabled Mode-----
1-COMMENT=-----Learning Mode-----
1-MAC_FOR_FILE=1
1-MAC_FOR_ARGV0=1
1-MAC_FOR_NETWORK=1
1-MAC_FOR_SIGNAL=1
1-DENY_CONCEAL_MOUNT=1
1-RESTRICT_CHROOT=1
1-RESTRICT_MOUNT=1
1-RESTRICT_UNMOUNT=1
1-RESTRICT_PIVOT_ROOT=1
1-RESTRICT_AUTOBIND=1
1-MAX_ACCEPT_ENTRY=2048
1-MAX_GRANT_LOG=1024
1-MAX_REJECT_LOG=1024
1-TOMOYO_VERBOSE=0
1-ALLOW_ENFORCE_GRACE=0
1-MAC_FOR_CAPABILITY::inet_tcp_create=1
1-MAC_FOR_CAPABILITY::inet_tcp_listen=1
1-MAC_FOR_CAPABILITY::inet_tcp_connect=1
1-MAC_FOR_CAPABILITY::use_inet_udp=1
1-MAC_FOR_CAPABILITY::use_inet_ip=1
1-MAC_FOR_CAPABILITY::use_route=1
1-MAC_FOR_CAPABILITY::use_packet=1
1-MAC_FOR_CAPABILITY::SYS_MOUNT=1
1-MAC_FOR_CAPABILITY::SYS_UMOUNT=1
1-MAC_FOR_CAPABILITY::SYS_REBOOT=1
1-MAC_FOR_CAPABILITY::SYS_CHROOT=1
1-MAC_FOR_CAPABILITY::SYS_KILL=1
1-MAC_FOR_CAPABILITY::SYS_VHANGUP=1
1-MAC_FOR_CAPABILITY::SYS_TIME=1
1-MAC_FOR_CAPABILITY::SYS_NICE=1
1-MAC_FOR_CAPABILITY::SYS_SETHOSTNAME=1
1-MAC_FOR_CAPABILITY::use_kernel_module=1
1-MAC_FOR_CAPABILITY::create_fifo=1
1-MAC_FOR_CAPABILITY::create_block_dev=1
1-MAC_FOR_CAPABILITY::create_char_dev=1
1-MAC_FOR_CAPABILITY::create_unix_socket=1
1-MAC_FOR_CAPABILITY::SYS_LINK=1
1-MAC_FOR_CAPABILITY::SYS_SYMLINK=1
1-MAC_FOR_CAPABILITY::SYS_RENAME=1
1-MAC_FOR_CAPABILITY::SYS_UNLINK=1
1-MAC_FOR_CAPABILITY::SYS_CHMOD=1
1-MAC_FOR_CAPABILITY::SYS_CHOWN=1
1-MAC_FOR_CAPABILITY::SYS_IOCTL=1
1-MAC_FOR_CAPABILITY::SYS_KEXEC_LOAD=1
1-MAC_FOR_CAPABILITY::SYS_PIVOT_ROOT=1
2-COMMENT=-----Permissive Mode-----
2-MAC_FOR_FILE=2
2-MAC_FOR_ARGV0=2
2-MAC_FOR_NETWORK=2
2-MAC_FOR_SIGNAL=2
2-DENY_CONCEAL_MOUNT=2
2-RESTRICT_CHROOT=2
2-RESTRICT_MOUNT=2
2-RESTRICT_UNMOUNT=2
2-RESTRICT_PIVOT_ROOT=2
2-RESTRICT_AUTOBIND=1
2-MAX_ACCEPT_ENTRY=2048
2-MAX_GRANT_LOG=1024
2-MAX_REJECT_LOG=1024
2-TOMOYO_VERBOSE=1
2-ALLOW_ENFORCE_GRACE=0
2-MAC_FOR_CAPABILITY::inet_tcp_create=2
2-MAC_FOR_CAPABILITY::inet_tcp_listen=2
2-MAC_FOR_CAPABILITY::inet_tcp_connect=2
2-MAC_FOR_CAPABILITY::use_inet_udp=2
2-MAC_FOR_CAPABILITY::use_inet_ip=2
2-MAC_FOR_CAPABILITY::use_route=2
2-MAC_FOR_CAPABILITY::use_packet=2
2-MAC_FOR_CAPABILITY::SYS_MOUNT=2
2-MAC_FOR_CAPABILITY::SYS_UMOUNT=2
2-MAC_FOR_CAPABILITY::SYS_REBOOT=2
2-MAC_FOR_CAPABILITY::SYS_CHROOT=2
2-MAC_FOR_CAPABILITY::SYS_KILL=2
2-MAC_FOR_CAPABILITY::SYS_VHANGUP=2
2-MAC_FOR_CAPABILITY::SYS_TIME=2
2-MAC_FOR_CAPABILITY::SYS_NICE=2
2-MAC_FOR_CAPABILITY::SYS_SETHOSTNAME=2
2-MAC_FOR_CAPABILITY::use_kernel_module=2
2-MAC_FOR_CAPABILITY::create_fifo=2
2-MAC_FOR_CAPABILITY::create_block_dev=2
2-MAC_FOR_CAPABILITY::create_char_dev=2
2-MAC_FOR_CAPABILITY::create_unix_socket=2
2-MAC_FOR_CAPABILITY::SYS_LINK=2
2-MAC_FOR_CAPABILITY::SYS_SYMLINK=2
2-MAC_FOR_CAPABILITY::SYS_RENAME=2
2-MAC_FOR_CAPABILITY::SYS_UNLINK=2
2-MAC_FOR_CAPABILITY::SYS_CHMOD=2
2-MAC_FOR_CAPABILITY::SYS_CHOWN=2
2-MAC_FOR_CAPABILITY::SYS_IOCTL=2
2-MAC_FOR_CAPABILITY::SYS_KEXEC_LOAD=2
2-MAC_FOR_CAPABILITY::SYS_PIVOT_ROOT=2
3-COMMENT=-----Enforcing Mode-----
3-MAC_FOR_FILE=3
3-MAC_FOR_ARGV0=3
3-MAC_FOR_NETWORK=3
3-MAC_FOR_SIGNAL=3
3-DENY_CONCEAL_MOUNT=3
3-RESTRICT_CHROOT=3
3-RESTRICT_MOUNT=3
3-RESTRICT_UNMOUNT=3
3-RESTRICT_PIVOT_ROOT=3
3-RESTRICT_AUTOBIND=1
3-MAX_ACCEPT_ENTRY=2048
3-MAX_GRANT_LOG=1024
3-MAX_REJECT_LOG=1024
3-TOMOYO_VERBOSE=1
3-ALLOW_ENFORCE_GRACE=0
3-MAC_FOR_CAPABILITY::inet_tcp_create=3
3-MAC_FOR_CAPABILITY::inet_tcp_listen=3
3-MAC_FOR_CAPABILITY::inet_tcp_connect=3
3-MAC_FOR_CAPABILITY::use_inet_udp=3
3-MAC_FOR_CAPABILITY::use_inet_ip=3
3-MAC_FOR_CAPABILITY::use_route=3
3-MAC_FOR_CAPABILITY::use_packet=3
3-MAC_FOR_CAPABILITY::SYS_MOUNT=3
3-MAC_FOR_CAPABILITY::SYS_UMOUNT=3
3-MAC_FOR_CAPABILITY::SYS_REBOOT=3
3-MAC_FOR_CAPABILITY::SYS_CHROOT=3
3-MAC_FOR_CAPABILITY::SYS_KILL=3
3-MAC_FOR_CAPABILITY::SYS_VHANGUP=3
3-MAC_FOR_CAPABILITY::SYS_TIME=3
3-MAC_FOR_CAPABILITY::SYS_NICE=3
3-MAC_FOR_CAPABILITY::SYS_SETHOSTNAME=3
3-MAC_FOR_CAPABILITY::use_kernel_module=3
3-MAC_FOR_CAPABILITY::create_fifo=3
3-MAC_FOR_CAPABILITY::create_block_dev=3
3-MAC_FOR_CAPABILITY::create_char_dev=3
3-MAC_FOR_CAPABILITY::create_unix_socket=3
3-MAC_FOR_CAPABILITY::SYS_LINK=3
3-MAC_FOR_CAPABILITY::SYS_SYMLINK=3
3-MAC_FOR_CAPABILITY::SYS_RENAME=3
3-MAC_FOR_CAPABILITY::SYS_UNLINK=3
3-MAC_FOR_CAPABILITY::SYS_CHMOD=3
3-MAC_FOR_CAPABILITY::SYS_CHOWN=3
3-MAC_FOR_CAPABILITY::SYS_IOCTL=3
3-MAC_FOR_CAPABILITY::SYS_KEXEC_LOAD=3
3-MAC_FOR_CAPABILITY::SYS_PIVOT_ROOT=3
EOF
		;;
	esac
fi

if [ ! -r /etc/ccs/exception_policy.txt ]; then
	echo Creating exception policy. This will take several minutes.
	make_exception.sh > /etc/ccs/exception_policy.txt
	make_alias.sh >> /etc/ccs/exception_policy.txt
fi
