/*
 * logtest.c
 *
 * Testing program for reading /proc/ccs/info/ files.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#define MAX_FILES 5

int main(int argc, char *argv[]) {
	int fd, len, i;
	static char buffer[32768];
	const char *file_list[MAX_FILES] = {
		"/proc/ccs/info/grant_log",
		"/proc/ccs/info/reject_log",
		"/proc/ccs/info/trusted_pids",
		"/proc/ccs/info/deleted_pids",
		"/proc/ccs/info/meminfo"
	};
	memset(buffer, 0, sizeof(buffer));
	if (access("/proc/ccs/", F_OK)) {
		fprintf(stderr, "ERROR: /proc/ccs/ doesn't exist.\n");
		return 1;
	}
	for (i = 0; i < MAX_FILES; i++) {
		fprintf(stderr, "Testing %s  ", file_list[i]);
		if ((fd = open(file_list[i], O_RDWR)) == EOF) {
			fprintf(stderr, "ERROR: can't open.\n");
			return 1;
		}
		if ((len = write(fd, buffer, sizeof(buffer))) != EOF) {
			fprintf(stderr, "ERROR: write() = %d\n", len);
			return 1;
		}
		if (1) {
			do {
				if ((len = read(fd, buffer, 1)) == EOF) {
					const int err = errno;
					fprintf(stderr, "ERROR: read() = %s\n", strerror(err));
					return 1;
				}
				if (len) putchar(buffer[0]);
			} while (len > 0);
		} else {
			do {
				memset(buffer, 0, sizeof(buffer));
				if ((len = read(fd, buffer, sizeof(buffer))) == EOF) {
					const int err = errno;
					fprintf(stderr, "ERROR: read() = %s\n", strerror(err));
					return 1;
				}
				printf("%s", buffer);
			} while (len > 0);
		}
		close(fd);
		fprintf(stderr, "OK\n");
	}
	return 0;
}
