/*
 * bindtest.c
 *
 * Testing program for socket acl and capabilities.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 */
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <errno.h>

int main(int argc, char *argv[]) {
	struct sockaddr_in addr;
	struct sockaddr_in6 addr6;
	int fd1, fd2;
	socklen_t size;

	printf("***** IPv4/UDP *****\n");
	fd1 = socket(PF_INET, SOCK_DGRAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	addr.sin_port = htons(0);
	printf("bind(0): %s\n", bind(fd1, (struct sockaddr *) &addr, sizeof(addr)) == 0 ? "OK" : strerror(errno));
	size = sizeof(addr); getsockname(fd1, (struct sockaddr *) &addr, &size);
	printf("bound=%u\n", ntohs(addr.sin_port));
	close(fd1);
	printf("\n");

	fd1 = socket(PF_INET, SOCK_DGRAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	addr.sin_port = htons(0);
	printf("connect(0): %s\n", connect(fd1, (struct sockaddr *) &addr, sizeof(addr)) == 0 ? "OK" : strerror(errno));
	size = sizeof(addr); getsockname(fd1, (struct sockaddr *) &addr, &size);
	printf("bound=%u\n", ntohs(addr.sin_port));
	close(fd1);
	printf("\n");

	fd1 = socket(PF_INET, SOCK_DGRAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	addr.sin_port = htons(7);
	printf("sendto(7) without connection: %s\n", sendto(fd1, "", 1, 0, (struct sockaddr *) &addr, sizeof(addr)) != EOF ? "OK" : strerror(errno));
	close(fd1);
	printf("\n");

	fd2 = socket(PF_INET, SOCK_DGRAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	addr.sin_port = htons(9);
	printf("bind(9): %s\n", bind(fd2, (struct sockaddr *) &addr, sizeof(addr)) == 0 ? "OK" : strerror(errno));
	fd1 = socket(PF_INET, SOCK_DGRAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	addr.sin_port = htons(9);
	printf("connect(9): %s\n", connect(fd1, (struct sockaddr *) &addr, sizeof(addr)) == 0 ? "OK" : strerror(errno));
	printf("sendto(9): %s\n", sendto(fd1, "", 1, 0, (struct sockaddr *) &addr, sizeof(addr)) != EOF ? "OK" : strerror(errno));
	printf("send: %s\n", send(fd1, "", 1, 0) != EOF ? "OK" : strerror(errno));
	close(fd1);
	close(fd2);
	printf("\n");

	fd1 = socket(PF_INET, SOCK_DGRAM, 0);
	printf("send without connection: %s\n", send(fd1, "", 1, 0) != EOF ? "OK" : strerror(errno));
	close(fd1);
	printf("\n");
	
	printf("***** IPv6/UDP *****\n");
	fd1 = socket(PF_INET6, SOCK_DGRAM, 0);
	memset(&addr6, 0, sizeof(addr6));
	addr6.sin6_family = AF_INET6;
	addr6.sin6_addr = in6addr_loopback;
	addr6.sin6_port = htons(0);
	printf("bind(0): %s\n", bind(fd1, (struct sockaddr *) &addr6, sizeof(addr6)) == 0 ? "OK" : strerror(errno));
	size = sizeof(addr6); getsockname(fd1, (struct sockaddr *) &addr6, &size);
	printf("bound=%u\n", ntohs(addr6.sin6_port));
	close(fd1);
	printf("\n");

	fd1 = socket(PF_INET6, SOCK_DGRAM, 0);
	memset(&addr6, 0, sizeof(addr6));
	addr6.sin6_family = AF_INET6;
	addr6.sin6_addr = in6addr_loopback;
	addr6.sin6_port = htons(0);
	printf("connect(0): %s\n", connect(fd1, (struct sockaddr *) &addr6, sizeof(addr6)) == 0 ? "OK" : strerror(errno));
	size = sizeof(addr6); getsockname(fd1, (struct sockaddr *) &addr6, &size);
	printf("bound=%u\n", ntohs(addr6.sin6_port));
	close(fd1);
	printf("\n");

	fd1 = socket(PF_INET6, SOCK_DGRAM, 0);
	memset(&addr6, 0, sizeof(addr6));
	addr6.sin6_family = AF_INET6;
	addr6.sin6_addr = in6addr_loopback;
	addr6.sin6_port = htons(7);
	printf("sendto(7) without connection: %s\n", sendto(fd1, "", 1, 0, (struct sockaddr *) &addr6, sizeof(addr6)) != EOF ? "OK" : strerror(errno));
	close(fd1);
	printf("\n");

	fd2 = socket(PF_INET6, SOCK_DGRAM, 0);
	memset(&addr6, 0, sizeof(addr6));
	addr6.sin6_family = AF_INET6;
	addr6.sin6_addr = in6addr_loopback;
	addr6.sin6_port = htons(9);
	printf("bind(9): %s\n", bind(fd2, (struct sockaddr *) &addr6, sizeof(addr6)) == 0 ? "OK" : strerror(errno));
	fd1 = socket(PF_INET6, SOCK_DGRAM, 0);
	memset(&addr6, 0, sizeof(addr6));
	addr6.sin6_family = AF_INET6;
	addr6.sin6_addr = in6addr_loopback;
	addr6.sin6_port = htons(9);
	printf("connect(9): %s\n", connect(fd1, (struct sockaddr *) &addr6, sizeof(addr6)) == 0 ? "OK" : strerror(errno));
	printf("sendto(9): %s\n", sendto(fd1, "", 1, 0, (struct sockaddr *) &addr6, sizeof(addr6)) != EOF ? "OK" : strerror(errno));
	printf("send: %s\n", send(fd1, "", 1, 0) != EOF ? "OK" : strerror(errno));
	close(fd1);
	close(fd2);
	printf("\n");

	fd1 = socket(PF_INET6, SOCK_DGRAM, 0);
	printf("send without connection: %s\n", send(fd1, "", 1, 0) != EOF ? "OK" : strerror(errno));
	close(fd1);
	printf("\n");

	printf("***** IPv4/TCP *****\n");
	fd1 = socket(PF_INET, SOCK_STREAM, 0);
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	addr.sin_port = htons(0);
	printf("bind(0): %s\n", bind(fd1, (struct sockaddr *) &addr, sizeof(addr)) == 0 ? "OK" : strerror(errno));
	printf("listen: %s\n", listen(fd1, 5) == 0 ? "OK" : strerror(errno));
	size = sizeof(addr); getsockname(fd1, (struct sockaddr *) &addr, &size);
	fd2 = socket(PF_INET, SOCK_STREAM, 0);
	printf("connect(%u): %s\n", ntohs(addr.sin_port), connect(fd2, (struct sockaddr *) &addr, sizeof(addr)) == 0 ? "OK" : strerror(errno));
	printf("sendto(%u): %s\n", ntohs(addr.sin_port), sendto(fd2, "", 1, 0, (struct sockaddr *) &addr, sizeof(addr)) != EOF ? "OK" : strerror(errno));
	printf("send: %s\n", send(fd2, "", 1, 0) != EOF ? "OK" : strerror(errno));
	close(fd2);
	close(fd1);
	printf("\n");
	
	printf("***** IPv6/TCP *****\n");
	fd1 = socket(PF_INET6, SOCK_STREAM, 0);
	memset(&addr6, 0, sizeof(addr6));
	addr6.sin6_family = AF_INET;
	addr6.sin6_addr = in6addr_loopback;
	addr6.sin6_port = htons(0);
	printf("bind(0): %s\n", bind(fd1, (struct sockaddr *) &addr6, sizeof(addr6)) == 0 ? "OK" : strerror(errno));
	printf("listen: %s\n", listen(fd1, 5) == 0 ? "OK" : strerror(errno));
	size = sizeof(addr6); getsockname(fd1, (struct sockaddr *) &addr6, &size);
	fd2 = socket(PF_INET6, SOCK_STREAM, 0);
	printf("connect(%u): %s\n", ntohs(addr6.sin6_port), connect(fd2, (struct sockaddr *) &addr6, sizeof(addr6)) == 0 ? "OK" : strerror(errno));
	printf("sendto(%u): %s\n", ntohs(addr6.sin6_port), sendto(fd2, "", 1, 0, (struct sockaddr *) &addr6, sizeof(addr6)) != EOF ? "OK" : strerror(errno));
	printf("send: %s\n", send(fd2, "", 1, 0) != EOF ? "OK" : strerror(errno));
	close(fd2);
	close(fd1);
	printf("\n");
	
	return 0;
}
