#ifndef UNICONV_H
#define UNICONV_H

// most of the methods are allocate buffer by new[], so use delete[] for free memoy. 

//////////////////////////////////
// Native <-> Unicode Conversion
//////////////////////////////////

LPTSTR ConvSJIS2Unicode(const char *p);
char *ConvUnicode2SJIS(LPCTSTR p);

//////////////////////////////////
// TCHAR/WCHAR version of strdup
//////////////////////////////////
// not use malloc but use new[].

LPTSTR StringDup(LPCTSTR pStr);
LPWSTR StringDupW(LPCWSTR pStr);
char *StringDupA(const char *pStr);

//////////////////////////////////
// Length count 
//////////////////////////////////
#ifdef _WIN32_WCE
// count number of MBCS strings. return value are number of letters insted of bytes.
DWORD CountMBStrings(const char *pStr, DWORD nBytes);

// count number of UNICODE bytes. return value are number of bytes when pStr converts to MBCS.
DWORD CountWCBytes(LPCTSTR pStr, DWORD nChar);
#endif

//////////////////////////////////
// LPTSTR <-> LPWSTR conversion
//////////////////////////////////
// On CE platform, same as StringDup.
// On Windows platform, MBCS <-> WBCS conversion.

LPWSTR ConvTCharToWChar(LPCTSTR p);
LPTSTR ConvWCharToTChar(LPCWSTR p);

//////////////////////////////////
// TCHAR <-> UTF-8
//////////////////////////////////

char *ConvTCharToUTF8(LPCTSTR p);
LPTSTR ConvUTF8ToTChar(const char *p);

//////////////////////////////////
// UTF-8 <--> UCS2
//////////////////////////////////

LPWSTR ConvUTF8ToUCS2(const char *pUTFData);
char *ConvUCS2ToUTF8(LPCWSTR pStr);

DWORD ConvUTF8PosToUCSPos(const char *pUTF, DWORD nUTFPos);
DWORD ConvUCSPosToUTF8Pos(const char *pUTF, DWORD nUCSPos);

char *EscapeXMLStr(LPCTSTR pStr);

//////////////////////////////////
// JIS -> SJIS
//////////////////////////////////
// pOut͍ŒłpInƓ傫KvB

void ConvJIS2SJIS(const char *pIn, char *pOut);

//////////////////////////////////
// SJIS->JIS
//////////////////////////////////
// ͓̈IɊmۂ邽߁AsvɂȂ_ delete[] KvB

char *ConvSJIS2JIS(char *pStr);

//////////////////////////////////
// strncp
//////////////////////////////////
// nLen2oCgڂ؂ꍇA1oCgڂRs[ȂB
// ̂߁ASJIS̕ƂďɗLȕƂȂB

void CopyKanjiString(LPTSTR pDst, LPCTSTR pSrc, DWORD nLen);


//////////////////////////////////
// BASE64 Encode
//////////////////////////////////
//
// This encoder 

char *Base64Encode(const LPBYTE pBinary, DWORD nSrcLen);
LPBYTE Base64Decode(const char *pM64str, LPDWORD pDataSize);


#ifdef COMMENT
//////////////////////////////////
// BASE64 Decode
//////////////////////////////////

BOOL MimeDec(char *pDst, const char *pSrc);

//////////////////////////////////////////////////
// BASE64 Encode
//////////////////////////////////////////////////

// eGR[hPʂ75ɐ邽߁AGR[h͕̕sɓn\B
// 󂯂āAGR[hʂ͕̃XgƂĎĂB
// ̂߁ÄǗAGR[_̓NXƂĎB

// mۂ̈Base64EncoderǗ邽߁AJ̕Kv͂ȂB
// 
// GR[ĥ͍ƂISO-2022-JP(JIS)̂݁B̃R[hZbgɂĂ͂킩Ȃ̂(^^;lĂȂB
// 2byteł΁ȀCŉƂȂƂ͎v̂c

// ܂ABase64EncoderɐH킹ASCIIłĂGR[hB
// GR[h񂪑SASCIIłĂR[hZbg2022-JPƂȂB(Ƃ)

// GR[h邽߂ɂ́ABase64Encoder::Encode()ĂԁB
// GR[hꂽ擾ۂɂ́A Base64Encoder::Item *p;錾ĂāA
// p->Next()Ń[vBۂ̍sp->Value()Ŏ擾łB

class Base64Encoder{
public:
	class Item {
		char *pLine;
		Item *pNext;

		friend class Base64Encoder;
	public:
		Item *Next() { return (pNext && *(pNext->pLine) == 0) ? NULL : pNext; }
		const char *Line() { return pLine;}
	};

protected:

	Item *head, *tail;

	char *AllocLine();

	// pStrGR[hpBufɊi[B
	// pSize͌ĂяopBuf̃TCYB߂莞ɂ͖gp̈̈ʒu
	BOOL EncodeBuf(char *pBuf, DWORD *pSize, char *pStr);

	DWORD GetToken(char *p, BOOL *pKanji, DWORD *pType);

	// pStrpLineփGR[hB
	// 肫ȂꍇA ߂lƂăGR[ḧ̐擪ԂB
	char *EncodeLine(char *pStr, char *pLine, BOOL *pKanji);

public:

	Base64Encoder() : head(NULL), tail(NULL) {}
	~Base64Encoder();

	BOOL Encode(char *str);

	Item *First() { return head; }
};
#endif

//////////////////////////////////
// 픻ʗp}N
//////////////////////////////////

#if defined(TOMBO_LANG_ENGLISH)
#define iskanji(c) (0)
#define iskanji2(c) (0)
#else
#define iskanji(c) (((unsigned char)c) >= 0x81 && ((unsigned char)c) <= 0x9F || ((unsigned char)c)>=0xE0 && ((unsigned char)c) <= 0xFC)
#define iskanji2(c) (((unsigned char)c) >= 0x40 && ((unsigned char)c) <= 0xFC && ((unsigned char)c) != 0x7F)
#endif

//////////////////////////////////
// helper functions
//////////////////////////////////

// remove '\' 
// ex. aa\xx\ -> aa\xx
void ChopFileSeparator(LPTSTR pBuf);

void TrimRight(LPTSTR pBuf);

// Eliminate letters "\\/:,;*?<>\"\t" from pSrc.
// pDst has at least same size of pSrc
void DropInvalidFileChar(LPTSTR pDst, LPCTSTR pSrc);

LPCTSTR GetNextDirSeparator(LPCTSTR pStart);

// chop file name and leave path.
// ex. C:\foo\bar\baz.txt -> C:\foo\bar\ 
void GetFilePath(LPTSTR pPath, LPCTSTR pFullPath);

//////////////////////////////////
// Release buffer

// These function clear buffer to zero before release memory.

void WipeOutAndDelete(LPTSTR pMemo);
#ifdef _WIN32_WCE
void WipeOutAndDelete(char *pMemo);
#endif

//////////////////////////////////
// Delete file
// before deleting, write contents to zero.

BOOL WipeOutAndDeleteFile(LPCTSTR pFile);

#endif
