# -*- coding: utf-8 -*-

import sys
import os
import re
import unittest

script_dir = os.path.dirname(os.path.abspath(__file__))
base_dir = script_dir + os.sep + '../'
if not base_dir in sys.path:
    sys.path.insert(0, base_dir)
    
from dateutils import *

class ComponentManagerStub(object):
    components = {}

    def component_activated(self, dummy):
        pass

    def get_db_cnx(self):
        return DBStub()
    
class RequestStub(object):
    def __init__(self):
        self.href = HrefStub()
    
class HrefStub(object):
    def worktime(self, id):
        return 'worktime/%s' % id
  
class ConfigStub(object):
    def get(self, tag, key):
        pass

class DBStub(object):
    def __init__(self, row=None):
        self.row = row
    
    def cursor(self):
        print "cursor"
        return self
    
    def execute(self, sql , args):
        print "excecute"
        return self
    
    def fetchone(self):
        print "fetchone"
        return self.row 
    
    def commit(self):
        print "commit"
        
class DateUtilsTest(unittest.TestCase):

    def setUp(self):
        self.env = ComponentManagerStub()
        self.req = RequestStub()
        self.db = DBStub()
    
    def test_to_datetime(self):
        dt = to_datetime(day=1)
        self.assertEquals(1, dt.day)

        dt = to_datetime(day=99)
        dt = to_datetime(day='99')
        
        try:
            to_datetime(day='a')
        except ValueError, e:
            print e
    
    def test_cutoff_days(self):
        cutoffs = cutoff_days('15')
        from_day, to_day = cutoffs[0]
        
        self.assertEquals('2009-11-16', from_day.isoformat())
        self.assertEquals('2009-12-15', to_day.isoformat())
        
        from_day, to_day = cutoff_days('last')[0]
        
        self.assertEquals('2009-11-01', from_day.isoformat())
        self.assertEquals('2009-11-30', to_day.isoformat())
        
        one, two = cutoff_days('last', count=2)
        from_day, to_day = one[0], one[1]
        
        self.assertEquals('2009-11-01', from_day.isoformat())
        self.assertEquals('2009-11-30', to_day.isoformat())
        
        from_day, to_day = two[0], two[1]
        
        self.assertEquals('2009-10-01', from_day.isoformat())
        self.assertEquals('2009-10-31', to_day.isoformat())
        
        

if __name__ == '__main__':
    unittest.main()

