from setuptools import find_packages, setup
from trac.util.dist import get_l10n_cmdclass 

PACKAGE = 'tracsteinschart'


extra = {} 
cmdclass = get_l10n_cmdclass() 

if True:
    extra['cmdclass'] = cmdclass 
    extractors = [ 
       ('**.py',                'python', None), 
       ('**/templates/**.html', 'genshi', None), 
       ('**/templates/**.txt',  'genshi', { 
            'template_class': 'genshi.template:TextTemplate' 
       }), 
    ] 
    extra['message_extractors'] = { 
       PACKAGE: extractors, 
    } 


setup(name='TracSteinsChart',
      description='Plugin to make Trac support time estimation and tracking',
      keywords='trac plugin estimation timetracking',
      version='0.1.1',
      url='http://www.trac-hacks.org/wiki/TimingAndEstimationPlugin',
      license='http://www.opensource.org/licenses/mit-license.php',
      author='Russ Tyndall at Acceleration.net',
      author_email='russ@acceleration.net',
      long_description="""
      This Trac 0.11 plugin provides support for Time estimation and tracking.

      See http://trac-hacks.org/wiki/TimingAndEstimationPlugin for details.
      """,
      packages=find_packages(exclude=['*.tests*']),
      package_data={
          '': ['**/templates/*', '**/*.py'],
          'tracsteinschart' : ['htdocs/js/*.js', 'htdocs/js/plugins/*.js', 'htdocs/css/*.css', 'htdocs/images/*', 'locale/**/*.mo', 'locale/*.pot']
      },
      entry_points={'trac.plugins': [
              'tracsteinschart.chart = tracsteinschart.chart',
              'tracsteinschart.worktime = tracsteinschart.worktime',
          ],
      },
      **extra
)
