function requires(policy, requiredfields, labels) {
    var missing = [];
    if (condition(policy)) {
        for ( var i=0; i != requiredfields.length; i++ ) {
            var name = requiredfields[i];
            var field = $("#field-" + name);
            var valid = true;
            if (field.size() > 0) {
                valid = field.val() ? true : false;
            } else {
                var radios = $('form#propertyform input[name=field_' + name + ']');
                valid = radios.filter(':checked').size() > 0;
                field = radios.parent();
            }
            if (!valid) {
                field.addClass("error");
                missing.push(labels[name] || name);
            } else {
                field.removeClass("error");
            }
        }

        if (missing.length != 0) {
            var prestring, poststring;
            if (missing.length == 1) {
                prestring = missing[0] + " は必須項目です ";
                poststring = "この項目を入力してください.";
            }
            else {
                prestring = missing.join(", ") + " は必須項目です";
                poststring = "これらの項目を入力してください.";
            }
            
            return prestring + ".\n" + poststring;
        }
    }

    return true;
}

