using System;
using System.Collections.Generic;
using System.Text;
using XmlRpcProxy;

namespace TracXmlRpc
{
    public class TicketStatusProxy : ServiceProxy, ITicketStatus
    {
        public TicketStatusProxy()
        {
            this.MethodPrefix = "ticket.status";
        }

        public object[] GetAll()
        {
            return (object[])this.Invoke("getAll", new object[] { });
        }

        public string Get(string name)
        {
            return (string)this.Invoke("get", new object[] { name });
        }

        public int Delete(string name)
        {
            return (int)this.Invoke("delete", new object[] { name });
        }

        public int Create(string name, string value)
        {
            return (int)this.Invoke("cretate", new object[] { name, value });
        }

        public int Update(string name, string value)
        {
            return (int)this.Invoke("update", new object[] { name, value });
        }
    }
}
