﻿using System;
using System.Collections.Generic;
using System.Text;

namespace VSSLog2Trac
{
    /// <summary>
    /// Tracに対する接続情報を保持します。
    /// </summary>
    public class TracInfo
    {

        #region 定数
        public static readonly string SUBURL_LOGIN = "/login";
        public static readonly string SUBURL_TICKET = "/ticket/";
        #endregion

        #region プロパティ
        private string _url = null;
        private string _userId = null;
        private string _password = null;
        private int _ticketNo;
        private string _comment = null;

        /// <summary>
        /// TracサーバのURLを取得・設定します。
        /// </summary>
        public string URL
        {
            get
            {
                return _url;
            }
            set
            {
                _url = value;
            }
        }

        /// <summary>
        /// TracのユーザIDを取得・設定します。
        /// </summary>
        public string UserId
        {
            get
            {
                return _userId;
            }
            set
            {
                _userId = value;
            }
        }

        /// <summary>
        /// Tracのパスワードを取得・設定します。
        /// </summary>
        public string Password
        {
            get
            {
                return _password;
            }
            set
            {
                _password = value;
            }
        }

        /// <summary>
        /// チケット番号を取得・設定します。
        /// </summary>
        public int TicketNo
        {
            get
            {
                return _ticketNo;
            }
            set
            {
                _ticketNo = value;
            }
        }

        /// <summary>
        /// コメントを取得・設定します。
        /// </summary>
        public string Comment
        {
            get
            {
                return _comment;
            }
            set
            {
                _comment = value;
            }
        }

        #endregion


    }
}
