/*
 * Decompiled with CFR 0.152.
 */
package roboguice.util;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import roboguice.util.Ln;

public abstract class SafeAsyncTask<ResultT>
implements Callable<ResultT> {
    public static final int DEFAULT_POOL_SIZE = 25;
    protected static final Executor DEFAULT_EXECUTOR = Executors.newFixedThreadPool(25);
    protected Handler handler;
    protected Executor executor;
    protected StackTraceElement[] launchLocation;
    protected FutureTask<Void> future;

    public SafeAsyncTask() {
        this.executor = DEFAULT_EXECUTOR;
    }

    public SafeAsyncTask(Handler handler) {
        this.handler = handler;
        this.executor = DEFAULT_EXECUTOR;
    }

    public SafeAsyncTask(Executor executor) {
        this.executor = executor;
    }

    public SafeAsyncTask(Handler handler, Executor executor) {
        this.handler = handler;
        this.executor = executor;
    }

    public FutureTask<Void> future() {
        this.future = new FutureTask<Void>(this.newTask());
        return this.future;
    }

    public SafeAsyncTask<ResultT> executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Executor executor() {
        return this.executor;
    }

    public SafeAsyncTask<ResultT> handler(Handler handler) {
        this.handler = handler;
        return this;
    }

    public Handler handler() {
        return this.handler;
    }

    public void execute() {
        this.execute(Thread.currentThread().getStackTrace());
    }

    protected void execute(StackTraceElement[] launchLocation) {
        this.launchLocation = launchLocation;
        this.executor.execute(this.future());
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.future == null) {
            throw new UnsupportedOperationException("You cannot cancel this task before calling future()");
        }
        return this.future.cancel(mayInterruptIfRunning);
    }

    protected void onPreExecute() throws Exception {
    }

    protected void onSuccess(ResultT t) throws Exception {
    }

    protected void onInterrupted(Exception e) {
        this.onException(e);
    }

    protected void onException(Exception e) throws RuntimeException {
        this.onThrowable(e);
    }

    protected void onThrowable(Throwable t) throws RuntimeException {
        Log.e((String)"roboguice", (String)"Throwable caught during background processing", (Throwable)t);
    }

    protected void onFinally() throws RuntimeException {
    }

    protected Task<ResultT> newTask() {
        return new Task(this);
    }

    public static class Task<ResultT>
    implements Callable<Void> {
        protected SafeAsyncTask<ResultT> parent;
        protected Handler handler;

        public Task(SafeAsyncTask<ResultT> parent) {
            this.parent = parent;
            this.handler = parent.handler != null ? parent.handler : new Handler(Looper.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                this.doPreExecute();
                this.doSuccess(this.doCall());
            }
            catch (Exception e) {
                try {
                    this.doException(e);
                }
                catch (Exception f) {
                    Ln.e(f);
                }
            }
            catch (Throwable t) {
                try {
                    this.doThrowable(t);
                }
                catch (Exception f) {
                    Ln.e(f);
                }
            }
            finally {
                this.doFinally();
            }
            return null;
        }

        protected void doPreExecute() throws Exception {
            this.postToUiThreadAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Task.this.parent.onPreExecute();
                    return null;
                }
            });
        }

        protected ResultT doCall() throws Exception {
            return (ResultT)this.parent.call();
        }

        protected void doSuccess(final ResultT r) throws Exception {
            this.postToUiThreadAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Task.this.parent.onSuccess(r);
                    return null;
                }
            });
        }

        protected void doException(final Exception e) throws Exception {
            if (this.parent.launchLocation != null) {
                ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
                stack.addAll(Arrays.asList(this.parent.launchLocation));
                e.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
            }
            this.postToUiThreadAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                        Task.this.parent.onInterrupted(e);
                    } else {
                        Task.this.parent.onException(e);
                    }
                    return null;
                }
            });
        }

        protected void doThrowable(final Throwable e) throws Exception {
            if (this.parent.launchLocation != null) {
                ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
                stack.addAll(Arrays.asList(this.parent.launchLocation));
                e.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
            }
            this.postToUiThreadAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Task.this.parent.onThrowable(e);
                    return null;
                }
            });
        }

        protected void doFinally() throws Exception {
            this.postToUiThreadAndWait(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Task.this.parent.onFinally();
                    return null;
                }
            });
        }

        protected void postToUiThreadAndWait(final Callable c) throws Exception {
            final CountDownLatch latch = new CountDownLatch(1);
            final Exception[] exceptions = new Exception[1];
            this.handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        c.call();
                    }
                    catch (Exception e) {
                        exceptions[0] = e;
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            latch.await();
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }
    }
}

